/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftblib.client;

import com.feed_the_beast.ftblib.FTBLib;
import com.feed_the_beast.ftblib.FTBLibCommon;
import com.feed_the_beast.ftblib.FTBLibConfig;
import com.feed_the_beast.ftblib.client.BuiltinChunkMap;
import com.feed_the_beast.ftblib.client.ClientConfig;
import com.feed_the_beast.ftblib.client.FTBLibClientConfig;
import com.feed_the_beast.ftblib.client.SidebarButton;
import com.feed_the_beast.ftblib.client.SidebarButtonGroup;
import com.feed_the_beast.ftblib.command.client.CmdClientConfig;
import com.feed_the_beast.ftblib.command.client.CmdPrintItem;
import com.feed_the_beast.ftblib.command.client.CmdPrintState;
import com.feed_the_beast.ftblib.command.client.CmdSimulateButton;
import com.feed_the_beast.ftblib.lib.client.ClientUtils;
import com.feed_the_beast.ftblib.lib.client.ParticleColoredDust;
import com.feed_the_beast.ftblib.lib.gui.misc.ChunkSelectorMap;
import com.feed_the_beast.ftblib.lib.icon.PlayerHeadIcon;
import com.feed_the_beast.ftblib.lib.io.DataReader;
import com.feed_the_beast.ftblib.lib.net.MessageToClient;
import com.feed_the_beast.ftblib.lib.util.JsonUtils;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.resources.IReloadableResourceManager;
import net.minecraft.client.resources.IResource;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.client.resources.IResourceManagerReloadListener;
import net.minecraft.command.ICommand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.client.ClientCommandHandler;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;

public class FTBLibClient
extends FTBLibCommon
implements IResourceManagerReloadListener {
    public static final List<SidebarButtonGroup> SIDEBAR_BUTTON_GROUPS = new ArrayList<SidebarButtonGroup>();
    public static final Map<String, ClientConfig> CLIENT_CONFIG_MAP = new HashMap<String, ClientConfig>();

    @Override
    public void preInit(FMLPreInitializationEvent event) {
        super.preInit(event);
        FTBLibClientConfig.sync();
        ClientUtils.localPlayerHead = new PlayerHeadIcon(ClientUtils.MC.func_110432_I().func_148256_e().getId());
        ((IReloadableResourceManager)ClientUtils.MC.func_110442_L()).func_110542_a((IResourceManagerReloadListener)this);
        ChunkSelectorMap.setMap(new BuiltinChunkMap());
    }

    public void func_110549_a(IResourceManager manager) {
        JsonElement json;
        SIDEBAR_BUTTON_GROUPS.clear();
        CLIENT_CONFIG_MAP.clear();
        for (String domain : manager.func_135055_a()) {
            try {
                for (IResource resource : manager.func_135056_b(new ResourceLocation(domain, "client_config.json"))) {
                    for (Object e : DataReader.get(resource).json().getAsJsonArray()) {
                        ClientConfig c = new ClientConfig(e.getAsJsonObject());
                        CLIENT_CONFIG_MAP.put(c.id, c);
                    }
                }
            }
            catch (Exception ex) {
                if (ex instanceof FileNotFoundException) continue;
                ex.printStackTrace();
            }
        }
        JsonElement element = DataReader.get(new File(ClientUtils.MC.field_71412_D, "local/client/sidebar_buttons.json")).safeJson();
        JsonObject sidebarButtonConfig = element.isJsonObject() ? element.getAsJsonObject() : new JsonObject();
        HashMap<ResourceLocation, SidebarButtonGroup> groupMap = new HashMap<ResourceLocation, SidebarButtonGroup>();
        for (String domain : manager.func_135055_a()) {
            try {
                for (IResource resource : manager.func_135056_b(new ResourceLocation(domain, "sidebar_button_groups.json"))) {
                    json = DataReader.get(resource).json();
                    for (Map.Entry entry : json.getAsJsonObject().entrySet()) {
                        if (!((JsonElement)entry.getValue()).isJsonObject()) continue;
                        JsonObject groupJson = ((JsonElement)entry.getValue()).getAsJsonObject();
                        int y = 0;
                        if (groupJson.has("y")) {
                            y = groupJson.get("y").getAsInt();
                        }
                        SidebarButtonGroup group = new SidebarButtonGroup(new ResourceLocation(domain, (String)entry.getKey()), y);
                        groupMap.put(group.getId(), group);
                    }
                }
            }
            catch (Exception ex) {
                if (ex instanceof FileNotFoundException) continue;
                ex.printStackTrace();
            }
        }
        for (String domain : manager.func_135055_a()) {
            try {
                for (IResource resource : manager.func_135056_b(new ResourceLocation(domain, "sidebar_buttons.json"))) {
                    json = DataReader.get(resource).json();
                    if (!json.isJsonObject()) continue;
                    for (Map.Entry entry : json.getAsJsonObject().entrySet()) {
                        SidebarButtonGroup group;
                        JsonObject buttonJson;
                        if (!((JsonElement)entry.getValue()).isJsonObject() || !(buttonJson = ((JsonElement)entry.getValue()).getAsJsonObject()).has("group") || !FTBLibConfig.debugging.dev_sidebar_buttons && buttonJson.has("dev_only") && buttonJson.get("dev_only").getAsBoolean() || (group = (SidebarButtonGroup)groupMap.get(new ResourceLocation(buttonJson.get("group").getAsString()))) == null) continue;
                        SidebarButton button = new SidebarButton(new ResourceLocation(domain, (String)entry.getKey()), group, buttonJson);
                        group.getButtons().add(button);
                        if (sidebarButtonConfig.has(button.id.func_110624_b())) {
                            JsonElement e = sidebarButtonConfig.get(button.id.func_110624_b());
                            if (!e.isJsonObject() || !e.getAsJsonObject().has(button.id.func_110623_a())) continue;
                            button.setConfig(e.getAsJsonObject().get(button.id.func_110623_a()).getAsBoolean());
                            continue;
                        }
                        if (!sidebarButtonConfig.has(button.id.toString())) continue;
                        button.setConfig(sidebarButtonConfig.get(button.id.toString()).getAsBoolean());
                    }
                }
            }
            catch (Exception ex) {
                if (ex instanceof FileNotFoundException) continue;
                ex.printStackTrace();
            }
        }
        for (SidebarButtonGroup group : groupMap.values()) {
            if (group.getButtons().isEmpty()) continue;
            group.getButtons().sort(null);
            SIDEBAR_BUTTON_GROUPS.add(group);
        }
        SIDEBAR_BUTTON_GROUPS.sort(null);
        FTBLibClient.saveSidebarButtonConfig();
    }

    @Override
    public void postInit() {
        super.postInit();
        ClientCommandHandler.instance.func_71560_a((ICommand)new CmdClientConfig());
        ClientCommandHandler.instance.func_71560_a((ICommand)new CmdSimulateButton());
        ClientCommandHandler.instance.func_71560_a((ICommand)new CmdPrintItem());
        ClientCommandHandler.instance.func_71560_a((ICommand)new CmdPrintState());
    }

    @Override
    public void handleClientMessage(MessageToClient message) {
        if (FTBLibConfig.debugging.log_network) {
            FTBLib.LOGGER.info("Net RX: " + message.getClass().getName());
        }
        message.onMessage();
    }

    @Override
    public void spawnDust(World world, double x, double y, double z, float r, float g, float b, float a) {
        ClientUtils.spawnParticle((Particle)new ParticleColoredDust(world, x, y, z, r, g, b, a));
    }

    @Override
    public long getWorldTime() {
        return ClientUtils.MC.field_71441_e == null ? super.getWorldTime() : ClientUtils.MC.field_71441_e.func_82737_E();
    }

    public static void saveSidebarButtonConfig() {
        JsonObject o = new JsonObject();
        for (SidebarButtonGroup group : SIDEBAR_BUTTON_GROUPS) {
            for (SidebarButton button : group.getButtons()) {
                JsonObject o1 = o.getAsJsonObject(button.id.func_110624_b());
                if (o1 == null) {
                    o1 = new JsonObject();
                    o.add(button.id.func_110624_b(), (JsonElement)o1);
                }
                o1.addProperty(button.id.func_110623_a(), Boolean.valueOf(button.getConfig()));
            }
        }
        JsonUtils.toJsonSafe(new File(ClientUtils.MC.field_71412_D, "local/client/sidebar_buttons.json"), (JsonElement)o);
    }
}

