/*
 * Decompiled with CFR 0.152.
 */
package modmuss50.HardCoreMapReset;

import com.google.common.base.Charsets;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import javax.imageio.ImageIO;
import modmuss50.HardCoreMapReset.GuiMapList;
import modmuss50.HardCoreMapReset.ResetMaps;
import modmuss50.HardCoreMapReset.WorldInfo;
import org.apache.commons.io.FileUtils;

public class WorldDirectory
extends WorldInfo {
    public static Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private String name;
    private WorldInfo.AuthorData author;
    private File saveFile;

    public static WorldDirectory loadDir(File inputDir) throws IOException {
        WorldInfo.AuthorData authorData = null;
        File authorFile = new File(inputDir, "info.json");
        if (!authorFile.exists()) {
            FileUtils.writeStringToFile((File)authorFile, (String)GSON.toJson((Object)new WorldInfo.AuthorData()), (Charset)Charsets.UTF_8);
        } else {
            authorData = (WorldInfo.AuthorData)GSON.fromJson(FileUtils.readFileToString((File)authorFile, (Charset)Charsets.UTF_8), WorldInfo.AuthorData.class);
        }
        WorldDirectory worldDirectory = new WorldDirectory();
        worldDirectory.name = inputDir.getName();
        worldDirectory.author = authorData;
        worldDirectory.saveFile = inputDir;
        return worldDirectory;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public WorldInfo.AuthorData getAuthorData() {
        return this.author;
    }

    @Override
    public File getSaveFile() {
        return this.saveFile;
    }

    @Override
    public BufferedImage getIconImage() {
        File iconFile = new File(this.getSaveFile(), this.getAuthorData().thumbnail);
        if (!iconFile.exists()) {
            return null;
        }
        try {
            return ImageIO.read(iconFile);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public void copy(GuiMapList mapList) {
        ResetMaps.copyDirWorld(this, mapList.folderString, mapList);
    }
}

