/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.charset.lib.utils;

import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import pl.asie.charset.lib.capability.CapabilityHelper;
import pl.asie.charset.lib.utils.ItemUtils;

public final class FluidUtils {
    public static String getCorrectLocalizedName(FluidStack stack) {
        if (stack.getFluid() == FluidRegistry.WATER) {
            return I18n.func_74838_a((String)"tile.water.name");
        }
        if (stack.getFluid() == FluidRegistry.LAVA) {
            return I18n.func_74838_a((String)"tile.lava.name");
        }
        return stack.getLocalizedName();
    }

    private FluidUtils() {
    }

    private static FluidStack drain(IFluidHandler handler, int maxDrain, boolean doDrain, boolean isAutomated) {
        if (handler instanceof IFluidHandlerAutomationDetecting) {
            return ((IFluidHandlerAutomationDetecting)handler).drain(maxDrain, doDrain, isAutomated);
        }
        return handler.drain(maxDrain, doDrain);
    }

    private static FluidStack drain(IFluidHandler handler, FluidStack maxDrain, boolean doDrain, boolean isAutomated) {
        if (handler instanceof IFluidHandlerAutomationDetecting) {
            return ((IFluidHandlerAutomationDetecting)handler).drain(maxDrain, doDrain, isAutomated);
        }
        return handler.drain(maxDrain, doDrain);
    }

    public static Optional<ItemStack> handleTank(IFluidHandler tank, FluidStack fluidContained, World worldIn, BlockPos pos, ItemStack stack, boolean isCreative, boolean drainTank, boolean fillTank) {
        IFluidHandlerItem handler = (IFluidHandlerItem)CapabilityHelper.get(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, (ICapabilityProvider)stack, null);
        if (handler != null) {
            if (!worldIn.field_72995_K) {
                int amount;
                FluidStack fluidExtracted;
                boolean changed = false;
                if (fluidContained != null) {
                    FluidStack f = fluidContained.copy();
                    f.amount = 1000;
                    fluidExtracted = handler.drain(f, false);
                } else {
                    fluidExtracted = handler.drain(1000, false);
                }
                if (fluidExtracted == null) {
                    int amount2;
                    if (drainTank && (fluidExtracted = FluidUtils.drain(tank, 1000, false, false)) != null && (amount2 = handler.fill(fluidExtracted, false)) > 0) {
                        fluidExtracted.amount = amount2;
                        if ((fluidExtracted = FluidUtils.drain(tank, fluidExtracted, true, false)) != null) {
                            handler.fill(fluidExtracted, !isCreative);
                            changed = true;
                        }
                    }
                } else if (fillTank && (amount = tank.fill(fluidExtracted, false)) > 0) {
                    fluidExtracted.amount = amount;
                    if ((fluidExtracted = handler.drain(fluidExtracted, !isCreative)) != null) {
                        tank.fill(fluidExtracted, true);
                        changed = true;
                    }
                }
                if (changed) {
                    return Optional.of(handler.getContainer());
                }
            }
            return Optional.of(stack);
        }
        return Optional.empty();
    }

    public static boolean handleTank(IFluidHandler tank, FluidStack fluidContained, World worldIn, BlockPos pos, EntityPlayer playerIn, EnumHand hand) {
        return FluidUtils.handleTank(tank, fluidContained, worldIn, pos, playerIn, hand, false, false);
    }

    public static boolean handleTank(IFluidHandler tank, FluidStack fluidContained, World worldIn, BlockPos pos, EntityPlayer playerIn, EnumHand hand, boolean iterateAllDrain, boolean iterateAllFill) {
        if (iterateAllDrain || iterateAllFill) {
            boolean changed = false;
            for (int i = 0; i < playerIn.field_71071_by.field_70462_a.size() && (iterateAllFill || tank.drain(1, false) != null); ++i) {
                ItemStack stack = (ItemStack)playerIn.field_71071_by.field_70462_a.get(i);
                if (stack.func_190926_b()) continue;
                if (stack.func_190916_E() == 1) {
                    Optional<ItemStack> result = FluidUtils.handleTank(tank, fluidContained, worldIn, pos, stack, playerIn.func_184812_l_(), iterateAllDrain, iterateAllFill);
                    if (!result.isPresent()) continue;
                    ItemStack resultStack = result.get();
                    if (resultStack != stack) {
                        playerIn.field_71071_by.field_70462_a.set(i, (Object)resultStack);
                    }
                    changed = true;
                    continue;
                }
                ItemStack stackOne = stack.func_77946_l();
                stackOne.func_190920_e(1);
                Optional<ItemStack> result = FluidUtils.handleTank(tank, fluidContained, worldIn, pos, stackOne, playerIn.func_184812_l_(), iterateAllDrain, iterateAllFill);
                if (!result.isPresent()) continue;
                ItemStack resultStack = result.get();
                stack.func_190918_g(1);
                if (!playerIn.field_71071_by.func_70441_a(resultStack)) {
                    ItemUtils.spawnItemEntity(worldIn, playerIn.func_174791_d(), resultStack, 0.0f, 0.0f, 0.0f, 0.0f);
                    return changed;
                }
                changed = true;
            }
            return changed;
        }
        ItemStack stack = playerIn.func_184586_b(hand);
        if (stack.func_190926_b()) {
            return false;
        }
        if (stack.func_190916_E() == 1) {
            Optional<ItemStack> result = FluidUtils.handleTank(tank, fluidContained, worldIn, pos, stack, playerIn.func_184812_l_(), true, true);
            if (result.isPresent()) {
                ItemStack resultStack = result.get();
                if (resultStack != stack) {
                    playerIn.func_184611_a(hand, resultStack);
                }
                return true;
            }
            return false;
        }
        if (stack.func_190916_E() > 1) {
            ItemStack stackOne = stack.func_77946_l();
            stackOne.func_190920_e(1);
            Optional<ItemStack> result = FluidUtils.handleTank(tank, fluidContained, worldIn, pos, stackOne, playerIn.func_184812_l_(), true, true);
            if (result.isPresent()) {
                ItemStack resultStack = result.get();
                stack.func_190918_g(1);
                if (!playerIn.field_71071_by.func_70441_a(resultStack)) {
                    ItemUtils.spawnItemEntity(worldIn, playerIn.func_174791_d(), resultStack, 0.0f, 0.0f, 0.0f, 0.0f);
                }
                return true;
            }
            return false;
        }
        return false;
    }

    public static boolean matches(IFluidHandler handler, FluidStack stack) {
        IFluidTankProperties[] properties = handler.getTankProperties();
        if (properties != null) {
            for (IFluidTankProperties property : properties) {
                FluidStack match = property.getContents();
                if (match == null || !match.isFluidEqual(stack)) continue;
                return true;
            }
        }
        return false;
    }

    public static int push(IFluidHandler from, IFluidHandler to, int amt) {
        FluidStack drained;
        if (amt > 0 && (drained = from.drain(amt, false)) != null && drained.amount > 0 && (amt = to.fill(drained, true)) > 0) {
            FluidStack toDrain = drained.copy();
            toDrain.amount = amt;
            FluidStack drainedReal = from.drain(toDrain, true);
            return drainedReal != null ? drainedReal.amount : 0;
        }
        return 0;
    }

    public static int push(IFluidHandler from, IFluidHandler to, FluidStack pushed) {
        int amt;
        FluidStack drained;
        if (pushed != null && pushed.amount > 0 && (drained = from.drain(pushed, false)) != null && drained.amount > 0 && (amt = to.fill(drained, true)) > 0) {
            FluidStack toDrain = drained;
            toDrain.amount = amt;
            FluidStack drainedReal = from.drain(toDrain, true);
            return drainedReal != null ? drainedReal.amount : 0;
        }
        return 0;
    }

    public static interface IFluidHandlerAutomationDetecting
    extends IFluidHandler {
        @Nullable
        public FluidStack drain(int var1, boolean var2, boolean var3);

        @Nullable
        public FluidStack drain(FluidStack var1, boolean var2, boolean var3);
    }
}

