/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.charset.lib.recipe;

import com.google.common.base.Charsets;
import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.BufferedReader;
import java.io.Reader;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.util.Map;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.JsonContext;
import org.apache.commons.lang3.tuple.Pair;
import pl.asie.charset.ModCharset;
import pl.asie.charset.lib.recipe.IOutputSupplier;
import pl.asie.charset.lib.recipe.IOutputSupplierFactory;
import pl.asie.charset.lib.recipe.IngredientMatcher;
import pl.asie.charset.lib.recipe.RecipeCharset;
import pl.asie.charset.lib.utils.ModPathIterator;

public class OutputSupplier {
    private static final Gson GSON = new Gson();
    private static final Map<String, IOutputSupplierFactory> outputSuppliers = Maps.newHashMap();
    private static boolean initialized;

    private static void loadFactories(Pair<String, Path> p) {
        try {
            BufferedReader reader = Files.newBufferedReader((Path)p.getValue(), Charsets.UTF_8);
            JsonObject json = (JsonObject)JsonUtils.func_193839_a((Gson)GSON, (Reader)reader, JsonObject.class);
            if (json != null && json.has("charset:output_suppliers")) {
                JsonObject object = JsonUtils.func_152754_s((JsonObject)json, (String)"charset:output_suppliers");
                for (Map.Entry entry : object.entrySet()) {
                    String key = new ResourceLocation((String)p.getKey(), (String)entry.getKey()).toString();
                    String value = ((JsonElement)entry.getValue()).getAsString();
                    try {
                        Object o = Class.forName(value).newInstance();
                        if (o instanceof IOutputSupplierFactory) {
                            outputSuppliers.put(key, (IOutputSupplierFactory)o);
                            continue;
                        }
                        if (o instanceof IOutputSupplier) {
                            outputSuppliers.put(key, (a, b) -> (IOutputSupplier)o);
                            continue;
                        }
                        throw new Exception("Invalid OutputSupplier object type: " + (o != null ? o.getClass().getName() : "null"));
                    }
                    catch (Exception e) {
                        ModCharset.logger.warn("Could not create IOutputSupplierFactory " + value + ": " + e.getMessage());
                    }
                }
            }
        }
        catch (FileSystemNotFoundException | NoSuchFileException reader) {
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void initialize() {
        if (initialized) {
            return;
        }
        ModPathIterator.getValidPaths("assets/%1/recipes/_factories.json").forEach(OutputSupplier::loadFactories);
        initialized = true;
    }

    public static IOutputSupplier createOutputSupplier(JsonContext context, JsonObject json) {
        OutputSupplier.initialize();
        if (json.has("supplier")) {
            return outputSuppliers.get(JsonUtils.func_151200_h((JsonObject)json, (String)"supplier")).parse(context, json);
        }
        return new Stack(CraftingHelper.getItemStack((JsonObject)json, (JsonContext)context));
    }

    public static IOutputSupplier createStackOutputSupplier(ItemStack stack) {
        return new Stack(stack);
    }

    private static class Stack
    implements IOutputSupplier {
        private final ItemStack stack;

        Stack(ItemStack stack) {
            this.stack = stack;
        }

        @Override
        public ItemStack getCraftingResult(RecipeCharset recipe, IngredientMatcher matcher, InventoryCrafting inv) {
            return this.stack.func_77946_l();
        }

        @Override
        public ItemStack getDefaultOutput() {
            return this.stack;
        }
    }
}

