/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.charset.lib.modcompat.tis3d;

import javax.annotation.Nullable;
import li.cil.tis3d.api.serial.SerialInterface;
import li.cil.tis3d.api.serial.SerialInterfaceProvider;
import li.cil.tis3d.api.serial.SerialProtocolDocumentationReference;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public abstract class SerialInterfaceTile<T extends TileEntity>
implements SerialInterface {
    protected final T tile;

    protected SerialInterfaceTile(T tile) {
        this.tile = tile;
    }

    public static class Provider<T extends TileEntity>
    implements SerialInterfaceProvider {
        private final Supplier<T> supplier;
        private final Class<T> cl;
        private final Verifier<T> verifier;

        public Provider(Class<T> cl, Supplier<T> supplier) {
            this(cl, supplier, (a, b) -> true);
        }

        public Provider(Class<T> cl, Supplier<T> supplier, Verifier<T> verifier) {
            this.cl = cl;
            this.supplier = supplier;
            this.verifier = verifier;
        }

        public boolean worksWith(World world, BlockPos blockPos, EnumFacing enumFacing) {
            TileEntity tile = world.func_175625_s(blockPos);
            if (this.cl.isInstance(tile)) {
                return this.verifier.worksWith(tile, enumFacing);
            }
            return false;
        }

        @Nullable
        public SerialInterface interfaceFor(World world, BlockPos blockPos, EnumFacing enumFacing) {
            TileEntity tile = world.func_175625_s(blockPos);
            if (this.cl.isInstance(tile)) {
                return this.supplier.apply(tile, enumFacing);
            }
            return null;
        }

        @Nullable
        public SerialProtocolDocumentationReference getDocumentationReference() {
            return null;
        }

        public boolean isValid(World world, BlockPos blockPos, EnumFacing enumFacing, SerialInterface serialInterface) {
            return serialInterface instanceof SerialInterfaceTile && !((SerialInterfaceTile)serialInterface).tile.func_145837_r();
        }
    }

    @FunctionalInterface
    public static interface Supplier<T extends TileEntity> {
        public SerialInterface apply(T var1, EnumFacing var2);
    }

    @FunctionalInterface
    public static interface Verifier<T extends TileEntity> {
        public boolean worksWith(T var1, EnumFacing var2);
    }
}

