/*
 * Decompiled with CFR 0.152.
 */
package org.dave.bonsaitrees.api;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import org.dave.bonsaitrees.api.IBonsaiTreeType;
import org.dave.bonsaitrees.api.TreeTypeDrop;

public class TreeTypeSimple
implements IBonsaiTreeType {
    private String name;
    private ItemStack sapling = ItemStack.field_190927_a;
    private List<TreeTypeDrop> drops = new ArrayList<TreeTypeDrop>();
    private WorldGenerator worldGen = null;
    private Set<String> compatibleSoilTags = new HashSet<String>();

    public TreeTypeSimple(String name, ItemStack sapling) {
        this.name = name;
        this.sapling = sapling;
    }

    public TreeTypeSimple(String name, String saplingName, int saplingMeta) {
        ResourceLocation saplingNameResource = new ResourceLocation(saplingName);
        Block block = (Block)ForgeRegistries.BLOCKS.getValue(saplingNameResource);
        if (block != null && block != Blocks.field_150350_a) {
            this.sapling = new ItemStack(block, 1, saplingMeta);
        } else {
            Item item = (Item)ForgeRegistries.ITEMS.getValue(saplingNameResource);
            if (item != null) {
                this.sapling = new ItemStack(item, 1, saplingMeta);
            }
        }
        this.name = name;
    }

    public void addDrop(ItemStack stack, float chance) {
        this.drops.add(new TreeTypeDrop(stack.func_77946_l(), chance));
    }

    public void addDrop(String itemName, int count, int itemMeta, float chance) {
        Block dropBlock = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(itemName));
        if (dropBlock != null && dropBlock != Blocks.field_150350_a) {
            this.drops.add(new TreeTypeDrop(new ItemStack(dropBlock, count, itemMeta), chance));
            return;
        }
        Item dropItem = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(itemName));
        if (dropItem != null) {
            this.drops.add(new TreeTypeDrop(new ItemStack(dropItem, count, itemMeta), chance));
            return;
        }
    }

    public void addCompatibleSoilTag(String tag) {
        this.compatibleSoilTags.add(tag);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public List<TreeTypeDrop> getDrops() {
        return this.drops;
    }

    @Override
    public boolean worksWith(ItemStack stack) {
        boolean sameMeta;
        boolean sameItem = this.sapling.func_77973_b() == stack.func_77973_b();
        boolean bl = sameMeta = this.sapling.func_77960_j() == stack.func_77960_j();
        return sameItem && sameMeta;
    }

    @Override
    public Set<String> getCompatibleSoilTags() {
        if (this.compatibleSoilTags == null || this.compatibleSoilTags.size() == 0) {
            return new HashSet<String>(Arrays.asList("dirt", "grass"));
        }
        return this.compatibleSoilTags;
    }

    @Override
    public ItemStack getExampleStack() {
        return this.sapling.func_77946_l();
    }

    public WorldGenerator getWorldGen() {
        return this.worldGen;
    }

    public void setWorldGen(WorldGenerator worldGen) {
        this.worldGen = worldGen;
    }
}

