/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.surge.mixins.minecraft.client.audio;

import java.io.InputStream;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.darkhax.surge.core.SurgeConfiguration;
import net.minecraft.client.audio.SoundEventAccessor;
import net.minecraft.client.audio.SoundHandler;
import net.minecraft.client.audio.SoundList;
import net.minecraft.client.audio.SoundManager;
import net.minecraft.client.audio.SoundRegistry;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.resources.IResource;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.Tuple;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.fml.common.ProgressManager;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={SoundHandler.class})
public class MixinSoundHandler {
    @Shadow
    private static final Logger field_147698_b = LogManager.getLogger();
    @Shadow
    private final SoundRegistry field_147697_e = new SoundRegistry();
    @Shadow
    private SoundManager field_147694_f;

    @Shadow
    private void func_147693_a(ResourceLocation location, SoundList sounds) {
    }

    @Shadow
    protected Map<String, SoundList> func_175085_a(InputStream stream) {
        return null;
    }

    @Inject(method={"onResourceManagerReload(Lnet/minecraft/client/resources/IResourceManager;)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void onResourceManagerReload(IResourceManager resourceManager, CallbackInfo info) {
        this.field_147697_e.func_148763_c();
        LinkedList<Tuple<ResourceLocation, SoundList>> soundLists = new LinkedList<Tuple<ResourceLocation, SoundList>>();
        this.loadSoundLists(resourceManager, soundLists);
        this.loadSounds(soundLists);
        if (!SurgeConfiguration.disableDebugSoundInfo) {
            this.debugSounds();
        }
        this.field_147694_f.func_148596_a();
        info.cancel();
    }

    private void loadSounds(List<Tuple<ResourceLocation, SoundList>> soundLists) {
        ProgressManager.ProgressBar resourcesBar = ProgressManager.push((String)"Loading sounds", (int)soundLists.size());
        for (Tuple<ResourceLocation, SoundList> soundList : soundLists) {
            resourcesBar.step(((ResourceLocation)soundList.func_76341_a()).toString());
            try {
                this.func_147693_a((ResourceLocation)soundList.func_76341_a(), (SoundList)soundList.func_76340_b());
            }
            catch (RuntimeException e) {
                field_147698_b.warn("Invalid sounds.json", (Throwable)e);
            }
        }
        ProgressManager.pop((ProgressManager.ProgressBar)resourcesBar);
    }

    private void loadSoundLists(IResourceManager resourceManager, List<Tuple<ResourceLocation, SoundList>> soundLists) {
        for (String s : resourceManager.func_135055_a()) {
            try {
                for (IResource managerSoundList : resourceManager.func_135056_b(new ResourceLocation(s, "sounds.json"))) {
                    for (Map.Entry<String, SoundList> entry : this.func_175085_a(managerSoundList.func_110527_b()).entrySet()) {
                        soundLists.add((Tuple<ResourceLocation, SoundList>)new Tuple((Object)new ResourceLocation(s, entry.getKey()), (Object)entry.getValue()));
                    }
                }
            }
            catch (Exception exception) {
            }
        }
    }

    private void debugSounds() {
        for (ResourceLocation resourcelocation : this.field_147697_e.func_148742_b()) {
            String s1;
            if (SoundEvent.field_187505_a.func_82594_a((Object)resourcelocation) == null) {
                field_147698_b.debug("Missing sound event: {}", (Object)resourcelocation);
                continue;
            }
            SoundEventAccessor accessor = (SoundEventAccessor)this.field_147697_e.func_82594_a((Object)resourcelocation);
            if (!(accessor.func_188712_c() instanceof TextComponentTranslation) || I18n.func_188566_a((String)(s1 = ((TextComponentTranslation)accessor.func_188712_c()).func_150268_i()))) continue;
            field_147698_b.debug("Missing subtitle {} for event: {}", (Object)s1, (Object)resourcelocation);
        }
    }
}

