/*
 * Decompiled with CFR 0.152.
 */
package me.modmuss50.loadingtips;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.List;
import java.util.Random;
import me.modmuss50.loadingtips.LoadingTipsConfig;
import net.minecraft.client.gui.FontRenderer;
import net.minecraftforge.fml.client.SplashProgress;
import org.lwjgl.opengl.GL11;

public class LoadingTipsHooks {
    private static FontRenderer fontRenderer = null;
    private static LoadingTipsConfig config;
    private static int frames;
    private static String tip;
    private static int tipId;
    private static Random random;

    private static void setup() {
        try {
            Field field = SplashProgress.class.getDeclaredField("fontRenderer");
            field.setAccessible(true);
            fontRenderer = (FontRenderer)field.get(null);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to setup Loading Tips", e);
        }
        File confDir = new File("config");
        try {
            config = LoadingTipsConfig.load(new File(confDir, "loadingtips.json"));
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to load loadingtips config", e);
        }
        config.loadOnline(LoadingTipsHooks::nextTip);
        LoadingTipsHooks.nextTip();
    }

    public static void draw() {
        if (fontRenderer == null) {
            LoadingTipsHooks.setup();
        }
        if (config == null || LoadingTipsHooks.config.tips.isEmpty()) {
            return;
        }
        GL11.glPushMatrix();
        GL11.glTranslatef((float)0.0f, (float)0.0f, (float)0.0f);
        LoadingTipsHooks.drawString(tip, LoadingTipsHooks.config.color);
        GL11.glPopMatrix();
        if (++frames % 500 == 0) {
            LoadingTipsHooks.nextTip();
        }
    }

    private static void nextTip() {
        List<String> tips = config.getTips();
        if (tips.isEmpty()) {
            tip = "";
            System.out.println("no tips in config");
            return;
        }
        if (++tipId >= tips.size()) {
            tipId = 0;
        }
        tip = tips.get(tipId);
        System.out.println("tip: " + tip);
    }

    private static void drawString(String text, int col) {
        GL11.glPushMatrix();
        GL11.glPushMatrix();
        LoadingTipsHooks.color(col);
        GL11.glScalef((float)2.0f, (float)2.0f, (float)1.0f);
        GL11.glEnable((int)3553);
        fontRenderer.func_78276_b(text, 35, 80, 0);
        GL11.glDisable((int)3553);
        GL11.glPopMatrix();
        GL11.glPopMatrix();
    }

    private static void color(int color) {
        GL11.glColor3ub((byte)((byte)(color >> 16 & 0xFF)), (byte)((byte)(color >> 8 & 0xFF)), (byte)((byte)(color & 0xFF)));
    }

    static {
        frames = 1;
        tipId = 0;
        random = new Random();
    }
}

