/*
 * Decompiled with CFR 0.152.
 */
package me.modmuss50.loadingtips;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;

public class LoadingTipsConfig {
    public int color = 0;
    public String url = "";
    public List<String> tips = new ArrayList<String>();
    public transient List<String> onlineTips = null;
    public transient List<String> allTips;
    private transient boolean refreshList = false;
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();

    public static LoadingTipsConfig load(File configFile) throws IOException {
        if (configFile.exists()) {
            String json = FileUtils.readFileToString((File)configFile, (Charset)StandardCharsets.UTF_8);
            LoadingTipsConfig config = (LoadingTipsConfig)GSON.fromJson(json, LoadingTipsConfig.class);
            return config;
        }
        LoadingTipsConfig config = new LoadingTipsConfig();
        config.tips.add("This is an example tip");
        config.tips.add("Change your tips by editing loadingtips.json");
        String json = GSON.toJson((Object)config);
        FileUtils.writeStringToFile((File)configFile, (String)json, (Charset)StandardCharsets.UTF_8);
        return config;
    }

    public void loadOnline(Runnable complete) {
        if (this.url.isEmpty()) {
            return;
        }
        new Thread(() -> {
            try {
                String onlineJson = IOUtils.toString((URL)new URL(this.url), (Charset)StandardCharsets.UTF_8);
                this.onlineTips = (List)GSON.fromJson(onlineJson, new TypeToken<List<String>>(){}.getType());
                this.refreshList = true;
                complete.run();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }).start();
    }

    public List<String> getTips() {
        if (this.refreshList || this.tips == null) {
            this.tips = this.getAllTips();
            Collections.shuffle(this.tips);
        }
        return this.tips;
    }

    private List<String> getAllTips() {
        if (this.onlineTips == null) {
            return this.tips.stream().filter(s -> !s.isEmpty()).collect(Collectors.toList());
        }
        return Stream.concat(this.tips.stream(), this.onlineTips.stream()).filter(s -> !s.isEmpty()).collect(Collectors.toList());
    }
}

