/*
 * Decompiled with CFR 0.152.
 */
package com.latmod.mods.resourcereloader;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.latmod.mods.resourcereloader.CommandReloadResources;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Field;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.IResource;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.client.resources.IResourceManagerReloadListener;
import net.minecraft.command.ICommand;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.ClientCommandHandler;
import net.minecraftforge.client.resource.IResourceType;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(modid="resourcereloader", name="Resource Reloader", version="1.0.2.5", clientSideOnly=true, dependencies="required-after:forge@[14.23.4.2743,)", acceptedMinecraftVersions="[1.12.2]")
public class ResourceReloader {
    public static final String MOD_ID = "resourcereloader";
    public static final String MOD_NAME = "Resource Reloader";
    public static final String VERSION = "1.0.2.5";
    public static final Logger LOGGER = LogManager.getLogger((String)"Resource Reloader");
    public static final Map<String, IResourceType> GROUP_MAP = new HashMap<String, IResourceType>();
    public static final Map<String, Class> LISTENER_NAME_MAP = new HashMap<String, Class>();
    public static final List<String> COMMAND_TAB = new ArrayList<String>();

    @Mod.EventHandler
    public void onPostInit(FMLPostInitializationEvent event) {
        IResourceManager manager = Minecraft.func_71410_x().func_110442_L();
        HashMap groups = new HashMap();
        HashMap listeners = new HashMap();
        for (String string : manager.func_135055_a()) {
            try {
                for (IResource resource : Minecraft.func_71410_x().func_110442_L().func_135056_b(new ResourceLocation(string, "resource_reloader.json"))) {
                    InputStream stream = resource.func_110527_b();
                    Throwable throwable = null;
                    try {
                        JsonElement element = new JsonParser().parse((Reader)new InputStreamReader(stream, StandardCharsets.UTF_8));
                        if (!(element instanceof JsonObject)) continue;
                        JsonObject json = element.getAsJsonObject();
                        if (json.has("groups")) {
                            for (Map.Entry entry : json.get("groups").getAsJsonObject().entrySet()) {
                                groups.put(entry.getKey(), ((JsonElement)entry.getValue()).getAsString());
                            }
                        }
                        if (!json.has("listeners")) continue;
                        for (Map.Entry entry : json.get("listeners").getAsJsonObject().entrySet()) {
                            listeners.put(entry.getKey(), ((JsonElement)entry.getValue()).getAsString());
                        }
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (stream == null) continue;
                        if (throwable != null) {
                            try {
                                stream.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        stream.close();
                    }
                }
            }
            catch (Exception exception) {
            }
        }
        for (Map.Entry entry : groups.entrySet()) {
            try {
                int idx = ((String)entry.getValue()).lastIndexOf(46);
                Class<?> clazz = Class.forName(((String)entry.getValue()).substring(0, idx));
                Field field = clazz.getField(((String)entry.getValue()).substring(idx + 1));
                Object object = field.get(null);
                if (!(object instanceof IResourceType)) continue;
                GROUP_MAP.put(((String)entry.getKey()).trim().toLowerCase(), (IResourceType)object);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        for (Map.Entry entry : listeners.entrySet()) {
            try {
                Class<?> clazz = Class.forName((String)entry.getValue());
                if (!IResourceManagerReloadListener.class.isAssignableFrom(clazz)) continue;
                LISTENER_NAME_MAP.put(((String)entry.getKey()).trim().toLowerCase(), clazz);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        COMMAND_TAB.addAll(LISTENER_NAME_MAP.keySet());
        for (String string : GROUP_MAP.keySet()) {
            COMMAND_TAB.add('#' + string);
        }
        COMMAND_TAB.sort(null);
        COMMAND_TAB.add("$");
        LOGGER.info("Loaded " + groups.size() + " groups and " + LISTENER_NAME_MAP.size() + " reload listeners");
        ClientCommandHandler.instance.func_71560_a((ICommand)new CommandReloadResources());
    }
}

