/*
 * Decompiled with CFR 0.152.
 */
package com.latmod.mods.resourcereloader;

import com.latmod.mods.resourcereloader.ResourceReloader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.client.resources.IResourceManagerReloadListener;
import net.minecraft.client.resources.SimpleReloadableResourceManager;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.WrongUsageException;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.event.ClickEvent;
import net.minecraft.util.text.event.HoverEvent;
import net.minecraftforge.client.resource.IResourceType;
import net.minecraftforge.fml.client.FMLClientHandler;

public class CommandReloadResources
extends CommandBase {
    public String func_71517_b() {
        return "reload_resources";
    }

    public List<String> func_71514_a() {
        return Collections.singletonList("rr");
    }

    public final List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, @Nullable BlockPos targetPos) {
        if (args.length == 1) {
            return CommandReloadResources.func_175762_a((String[])args, ResourceReloader.COMMAND_TAB);
        }
        return Collections.emptyList();
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        if (args.length < 1) {
            throw new WrongUsageException("command.reload_resources.usage", new Object[0]);
        }
        if (args[0].equals("$")) {
            if (args.length < 2) {
                sender.func_145747_a((ITextComponent)new TextComponentString("---"));
                HashSet<String> set = new HashSet<String>();
                for (Object listener : ((SimpleReloadableResourceManager)Minecraft.func_71410_x().func_110442_L()).field_110546_b) {
                    String string = listener.getClass().getName();
                    if (string.contains("$$")) continue;
                    set.add(string);
                }
                ArrayList list = new ArrayList(set);
                list.sort(null);
                for (String string : list) {
                    int idx = string.lastIndexOf(46);
                    TextComponentString c = new TextComponentString(string.substring(0, idx) + ".");
                    c.func_150256_b().func_150238_a(TextFormatting.GRAY);
                    TextComponentString c2 = new TextComponentString(string.substring(idx + 1));
                    c2.func_150256_b().func_150238_a(TextFormatting.WHITE);
                    c.func_150257_a((ITextComponent)c2);
                    c.func_150256_b().func_150241_a(new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, "/reload_resources $ " + string));
                    sender.func_145747_a((ITextComponent)c);
                }
                sender.func_145747_a((ITextComponent)new TextComponentString("---"));
            } else {
                Class<?> clazz = null;
                try {
                    clazz = Class.forName(args[1]);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                if (clazz == null) {
                    throw new CommandException("command.reload_resources.no_name", new Object[0]);
                }
                long start = System.currentTimeMillis();
                IResourceManager iResourceManager = Minecraft.func_71410_x().func_110442_L();
                for (IResourceManagerReloadListener listener : ((SimpleReloadableResourceManager)Minecraft.func_71410_x().func_110442_L()).field_110546_b) {
                    if (listener.getClass() != clazz) continue;
                    listener.func_110549_a(iResourceManager);
                }
                long time = System.currentTimeMillis() - start;
                String t = time < 1000L ? time + "ms" : String.format("%.02fs", (double)time / 1000.0);
                sender.func_145747_a((ITextComponent)new TextComponentTranslation("command.reload_resources.reloaded_name", new Object[]{args[1], t}));
            }
        } else if (args[0].startsWith("#")) {
            String group = args[0].substring(1).trim();
            IResourceType type = ResourceReloader.GROUP_MAP.get(group);
            if (type == null) {
                throw new CommandException("command.reload_resources.no_group", new Object[0]);
            }
            long start = System.currentTimeMillis();
            FMLClientHandler.instance().refreshResources(new IResourceType[]{type});
            long time = System.currentTimeMillis() - start;
            String t = time < 1000L ? time + "ms" : String.format("%.02fs", (double)time / 1000.0);
            TextComponentString n = new TextComponentString(group);
            n.func_150256_b().func_150209_a(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (ITextComponent)new TextComponentString(type.getClass().getName())));
            sender.func_145747_a((ITextComponent)new TextComponentTranslation("command.reload_resources.reloaded_group", new Object[]{n, t}));
        } else {
            Class clazz = ResourceReloader.LISTENER_NAME_MAP.get(args[0]);
            if (clazz == null) {
                throw new CommandException("command.reload_resources.no_name", new Object[0]);
            }
            long start = System.currentTimeMillis();
            IResourceManager iResourceManager = Minecraft.func_71410_x().func_110442_L();
            for (IResourceManagerReloadListener listener : ((SimpleReloadableResourceManager)Minecraft.func_71410_x().func_110442_L()).field_110546_b) {
                if (listener.getClass() != clazz) continue;
                listener.func_110549_a(iResourceManager);
            }
            long time = System.currentTimeMillis() - start;
            String t = time < 1000L ? time + "ms" : String.format("%.02fs", (double)time / 1000.0);
            TextComponentString n = new TextComponentString(args[0]);
            n.func_150256_b().func_150209_a(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (ITextComponent)new TextComponentString(clazz.getName())));
            sender.func_145747_a((ITextComponent)new TextComponentTranslation("command.reload_resources.reloaded_name", new Object[]{n, t}));
        }
    }

    public String func_71518_a(ICommandSender sender) {
        return "command.reload_resources.usage";
    }

    public int func_82362_a() {
        return 0;
    }

    public boolean func_184882_a(MinecraftServer server, ICommandSender sender) {
        return true;
    }
}

