/*
 * Decompiled with CFR 0.152.
 */
package openmods.gui.component;

import openmods.gui.IComponentParent;
import openmods.gui.component.BaseComponent;
import openmods.gui.component.BaseComposite;

public class GuiComponentHCenter
extends BaseComposite {
    private int width;
    private int height;

    public GuiComponentHCenter(int x, int y, int width) {
        super(x, y);
        this.width = width;
    }

    @Override
    public void init(IComponentParent parent) {
        super.init(parent);
        for (BaseComponent c : this.components) {
            if (this.width >= 0) {
                int x = (this.width - c.getWidth()) / 2;
                c.setX(x);
            }
            this.height = Math.max(this.height, c.getY() + c.getHeight());
        }
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    public static BaseComposite wrap(int x, int y, int width, BaseComponent component) {
        return new GuiComponentHCenter(x, y, width).addComponent(component);
    }
}

