/*
 * Decompiled with CFR 0.152.
 */
package techreborn.compatmod.ic2;

import ic2.api.item.IC2Items;
import ic2.core.item.tool.ItemTreetap;
import ic2.core.ref.ItemName;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import reborncore.api.recipe.IBaseRecipeType;
import reborncore.api.recipe.RecipeHandler;
import reborncore.common.registration.RebornRegistry;
import reborncore.common.util.RebornCraftingHelper;
import techreborn.api.IC2Helper;
import techreborn.api.TechRebornAPI;
import techreborn.api.recipe.machines.CompressorRecipe;
import techreborn.api.recipe.machines.ExtractorRecipe;
import techreborn.api.recipe.machines.GrinderRecipe;
import techreborn.compat.ICompatModule;
import techreborn.compatmod.ic2.IC2Dict;
import techreborn.init.ModBlocks;
import techreborn.init.ModItems;
import techreborn.init.recipes.ChemicalReactorRecipes;
import techreborn.init.recipes.RecipeMethods;
import techreborn.items.ingredients.ItemParts;

@RebornRegistry(modOnly="ic2,!ic2-classic-spmod", modID="techreborn")
public class IC2Module
implements ICompatModule,
IC2Helper {
    List<RecipeDuplicate> recipeDuplicateList = new ArrayList<RecipeDuplicate>();

    public void preInit(FMLPreInitializationEvent event) {
        MinecraftForge.EVENT_BUS.register((Object)this);
        TechRebornAPI.ic2Helper = this;
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public void registerRecipes(RegistryEvent.Register<IRecipe> event) {
        this.recipeDuplicateList.add(new RecipeDuplicate(new ItemStack(ModBlocks.MACHINE_FRAMES, 1, 0), IC2Items.getItem((String)"resource", (String)"machine")));
        for (RecipeDuplicate duplicate : this.recipeDuplicateList) {
            duplicate.add();
        }
        RebornCraftingHelper.addShapelessRecipe((ItemStack)ItemParts.getPartByName((String)"rubber"), (Object[])new Object[]{IC2Items.getItem((String)"crafting", (String)"rubber")});
        RebornCraftingHelper.addShapelessRecipe((ItemStack)IC2Items.getItem((String)"crafting", (String)"rubber"), (Object[])new Object[]{ItemParts.getPartByName((String)"rubber")});
        RebornCraftingHelper.addShapelessRecipe((ItemStack)IC2Items.getItem((String)"electric_wrench"), (Object[])new Object[]{new ItemStack(ModItems.WRENCH), IC2Items.getItem((String)"crafting", (String)"small_power_unit")});
        RecipeHandler.addRecipe((IBaseRecipeType)new CompressorRecipe((Object)IC2Items.getItem((String)"crafting", (String)"carbon_mesh"), IC2Items.getItem((String)"crafting", (String)"carbon_plate"), 300, 4));
        RecipeHandler.addRecipe((IBaseRecipeType)new CompressorRecipe((Object)IC2Items.getItem((String)"crafting", (String)"coal_ball"), IC2Items.getItem((String)"crafting", (String)"coal_block"), 300, 4));
        RecipeHandler.addRecipe((IBaseRecipeType)new GrinderRecipe((Object)ItemName.crafting.getItemStack("tin_can"), RecipeMethods.getOre((String)"dustTin", (int)2), 300, 16));
        RecipeHandler.addRecipe((IBaseRecipeType)new ExtractorRecipe((Object)ItemName.filled_tin_can.getItemStack(), ItemName.crafting.getItemStack("tin_can"), 300, 16));
        ItemStack f = IC2Items.getItem((String)"crop_res", (String)"fertilizer");
        ChemicalReactorRecipes.register((ItemStack)RecipeMethods.getMaterial((String)"calcite", (RecipeMethods.Type)RecipeMethods.Type.DUST), (ItemStack)RecipeMethods.getMaterial((String)"sulfur", (RecipeMethods.Type)RecipeMethods.Type.DUST), (ItemStack)f, (int)40);
    }

    public void initDuplicates() {
        IC2Dict.init();
    }

    public boolean extractSap(EntityPlayer player, World world, BlockPos pos, EnumFacing side, IBlockState state, List<ItemStack> stacks) {
        if (state.func_177230_c() != Block.func_149634_a((Item)IC2Items.getItem((String)"rubber_wood").func_77973_b())) {
            return false;
        }
        return ItemTreetap.attemptExtract((EntityPlayer)player, (World)world, (BlockPos)pos, (EnumFacing)side, (IBlockState)state, null);
    }

    public class RecipeDuplicate {
        ItemStack stack1;
        ItemStack stack2;

        public RecipeDuplicate(ItemStack stack1, ItemStack stack2) {
            this.stack1 = stack1;
            this.stack2 = stack2;
        }

        public void add() {
            RebornCraftingHelper.addShapelessRecipe((ItemStack)this.stack2, (Object[])new Object[]{this.stack1});
            RebornCraftingHelper.addShapelessRecipe((ItemStack)this.stack1, (Object[])new Object[]{this.stack2});
        }
    }
}

