/*
 * Decompiled with CFR 0.152.
 */
package me.modmuss50.structureutils;

import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.MethodNode;

public class ASMUtils {
    public static ClassNode readClassFromBytes(byte[] bytes) {
        ClassNode classNode = new ClassNode();
        ClassReader classReader = new ClassReader(bytes);
        classReader.accept((ClassVisitor)classNode, 0);
        return classNode;
    }

    public static MethodNode findMethodNodeOfClass(ClassNode classNode, String methodName, String methodDesc) {
        for (MethodNode method : classNode.methods) {
            if (!method.name.equals(methodName) || !method.desc.equals(methodDesc)) continue;
            return method;
        }
        return null;
    }

    public static AbstractInsnNode findFirstInstruction(MethodNode method) {
        return ASMUtils.getOrFindInstruction(method.instructions.getFirst());
    }

    public static AbstractInsnNode getOrFindInstruction(AbstractInsnNode firstInsnToCheck) {
        return ASMUtils.getOrFindInstruction(firstInsnToCheck, false);
    }

    public static AbstractInsnNode getOrFindInstruction(AbstractInsnNode firstInsnToCheck, boolean reverseDirection) {
        AbstractInsnNode instruction = firstInsnToCheck;
        while (instruction != null) {
            if (instruction.getType() != 8 && instruction.getType() != 15) {
                return instruction;
            }
            instruction = reverseDirection ? instruction.getPrevious() : instruction.getNext();
        }
        return null;
    }

    public static byte[] writeClassToBytes(ClassNode classNode) {
        ClassWriter writer = new ClassWriter(3);
        classNode.accept((ClassVisitor)writer);
        return writer.toByteArray();
    }
}

