/*
 * Decompiled with CFR 0.152.
 */
package ftblag.thaumicgrid.network;

import com.raoulvdberge.refinedstorage.api.autocrafting.preview.ICraftingPreviewElement;
import com.raoulvdberge.refinedstorage.apiimpl.API;
import ftblag.thaumicgrid.grid.gui.GuiThaumicCraftingPreview;
import ftblag.thaumicgrid.grid.gui.GuiThaumicGridCraftingSettings;
import io.netty.buffer.ByteBuf;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class MessageThaumicGridCraftingPreviewResponse
implements IMessage,
IMessageHandler<MessageThaumicGridCraftingPreviewResponse, IMessage> {
    private List<ICraftingPreviewElement> stacks;
    private int hash;
    private int quantity;
    private boolean fluids;

    public MessageThaumicGridCraftingPreviewResponse() {
    }

    public MessageThaumicGridCraftingPreviewResponse(List<ICraftingPreviewElement> stacks, int hash, int quantity, boolean fluids) {
        this.stacks = stacks;
        this.hash = hash;
        this.quantity = quantity;
        this.fluids = fluids;
    }

    public void fromBytes(ByteBuf buf) {
        this.hash = buf.readInt();
        this.quantity = buf.readInt();
        this.fluids = buf.readBoolean();
        this.stacks = new LinkedList<ICraftingPreviewElement>();
        int size = buf.readInt();
        for (int i = 0; i < size; ++i) {
            this.stacks.add((ICraftingPreviewElement)API.instance().getCraftingPreviewElementRegistry().get(ByteBufUtils.readUTF8String((ByteBuf)buf)).apply(buf));
        }
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.hash);
        buf.writeInt(this.quantity);
        buf.writeBoolean(this.fluids);
        buf.writeInt(this.stacks.size());
        for (ICraftingPreviewElement stack : this.stacks) {
            ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)stack.getId());
            stack.writeToByteBuf(buf);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public IMessage onMessage(MessageThaumicGridCraftingPreviewResponse message, MessageContext ctx) {
        Minecraft.func_71410_x().func_152344_a(() -> {
            GuiScreen screen = Minecraft.func_71410_x().field_71462_r;
            if (screen instanceof GuiThaumicGridCraftingSettings) {
                screen = ((GuiThaumicGridCraftingSettings)screen).getParent();
            }
            FMLCommonHandler.instance().showGuiScreen((Object)new GuiThaumicCraftingPreview(screen, message.stacks, message.hash, message.quantity, message.fluids));
        });
        return null;
    }
}

