/*
 * Decompiled with CFR 0.152.
 */
package ftblag.thaumicgrid.grid.handler;

import com.raoulvdberge.refinedstorage.api.autocrafting.ICraftingPattern;
import com.raoulvdberge.refinedstorage.api.autocrafting.task.ICraftingTask;
import com.raoulvdberge.refinedstorage.api.autocrafting.task.ICraftingTaskError;
import com.raoulvdberge.refinedstorage.api.network.INetwork;
import com.raoulvdberge.refinedstorage.api.network.security.Permission;
import com.raoulvdberge.refinedstorage.api.util.IStackList;
import com.raoulvdberge.refinedstorage.apiimpl.API;
import com.raoulvdberge.refinedstorage.apiimpl.autocrafting.preview.CraftingPreviewElementError;
import com.raoulvdberge.refinedstorage.apiimpl.network.grid.handler.ItemGridHandler;
import ftblag.thaumicgrid.network.MessageThaumicGridCraftingPreviewResponse;
import ftblag.thaumicgrid.network.MessageThaumicGridCraftingStartResponse;
import ftblag.thaumicgrid.network.NetworkHandler;
import java.util.Collections;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class ItemThaumicGridHandler
extends ItemGridHandler {
    private INetwork network;

    public ItemThaumicGridHandler(INetwork network) {
        super(network);
        this.network = network;
    }

    public void onCraftingPreviewRequested(EntityPlayerMP player, int hash, int quantity, boolean noPreview) {
        if (!this.network.getSecurityManager().hasPermission(Permission.AUTOCRAFTING, (EntityPlayer)player)) {
            return;
        }
        IStackList cache = API.instance().createItemStackList();
        for (ICraftingPattern pattern : this.network.getCraftingManager().getPatterns()) {
            for (ItemStack output : pattern.getOutputs()) {
                cache.add((Object)output);
            }
        }
        ItemStack stack = (ItemStack)cache.get(hash);
        if (stack != null) {
            Thread calculationThread = new Thread(() -> {
                ICraftingTask task = this.network.getCraftingManager().create(stack, quantity);
                if (task == null) {
                    return;
                }
                ICraftingTaskError error = task.calculate();
                if (error != null) {
                    NetworkHandler.network.sendTo((IMessage)new MessageThaumicGridCraftingPreviewResponse(Collections.singletonList(new CraftingPreviewElementError(error.getType(), error.getRecursedPattern() == null ? ItemStack.field_190927_a : error.getRecursedPattern().getStack())), hash, quantity, false), player);
                } else if (noPreview && task.getMissing().isEmpty()) {
                    this.network.getCraftingManager().add(task);
                    NetworkHandler.network.sendTo((IMessage)new MessageThaumicGridCraftingStartResponse(), player);
                } else {
                    NetworkHandler.network.sendTo((IMessage)new MessageThaumicGridCraftingPreviewResponse(task.getPreviewStacks(), hash, quantity, false), player);
                }
            }, "RS crafting preview calculation");
            calculationThread.start();
        }
    }
}

