/*
 * Decompiled with CFR 0.152.
 */
package ftblag.thaumicgrid.grid.gui;

import com.google.common.primitives.Ints;
import com.raoulvdberge.refinedstorage.container.ContainerCraftingSettings;
import com.raoulvdberge.refinedstorage.gui.GuiAmountSpecifying;
import com.raoulvdberge.refinedstorage.gui.GuiBase;
import com.raoulvdberge.refinedstorage.gui.grid.stack.GridStackFluid;
import com.raoulvdberge.refinedstorage.gui.grid.stack.IGridStack;
import ftblag.thaumicgrid.network.MessageThaumicGridCraftingPreview;
import ftblag.thaumicgrid.network.NetworkHandler;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class GuiThaumicGridCraftingSettings
extends GuiAmountSpecifying {
    private IGridStack stack;

    public GuiThaumicGridCraftingSettings(GuiBase parent, EntityPlayer player, IGridStack stack) {
        super(parent, (Container)new ContainerCraftingSettings(player, stack), 172, 99);
        this.stack = stack;
    }

    protected String getOkButtonText() {
        return GuiThaumicGridCraftingSettings.t((String)"misc.refinedstorage:start", (Object[])new Object[0]);
    }

    protected String getTitle() {
        return GuiThaumicGridCraftingSettings.t((String)"container.crafting", (Object[])new Object[0]);
    }

    protected String getTexture() {
        return "gui/crafting_settings.png";
    }

    protected int[] getIncrements() {
        if (this.stack instanceof GridStackFluid) {
            return new int[]{100, 500, 1000, -100, -500, -1000};
        }
        return new int[]{1, 10, 64, -1, -10, -64};
    }

    protected int getDefaultAmount() {
        return this.stack instanceof GridStackFluid ? 1000 : 1;
    }

    protected boolean canAmountGoNegative() {
        return false;
    }

    protected int getMaxAmount() {
        return Integer.MAX_VALUE;
    }

    protected void onOkButtonPressed(boolean shiftDown) {
        Integer quantity = Ints.tryParse((String)this.amountField.func_146179_b());
        if (quantity != null && quantity > 0) {
            NetworkHandler.network.sendToServer((IMessage)new MessageThaumicGridCraftingPreview(this.stack.getHash(), quantity, shiftDown, false));
            this.okButton.field_146124_l = false;
        }
    }
}

