/*
 * Decompiled with CFR 0.152.
 */
package com.phylogeny.extrabitmanipulation.shape;

import com.phylogeny.extrabitmanipulation.reference.Configs;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public abstract class Shape {
    public static final String[] SHAPE_NAMES = new String[]{"Sphere", "Cylinder", "Cone", "Cube", "Triangular Prism", "Triangular Pyramid", "Square Pyramid"};
    protected int direction;
    protected float centerX;
    protected float centerY;
    protected float centerZ;
    protected float wallThickness;
    protected boolean sculptHollowShape;
    protected boolean openEnds;
    protected boolean inverted;

    public void init(float centerX, float centerY, float centerZ, int direction, boolean sculptHollowShape, float wallThickness, boolean openEnds) {
        this.direction = direction;
        this.sculptHollowShape = sculptHollowShape;
        this.wallThickness = wallThickness;
        this.openEnds = openEnds;
        if (direction > 1) {
            if (direction > 3) {
                float v = centerX;
                centerX = centerY;
                centerY = v;
            } else {
                float v = centerZ;
                centerZ = centerY;
                centerY = v;
            }
        }
        this.centerX = centerX;
        this.centerY = centerY;
        this.centerZ = centerZ;
        this.inverted = direction % 2 == 0;
    }

    public boolean isBlockInsideShape(BlockPos pos) {
        if (this.sculptHollowShape) {
            return false;
        }
        for (int i = 0; i < 16; i += 15) {
            for (int j = 0; j < 16; j += 15) {
                for (int k = 0; k < 16; k += 15) {
                    if (this.isPointInsideShape(pos, i, j, k)) continue;
                    return false;
                }
            }
        }
        return true;
    }

    public abstract boolean isPointInsideShape(BlockPos var1, int var2, int var3, int var4);

    public Vec3d getRandomInternalPoint(World world, BlockPos pos) {
        AxisAlignedBB blockBounds;
        int x = pos.func_177958_n();
        int y = pos.func_177956_o();
        int z = pos.func_177952_p();
        AxisAlignedBB bb = world.func_180495_p(pos).func_185900_c((IBlockAccess)world, pos);
        AxisAlignedBB axisAlignedBB = blockBounds = bb == null ? new AxisAlignedBB(pos) : new AxisAlignedBB(bb.field_72340_a, bb.field_72338_b, bb.field_72339_c, bb.field_72336_d, bb.field_72337_e, bb.field_72334_f).func_186670_a(pos);
        if (blockBounds.func_72320_b() == 0.0) {
            blockBounds = new AxisAlignedBB((double)x, (double)y, (double)z, (double)(x + 1), (double)(y + 1), (double)(z + 1));
        }
        AxisAlignedBB box = this.getIntersectingBox(blockBounds, this.getBoundingBox());
        float s = Configs.bitSpawnBoxContraction;
        if (s > 0.0f) {
            box = box.func_72314_b(-(box.field_72336_d - box.field_72340_a) * (double)s, -(box.field_72337_e - box.field_72338_b) * (double)s, -(box.field_72334_f - box.field_72339_c) * (double)s);
        }
        double d0 = (double)world.field_73012_v.nextFloat() * (box.field_72336_d - box.field_72340_a) + box.field_72340_a;
        double d1 = (double)world.field_73012_v.nextFloat() * (box.field_72337_e - box.field_72338_b) + box.field_72338_b;
        double d2 = (double)world.field_73012_v.nextFloat() * (box.field_72334_f - box.field_72339_c) + box.field_72339_c;
        return new Vec3d(d0, d1, d2);
    }

    @Nonnull
    protected AxisAlignedBB getBoundingBox() {
        return Block.field_185505_j;
    }

    @Nonnull
    private AxisAlignedBB getIntersectingBox(AxisAlignedBB box1, AxisAlignedBB box2) {
        if (box1.field_72340_a > box2.field_72336_d || box2.field_72340_a > box1.field_72336_d || box1.field_72338_b > box2.field_72337_e || box2.field_72338_b > box1.field_72337_e || box1.field_72339_c > box2.field_72334_f || box2.field_72339_c > box1.field_72334_f) {
            return box1;
        }
        double minX = Math.max(box1.field_72340_a, box2.field_72340_a);
        double minY = Math.max(box1.field_72338_b, box2.field_72338_b);
        double minZ = Math.max(box1.field_72339_c, box2.field_72339_c);
        double maxX = Math.min(box1.field_72336_d, box2.field_72336_d);
        double maxY = Math.min(box1.field_72337_e, box2.field_72337_e);
        double maxZ = Math.min(box1.field_72334_f, box2.field_72334_f);
        return new AxisAlignedBB(minX, minY, minZ, maxX, maxY, maxZ);
    }

    protected float reduceLength(float value) {
        return 0.0625f < value ? value - this.wallThickness : 1.0E-10f;
    }

    protected float getBitPosDiffX(BlockPos pos, int x, int y, float center) {
        return this.getBitPosX(pos, x, y) - center;
    }

    protected float getBitPosDiffY(BlockPos pos, int x, int y, int z, float center) {
        return this.getBitPosY(pos, x, y, z) - center;
    }

    protected float getBitPosDiffZ(BlockPos pos, int y, int z, float center) {
        return this.getBitPosZ(pos, y, z) - center;
    }

    protected float getBitPosX(BlockPos pos, int x, int y) {
        return this.direction > 3 ? (float)pos.func_177956_o() + (float)y * 0.0625f : (float)pos.func_177958_n() + (float)x * 0.0625f;
    }

    protected float getBitPosY(BlockPos pos, int x, int y, int z) {
        return this.direction < 2 ? (float)pos.func_177956_o() + (float)y * 0.0625f : (this.direction > 3 ? (float)pos.func_177958_n() + (float)x * 0.0625f : (float)pos.func_177952_p() + (float)z * 0.0625f);
    }

    protected float getBitPosZ(BlockPos pos, int y, int z) {
        return this.direction == 2 || this.direction == 3 ? (float)pos.func_177956_o() + (float)y * 0.0625f : (float)pos.func_177952_p() + (float)z * 0.0625f;
    }

    protected boolean isPointOffLine(float val, float centerVal, float semiDiameter) {
        return val < centerVal - semiDiameter || val > centerVal + semiDiameter;
    }

    protected boolean isPointInRectangle(float dv1, float dv2, float s1, float s2) {
        return dv1 <= s1 && dv1 >= -s1 && dv2 <= s2 && dv2 >= -s2;
    }

    protected boolean isPointInTriangle(float v1, float v2, float center1, float center2, float s1, float s2) {
        float bcz;
        float bx;
        boolean dxz;
        float dx;
        float dz;
        float az = center2 + s2;
        float cx = center1 - s1;
        if ((cx - center1) * dz - az * dx > 0.0f == (dxz = ((bx = center1 + s1) - center1) * (dz = v2 - az) - (az = (bcz = center2 - s2) - az) * (dx = v1 - center1) > 0.0f)) {
            return false;
        }
        return (cx - bx) * (v2 - bcz) > 0.0f == dxz;
    }
}

