/*
 * Decompiled with CFR 0.152.
 */
package com.phylogeny.extrabitmanipulation.packet;

import com.phylogeny.extrabitmanipulation.ExtraBitManipulation;
import com.phylogeny.extrabitmanipulation.armor.ArmorItem;
import com.phylogeny.extrabitmanipulation.armor.DataChiseledArmorPiece;
import com.phylogeny.extrabitmanipulation.client.ClientHelper;
import com.phylogeny.extrabitmanipulation.container.ContainerPlayerInventory;
import com.phylogeny.extrabitmanipulation.helper.ItemStackHelper;
import com.phylogeny.extrabitmanipulation.item.ItemChiseledArmor;
import com.phylogeny.extrabitmanipulation.packet.PacketChangeChiseledArmorList;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.IThreadListener;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;

public class PacketChangeArmorItemList
extends PacketChangeChiseledArmorList {
    private ItemStack stack;
    private ListOperation listOperation;

    public PacketChangeArmorItemList() {
    }

    public PacketChangeArmorItemList(ItemChiseledArmor.ArmorType armorType, int indexArmorSet, int partIndex, int armorItemIndex, int selectedEntry, ListOperation listOperation, ItemStack stack, NBTTagCompound glOperationsNbt, boolean refreshLists, EntityPlayer player) {
        super(glOperationsNbt, armorType, indexArmorSet, partIndex, armorItemIndex, selectedEntry, refreshLists, player);
        this.listOperation = listOperation;
        this.stack = stack;
    }

    @Override
    public void toBytes(ByteBuf buffer) {
        super.toBytes(buffer);
        buffer.writeInt(this.listOperation.ordinal());
        ByteBufUtils.writeItemStack((ByteBuf)buffer, (ItemStack)this.stack);
    }

    @Override
    public void fromBytes(ByteBuf buffer) {
        super.fromBytes(buffer);
        this.listOperation = ListOperation.values()[buffer.readInt()];
        this.stack = ByteBufUtils.readItemStack((ByteBuf)buffer);
    }

    public static enum ListOperation {
        ADD,
        REMOVE,
        MODIFY;

    }

    public static class Handler
    implements IMessageHandler<PacketChangeArmorItemList, IMessage> {
        public IMessage onMessage(final PacketChangeArmorItemList message, final MessageContext ctx) {
            final boolean serverSide = ctx.side == Side.SERVER;
            IThreadListener mainThread = serverSide ? (WorldServer)ctx.getServerHandler().field_147369_b.field_70170_p : ClientHelper.getThreadListener();
            mainThread.func_152344_a(new Runnable(){

                @Override
                public void run() {
                    boolean add;
                    Object player = serverSide ? ctx.getServerHandler().field_147369_b : ClientHelper.getPlayer();
                    ItemStack stack = ItemStackHelper.getChiseledArmorStack(player, message.armorType, message.indexArmorSet);
                    if (!ItemStackHelper.isChiseledArmorStack(stack)) {
                        return;
                    }
                    message.initData(message, stack);
                    NBTTagCompound nbt = ItemStackHelper.getNBT(stack);
                    NBTTagCompound data = message.getData(nbt, serverSide);
                    NBTTagList movingParts = data.func_150295_c("partData", 9);
                    NBTBase nbtBase = movingParts.func_179238_g(message.value);
                    if (nbtBase.func_74732_a() != 9) {
                        return;
                    }
                    Container container = player.field_71070_bA;
                    if (container == null || !(container instanceof ContainerPlayerInventory)) {
                        return;
                    }
                    NBTTagList itemList = (NBTTagList)nbtBase;
                    int glListRemovalIndex = -1;
                    boolean bl = add = message.listOperation == ListOperation.ADD;
                    if (message.listOperation == ListOperation.MODIFY) {
                        NBTTagCompound armorItemNbt = itemList.func_150305_b(message.armorItemIndex);
                        ItemStackHelper.saveStackToNBT(armorItemNbt, message.stack, "armorItem");
                        itemList.func_150304_a(message.armorItemIndex, (NBTBase)armorItemNbt);
                    } else if (add) {
                        NBTTagCompound armorItemNbt = new NBTTagCompound();
                        ArmorItem armorItem = new ArmorItem(message.stack);
                        armorItem.saveToNBT(armorItemNbt);
                        if (message.nbt.func_74764_b("glOperations")) {
                            armorItemNbt.func_74782_a("glOperations", (NBTBase)message.nbt.func_150295_c("glOperations", 10));
                        }
                        itemList.func_74742_a((NBTBase)armorItemNbt);
                    } else {
                        itemList.func_74744_a(message.armorItemIndex);
                        glListRemovalIndex = message.armorItemIndex;
                    }
                    movingParts.func_150304_a(message.value, (NBTBase)itemList);
                    DataChiseledArmorPiece.setPartData(data, movingParts);
                    message.finalizeDataChange(message, stack, nbt, data, serverSide, true, add, glListRemovalIndex);
                    if (serverSide) {
                        ExtraBitManipulation.packetNetwork.sendTo((IMessage)new PacketChangeArmorItemList(message.armorType, message.indexArmorSet, message.value, message.armorItemIndex, message.selectedEntry, message.listOperation, message.stack, message.nbt, message.refreshLists, (EntityPlayer)player), (EntityPlayerMP)player);
                    }
                }
            });
            return null;
        }
    }
}

