/*
 * Decompiled with CFR 0.152.
 */
package com.phylogeny.extrabitmanipulation.item;

import com.phylogeny.extrabitmanipulation.ExtraBitManipulation;
import com.phylogeny.extrabitmanipulation.api.ChiselsAndBitsAPIAccess;
import com.phylogeny.extrabitmanipulation.config.ConfigReplacementBits;
import com.phylogeny.extrabitmanipulation.helper.BitIOHelper;
import com.phylogeny.extrabitmanipulation.helper.BitInventoryHelper;
import com.phylogeny.extrabitmanipulation.helper.BitToolSettingsHelper;
import com.phylogeny.extrabitmanipulation.helper.ItemStackHelper;
import com.phylogeny.extrabitmanipulation.init.KeyBindingsExtraBitManipulation;
import com.phylogeny.extrabitmanipulation.item.ItemBitToolBase;
import com.phylogeny.extrabitmanipulation.packet.PacketCreateModel;
import com.phylogeny.extrabitmanipulation.reference.Configs;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import mod.chiselsandbits.api.APIExceptions;
import mod.chiselsandbits.api.IBitAccess;
import mod.chiselsandbits.api.IBitBrush;
import mod.chiselsandbits.api.IChiselAndBitsAPI;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.apache.commons.lang3.StringUtils;

public class ItemModelingTool
extends ItemBitToolBase {
    public static final String[] AREA_MODE_TITLES = new String[]{"Centered", "Corner", "Drawn"};
    public static final String[] SNAP_MODE_TITLES = new String[]{"Off", "Snap-to-Chunk XZ", "Snap-to-Chunk XYZ"};

    public ItemModelingTool(String name) {
        super(name);
    }

    public NBTTagCompound initialize(ItemStack stack, BitToolSettingsHelper.ModelReadData modelingData) {
        NBTTagCompound nbt = ItemStackHelper.initNBT(stack);
        this.initInt(nbt, "modelAreaMode", modelingData.getAreaMode());
        this.initInt(nbt, "modelSnapMode", modelingData.getSnapMode());
        this.initBoolean(nbt, "modelGuiOpen", modelingData.getGuiOpen());
        return nbt;
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        BitToolSettingsHelper.ModelWriteData modelingData;
        ItemStack stack = player.func_184586_b(hand);
        if (world.field_72995_K && stack.func_77942_o() && this.createModel(stack, player, world, pos, facing, modelingData = new BitToolSettingsHelper.ModelWriteData(stack.func_77978_p().func_74767_n("bitMapsPerTool"))) == EnumActionResult.SUCCESS) {
            ExtraBitManipulation.packetNetwork.sendToServer((IMessage)new PacketCreateModel(pos, facing, modelingData));
        }
        return EnumActionResult.SUCCESS;
    }

    public EnumActionResult createModel(ItemStack stack, EntityPlayer player, World world, BlockPos pos, EnumFacing facing, BitToolSettingsHelper.ModelWriteData modelingData) {
        if (!stack.func_77942_o()) {
            return EnumActionResult.FAIL;
        }
        if (!world.func_180495_p(pos).func_177230_c().func_176200_f((IBlockAccess)world, pos) && !world.func_175623_d(pos = pos.func_177972_a(facing))) {
            return EnumActionResult.FAIL;
        }
        world.func_175698_g(pos);
        IChiselAndBitsAPI api = ChiselsAndBitsAPIAccess.apiInstance;
        NBTTagCompound nbt = ItemStackHelper.getNBT(stack);
        if (!nbt.func_74764_b("savedStates")) {
            return EnumActionResult.FAIL;
        }
        HashMap<IBlockState, Integer> stateMap = new HashMap<IBlockState, Integer>();
        IBlockState[][][] stateArray = new IBlockState[16][16][16];
        BitIOHelper.readStatesFromNBT(nbt, stateMap, stateArray);
        HashMap<IBlockState, ArrayList<BitCount>> stateToBitCountArray = new HashMap<IBlockState, ArrayList<BitCount>>();
        HashMap<IBitBrush, Integer> bitMap = new HashMap<IBitBrush, Integer>();
        Map<IBlockState, Integer> missingBitMap = this.mapBitsToStates(api, modelingData.getReplacementBitsUnchiselable(), modelingData.getReplacementBitsInsufficient(), BitInventoryHelper.getInventoryBitCounts(api, player), stateMap, stateToBitCountArray, modelingData.getStateToBitMap(api, stack), modelingData.getBlockToBitMap(api, stack), bitMap, player.field_71075_bZ.field_75098_d);
        if (!missingBitMap.isEmpty()) {
            if (world.field_72995_K) {
                int missingBitCount = 0;
                for (IBlockState state : missingBitMap.keySet()) {
                    missingBitCount += missingBitMap.get(state).intValue();
                }
                this.sendMessage(player, "Missing " + missingBitCount + " bits to represent the following blocks:");
                for (IBlockState state : missingBitMap.keySet()) {
                    String name = this.getBlockName(state, new ItemStack(state.func_177230_c(), 1, state.func_177230_c().func_176201_c(state)));
                    this.sendMessage(player, "  " + missingBitMap.get(state) + " - " + name);
                }
            }
            return EnumActionResult.FAIL;
        }
        return this.createModel(player, world, pos, stack, api, stateArray, stateToBitCountArray, bitMap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private EnumActionResult createModel(EntityPlayer player, World world, BlockPos pos, ItemStack stack, IChiselAndBitsAPI api, IBlockState[][][] stateArray, Map<IBlockState, ArrayList<BitCount>> stateToBitCountArray, Map<IBitBrush, Integer> bitMap) {
        IBitAccess bitAccess;
        try {
            bitAccess = api.getBitAccess(world, pos);
        }
        catch (APIExceptions.CannotBeChiseled e) {
            e.printStackTrace();
            return EnumActionResult.FAIL;
        }
        try {
            api.beginUndoGroup(player);
            if (!this.createModel(player, world, stack, stateArray, stateToBitCountArray, bitAccess)) {
                EnumActionResult enumActionResult = EnumActionResult.FAIL;
                return enumActionResult;
            }
            bitAccess.commitChanges(true);
        }
        finally {
            api.endUndoGroup(player);
        }
        if (!world.field_72995_K && !player.field_71075_bZ.field_75098_d) {
            for (IBitBrush bit : bitMap.keySet()) {
                BitInventoryHelper.removeOrAddInventoryBits(api, player, bit.getItemStack(1), bitMap.get(bit), false);
                player.field_71069_bz.func_75142_b();
            }
        }
        this.damageTool(stack, player);
        return EnumActionResult.SUCCESS;
    }

    public boolean createModel(EntityPlayer player, World world, ItemStack stack, IBlockState[][][] stateArray, Map<IBlockState, ArrayList<BitCount>> stateToBitCountArray, IBitAccess bitAccess) {
        if (!ItemStackHelper.hasKey(stack, "savedStates")) {
            return false;
        }
        for (int i = 0; i < 16; ++i) {
            for (int j = 0; j < 16; ++j) {
                for (int k = 0; k < 16; ++k) {
                    try {
                        IBitBrush bit = null;
                        IBlockState state = stateArray[i][j][k];
                        if (!state.equals(Blocks.field_150350_a.func_176223_P())) {
                            for (BitCount bitCount : stateToBitCountArray.get(state)) {
                                if (bitCount.count <= 0) continue;
                                bitCount.count--;
                                bit = bitCount.bit;
                                break;
                            }
                        }
                        bitAccess.setBitAt(i, j, k, bit);
                        continue;
                    }
                    catch (APIExceptions.SpaceOccupied e) {
                        if (world != null && world.field_72995_K) {
                            this.sendMessage(player, "Multipart(s) are in the way.");
                        }
                        return false;
                    }
                }
            }
        }
        return true;
    }

    public Map<IBlockState, Integer> mapBitsToStates(IChiselAndBitsAPI api, ConfigReplacementBits replacementBitsUnchiselable, ConfigReplacementBits replacementBitsInsufficient, Map<Integer, Integer> inventoryBitCounts, Map<IBlockState, Integer> stateMap, Map<IBlockState, ArrayList<BitCount>> stateToBitCountArray, Map<IBlockState, IBitBrush> manualStateToBitMap, Map<IBlockState, IBitBrush> manualBlockToBitMap, Map<IBitBrush, Integer> bitMap, boolean isCreative) {
        HashMap<IBlockState, Integer> missingBitMap = new HashMap<IBlockState, Integer>();
        HashMap<IBlockState, Integer> skippedStatesMap = new HashMap<IBlockState, Integer>();
        HashMap<IBlockState, ArrayList> skippedBitCountArrayMap = new HashMap<IBlockState, ArrayList>();
        for (int pass = 0; pass < 2; ++pass) {
            for (IBlockState state : stateMap.keySet()) {
                int remainingBitCount;
                ArrayList bitCountArray;
                block6: {
                    if (pass == 1 && !skippedStatesMap.containsKey(state)) continue;
                    int bitCount = stateMap.get(state);
                    bitCountArray = pass == 1 ? (ArrayList)skippedBitCountArrayMap.get(state) : new ArrayList();
                    remainingBitCount = pass == 1 ? (Integer)skippedStatesMap.get(state) : 0;
                    try {
                        if (pass == 0) {
                            remainingBitCount = this.addBitCountObject(bitCountArray, bitMap, inventoryBitCounts, manualStateToBitMap.containsKey(state) ? manualStateToBitMap.get(state) : (manualBlockToBitMap.containsKey(state.func_177230_c().func_176223_P()) ? manualBlockToBitMap.get(state.func_177230_c().func_176223_P()) : api.createBrushFromState(state)), bitCount, isCreative);
                        }
                        if (remainingBitCount > 0 && (remainingBitCount = this.getReplacementBit(api, replacementBitsInsufficient, bitMap, inventoryBitCounts, bitCountArray, remainingBitCount, isCreative, pass)) < 0) {
                            skippedStatesMap.put(state, remainingBitCount * -1);
                            skippedBitCountArrayMap.put(state, bitCountArray);
                        }
                    }
                    catch (APIExceptions.InvalidBitItem e) {
                        remainingBitCount = this.getReplacementBit(api, replacementBitsUnchiselable, bitMap, inventoryBitCounts, bitCountArray, bitCount, isCreative, pass);
                        if (remainingBitCount >= 0) break block6;
                        skippedStatesMap.put(state, remainingBitCount * -1);
                        skippedBitCountArrayMap.put(state, bitCountArray);
                    }
                }
                stateToBitCountArray.put(state, bitCountArray);
                if (remainingBitCount <= 0 || pass != 1 && skippedStatesMap.containsKey(state)) continue;
                missingBitMap.put(state, remainingBitCount);
            }
            if (skippedStatesMap.isEmpty()) break;
        }
        return missingBitMap;
    }

    private int getReplacementBit(IChiselAndBitsAPI api, ConfigReplacementBits replacementBitsConfig, Map<IBitBrush, Integer> bitMap, Map<Integer, Integer> inventoryBitCounts, ArrayList<BitCount> bitCountArray, int remainingBitCount, boolean isCreative, int pass) {
        if (pass == 0 && replacementBitsConfig.useDefaultReplacementBit()) {
            try {
                remainingBitCount = this.addBitCountObject(bitCountArray, bitMap, inventoryBitCounts, api.createBrush((ItemStack)replacementBitsConfig.getDefaultReplacementBit().getDefaultValue()), remainingBitCount, isCreative);
            }
            catch (APIExceptions.InvalidBitItem invalidBitItem) {
                // empty catch block
            }
        }
        if (remainingBitCount > 0 && replacementBitsConfig.useAnyBitsAsReplacements()) {
            if (pass == 0) {
                return -remainingBitCount;
            }
            try {
                Integer stateID;
                Iterator<Integer> iterator = inventoryBitCounts.keySet().iterator();
                while (iterator.hasNext() && (remainingBitCount = this.addBitCountObject(bitCountArray, bitMap, inventoryBitCounts, api.createBrushFromState(Block.func_176220_d((int)(stateID = iterator.next()))), remainingBitCount, isCreative)) != 0) {
                }
            }
            catch (APIExceptions.InvalidBitItem invalidBitItem) {
                // empty catch block
            }
        }
        if (remainingBitCount > 0 && replacementBitsConfig.useAirAsReplacement()) {
            try {
                remainingBitCount = this.addBitCountObject(bitCountArray, bitMap, inventoryBitCounts, api.createBrush(null), remainingBitCount, isCreative);
            }
            catch (APIExceptions.InvalidBitItem invalidBitItem) {
                // empty catch block
            }
        }
        return remainingBitCount;
    }

    private int addBitCountObject(ArrayList<BitCount> bitCountArray, Map<IBitBrush, Integer> bitMap, Map<Integer, Integer> inventoryBitCounts, IBitBrush bit, int bitCount, boolean isCreative) {
        int inventoryBitCount;
        boolean hasBitSurvival;
        if (bit.isAir()) {
            bitCountArray.add(new BitCount(bit, bitCount));
            return 0;
        }
        boolean bl = hasBitSurvival = inventoryBitCounts.containsKey(bit.getStateID()) && !isCreative;
        int n = isCreative ? Integer.MAX_VALUE : (inventoryBitCount = hasBitSurvival ? inventoryBitCounts.get(bit.getStateID()) : 0);
        if (inventoryBitCount > 0) {
            int bitCount2 = Math.min(inventoryBitCount, bitCount);
            bitCountArray.add(new BitCount(bit, bitCount2));
            bitCount -= bitCount2;
            bitMap.put(bit, bitCount2 + (bitMap.containsKey(bit) ? bitMap.get(bit) : 0));
            if (hasBitSurvival) {
                inventoryBitCounts.put(bit.getStateID(), inventoryBitCount - bitCount2);
            }
        }
        return bitCount;
    }

    private void sendMessage(EntityPlayer player, String message) {
        player.func_145747_a((ITextComponent)new TextComponentString(message));
    }

    private String getBlockName(IBlockState state, ItemStack blockStack) {
        String name = state.func_177230_c().func_149739_a();
        if (blockStack.func_77973_b() != null) {
            name = blockStack.func_82833_r();
        } else if (state.func_185904_a().func_76224_d()) {
            Fluid fluid = FluidRegistry.lookupFluidForBlock((Block)state.func_177230_c());
            if (fluid != null) {
                name = StringUtils.capitalize((String)fluid.getName());
            }
        } else {
            Item item = Item.func_150898_a((Block)state.func_177230_c());
            if (item != Items.field_190931_a) {
                name = item.toString();
            }
        }
        return name;
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flag) {
        boolean shiftDown = GuiScreen.func_146272_n();
        boolean ctrlDown = GuiScreen.func_146271_m();
        ItemModelingTool.addColorInformation(tooltip, shiftDown);
        NBTTagCompound nbt = stack.func_77978_p();
        int areaMode = BitToolSettingsHelper.getModelAreaMode(nbt);
        int snapMode = BitToolSettingsHelper.getModelSnapMode(nbt);
        if (!ctrlDown || shiftDown) {
            tooltip.add(ItemModelingTool.colorSettingText(BitToolSettingsHelper.getModelAreaModeText(areaMode), Configs.modelAreaMode));
        }
        if (shiftDown) {
            tooltip.add(ItemModelingTool.colorSettingText(BitToolSettingsHelper.getModelSnapModeText(snapMode), Configs.modelSnapMode));
            tooltip.add(ItemModelingTool.colorSettingText(BitToolSettingsHelper.getModelGuiOpenText(nbt), Configs.modelGuiOpen));
        } else if (ctrlDown) {
            if (areaMode == 2) {
                tooltip.add("Left click a block, drag to");
                tooltip.add("    another block, then release");
                tooltip.add("    to read all intersecting");
                tooltip.add("    block states.");
            } else {
                tooltip.add("Left click a block to read all");
                String readText = "    block states in an area";
                if (areaMode == 0) {
                    tooltip.add(readText);
                    tooltip.add("    centered on the nearest");
                } else {
                    tooltip.add(readText + " that");
                    tooltip.add("    faces away from the player");
                    tooltip.add("    and has one of its corners");
                    tooltip.add("    positioned on the nearest");
                }
                tooltip.add("    block grid vertex.");
                if (snapMode > 0) {
                    tooltip.add("    (the area will snap in the");
                    if (snapMode == 1) {
                        tooltip.add("    XZ axes to the 2D chuck");
                    } else {
                        tooltip.add("    XYZ axes to the 3D chuck");
                    }
                    tooltip.add("    containing the block looked at)");
                }
            }
            tooltip.add("Right click to create model block.");
            tooltip.add("");
            String shiftText = ItemModelingTool.getColoredKeyBindText(KeyBindingsExtraBitManipulation.SHIFT);
            if (KeyBindingsExtraBitManipulation.OPEN_BIT_MAPPING_GUI.getKeyBinding().isSetToDefaultValue()) {
                tooltip.add(shiftText + " right click to open");
                tooltip.add("    mapping/preview GUI.");
            } else {
                tooltip.add(shiftText + " right click or press " + KeyBindingsExtraBitManipulation.OPEN_BIT_MAPPING_GUI.getText());
                tooltip.add("    to open mapping/preview GUI.");
            }
            tooltip.add(shiftText + " mouse wheel to cycle");
            tooltip.add("    area modes.");
            tooltip.add("");
            String controlText = ItemModelingTool.getColoredKeyBindText(KeyBindingsExtraBitManipulation.CONTROL);
            tooltip.add(controlText + " right click to toggle GUI");
            tooltip.add("    opening upon model read.");
            tooltip.add(controlText + " mouse wheel to");
            tooltip.add("    cycle chunk snap mode.");
            ItemModelingTool.addKeybindReminders(tooltip, KeyBindingsExtraBitManipulation.SHIFT, KeyBindingsExtraBitManipulation.CONTROL);
        } else {
            ItemModelingTool.addKeyInformation(tooltip, true);
        }
    }

    public static class BitCount {
        private IBitBrush bit;
        private int count;

        public BitCount(IBitBrush bit, int count) {
            this.bit = bit;
            this.count = count;
        }

        public IBitBrush getBit() {
            return this.bit;
        }

        public void setBit(IBitBrush bit) {
            this.bit = bit;
        }

        public int getCount() {
            return this.count;
        }
    }
}

