/*
 * Decompiled with CFR 0.152.
 */
package com.phylogeny.extrabitmanipulation.armor;

import com.phylogeny.extrabitmanipulation.armor.DataChiseledArmorPiece;
import com.phylogeny.extrabitmanipulation.armor.capability.ChiseledArmorSlotsHandler;
import com.phylogeny.extrabitmanipulation.armor.capability.IChiseledArmorSlotsHandler;
import com.phylogeny.extrabitmanipulation.client.ClientHelper;
import com.phylogeny.extrabitmanipulation.helper.ItemStackHelper;
import com.phylogeny.extrabitmanipulation.init.ReflectionExtraBitManipulation;
import com.phylogeny.extrabitmanipulation.item.ItemChiseledArmor;
import com.phylogeny.extrabitmanipulation.reference.Configs;
import com.phylogeny.extrabitmanipulation.reference.CustomNPCsReferences;
import com.phylogeny.extrabitmanipulation.reference.MorePlayerModelsReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.model.ModelIllager;
import net.minecraft.client.model.ModelPlayer;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.client.model.ModelVex;
import net.minecraft.client.model.ModelVillager;
import net.minecraft.client.renderer.GLAllocation;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.entity.RenderLivingBase;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.AbstractIllager;
import net.minecraft.entity.monster.EntityZombieVillager;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumHandSide;

public class LayerChiseledArmor
implements LayerRenderer<EntityLivingBase> {
    private final Map<NBTTagCompound, List<Integer>> movingPartsDisplayListsMap = new HashMap<NBTTagCompound, List<Integer>>();
    private ModelRenderer head;
    private ModelRenderer body;
    private ModelRenderer villagerArms;
    private ModelRenderer rightLeg;
    private ModelRenderer leftLeg;
    private ModelRenderer rightArm;
    private ModelRenderer leftArm;
    private ModelBase model;
    private boolean smallArms;
    private boolean isIllager;
    private boolean isVex;
    private RenderLivingBase<? extends EntityLivingBase> livingEntityRenderer;

    public LayerChiseledArmor(RenderLivingBase<? extends EntityLivingBase> livingEntityRenderer) {
        this.livingEntityRenderer = livingEntityRenderer;
        this.updateModelAndRenderers(false);
    }

    public void updateModelAndRenderers(boolean force) {
        ModelBase modelNew = this.livingEntityRenderer.func_177087_b();
        if (!force && modelNew == this.model) {
            return;
        }
        this.model = modelNew;
        if (this.model instanceof ModelVillager) {
            ModelVillager modelVillager = (ModelVillager)this.model;
            this.head = modelVillager.field_78191_a;
            this.body = modelVillager.field_78189_b;
            this.rightLeg = modelVillager.field_78187_d;
            this.leftLeg = modelVillager.field_78188_e;
            this.villagerArms = modelVillager.field_78190_c;
        } else if (this.model instanceof ModelIllager) {
            ModelIllager modelIllager = (ModelIllager)this.model;
            this.head = modelIllager.field_191217_a;
            this.body = modelIllager.field_191218_b;
            this.rightLeg = modelIllager.field_191220_d;
            this.leftLeg = modelIllager.field_191221_e;
            this.villagerArms = modelIllager.field_191219_c;
            this.rightArm = modelIllager.field_191223_g;
            this.leftArm = modelIllager.field_191224_h;
            this.isIllager = true;
        } else {
            ModelBiped modelBiped = (ModelBiped)this.model;
            this.head = modelBiped.field_78116_c;
            this.body = modelBiped.field_78115_e;
            this.rightLeg = modelBiped.field_178721_j;
            this.leftLeg = modelBiped.field_178722_k;
            this.rightArm = modelBiped.field_178723_h;
            this.leftArm = modelBiped.field_178724_i;
            this.villagerArms = null;
            if (this.model instanceof ModelPlayer) {
                this.smallArms = ReflectionExtraBitManipulation.areArmsSmall((ModelPlayer)this.model);
            }
            this.isVex = this.model instanceof ModelVex;
        }
    }

    public void clearDisplayListsMap() {
        for (List<Integer> displayLists : this.movingPartsDisplayListsMap.values()) {
            this.deleteDisplayLists(displayLists);
        }
        this.movingPartsDisplayListsMap.clear();
    }

    public void removeFromDisplayListsMap(NBTTagCompound nbt) {
        this.deleteDisplayLists(this.movingPartsDisplayListsMap.remove(nbt));
    }

    private void deleteDisplayLists(List<Integer> displayLists) {
        if (displayLists != null) {
            for (Integer displayList : displayLists) {
                GLAllocation.func_74523_b((int)displayList);
            }
        }
    }

    public static boolean isPlayerModelAlt(EntityLivingBase entity, float partialTicks) {
        if (entity instanceof EntityPlayer || !MorePlayerModelsReference.isLoaded && !CustomNPCsReferences.isLoaded) {
            return false;
        }
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        return entity.field_70169_q + (entity.field_70165_t - entity.field_70169_q) * (double)partialTicks == player.field_70169_q + (player.field_70165_t - player.field_70169_q) * (double)partialTicks && entity.field_70167_r + (entity.field_70163_u - entity.field_70167_r) * (double)partialTicks == player.field_70167_r + (player.field_70163_u - player.field_70167_r) * (double)partialTicks && entity.field_70166_s + (entity.field_70161_v - entity.field_70166_s) * (double)partialTicks == player.field_70166_s + (player.field_70161_v - player.field_70166_s) * (double)partialTicks;
    }

    public void func_177141_a(EntityLivingBase entity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch, float scale) {
        this.updateModelAndRenderers(false);
        GlStateManager.func_179147_l();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        ClientHelper.bindTexture(TextureMap.field_110575_b);
        EntityLivingBase entityCap = LayerChiseledArmor.isPlayerModelAlt(entity, partialTicks) ? Minecraft.func_71410_x().field_71439_g : entity;
        IChiseledArmorSlotsHandler cap = entityCap instanceof EntityPlayer ? ChiseledArmorSlotsHandler.getCapability((EntityPlayer)entityCap) : null;
        List<Integer> displayListsHelmet = this.getStackDisplayLists(entity, scale, ItemChiseledArmor.ArmorType.HELMET);
        List<Integer> displayListsSlotHelmet = this.getSlotStackDisplayLists(entity, scale, cap, ItemChiseledArmor.ArmorType.HELMET);
        if (displayListsHelmet != null || displayListsSlotHelmet != null) {
            GlStateManager.func_179094_E();
            this.adjustForSneaking(entity);
            if (entity.func_70631_g_() && !(entity instanceof EntityVillager)) {
                GlStateManager.func_179152_a((float)0.75f, (float)0.75f, (float)0.75f);
                GlStateManager.func_179109_b((float)0.0f, (float)1.0f, (float)0.0f);
            }
            this.head.func_78794_c(scale);
            GlStateManager.func_179109_b((float)0.0f, (float)(-scale * (8.0f + Configs.armorZFightingBufferScale)), (float)0.0f);
            GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.func_179114_b((float)180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            if (entity instanceof EntityVillager || entity instanceof EntityZombieVillager || entity instanceof AbstractIllager) {
                GlStateManager.func_179109_b((float)0.0f, (float)(scale * 2.0f), (float)0.0f);
            }
            GlStateManager.func_179094_E();
            if (!(displayListsHelmet == null || cap != null && cap.hasArmorType(0))) {
                GlStateManager.func_179148_o((int)displayListsHelmet.get(0));
            }
            GlStateManager.func_179121_F();
            if (displayListsSlotHelmet != null) {
                for (Integer i : displayListsSlotHelmet) {
                    GlStateManager.func_179148_o((int)i);
                }
            }
            GlStateManager.func_179121_F();
        }
        List<Integer> displayListsChestplate = this.getStackDisplayLists(entity, scale, ItemChiseledArmor.ArmorType.CHESTPLATE);
        List<Integer> displayListsSlotChestplate = this.getSlotStackDisplayLists(entity, scale, cap, ItemChiseledArmor.ArmorType.CHESTPLATE);
        if (displayListsChestplate != null || displayListsSlotChestplate != null) {
            GlStateManager.func_179094_E();
            this.adjustForSneaking(entity);
            this.adjustForChildModel();
            boolean isPassive = !this.isIllager || ((AbstractIllager)entity).func_193077_p() == AbstractIllager.IllagerArmPose.CROSSED;
            GlStateManager.func_179094_E();
            if (!(displayListsChestplate == null || cap != null && cap.hasArmorType(1))) {
                this.renderArmorPiece(this.body, displayListsChestplate.get(0), scale, 8.0f);
                this.renderSleeve(displayListsChestplate.get(1), EnumHandSide.RIGHT, scale, isPassive);
                this.renderSleeve(displayListsChestplate.get(2), EnumHandSide.LEFT, scale, isPassive);
            }
            GlStateManager.func_179121_F();
            if (displayListsSlotChestplate != null) {
                for (int i = 0; i < displayListsSlotChestplate.size(); i += 3) {
                    this.renderArmorPiece(this.body, displayListsSlotChestplate.get(i), scale, 8.0f);
                    this.renderSleeve(displayListsSlotChestplate.get(i + 1), EnumHandSide.RIGHT, scale, isPassive);
                    this.renderSleeve(displayListsSlotChestplate.get(i + 2), EnumHandSide.LEFT, scale, isPassive);
                }
            }
            GlStateManager.func_179121_F();
        }
        List<Integer> displayListsLeggings = this.getStackDisplayLists(entity, scale, ItemChiseledArmor.ArmorType.LEGGINGS);
        List<Integer> displayListsSlotLeggings = this.getSlotStackDisplayLists(entity, scale, cap, ItemChiseledArmor.ArmorType.LEGGINGS);
        if (displayListsLeggings != null || displayListsSlotLeggings != null) {
            GlStateManager.func_179094_E();
            this.adjustForSneaking(entity);
            this.adjustForChildModel();
            GlStateManager.func_179094_E();
            if (!(displayListsLeggings == null || cap != null && cap.hasArmorType(2))) {
                this.renderArmorPiece(this.body, displayListsLeggings.get(0), scale, 4.0f);
                this.renderLegPieces(displayListsLeggings.get(1), displayListsLeggings.get(2), scale, 8.0f);
            }
            GlStateManager.func_179121_F();
            if (displayListsSlotLeggings != null) {
                for (int i = 0; i < displayListsSlotLeggings.size(); i += 3) {
                    this.renderArmorPiece(this.body, displayListsSlotLeggings.get(i), scale, 4.0f);
                    this.renderLegPieces(displayListsSlotLeggings.get(i + 1), displayListsSlotLeggings.get(i + 2), scale, 8.0f);
                }
            }
            GlStateManager.func_179121_F();
        }
        List<Integer> displayListsBoots = this.getStackDisplayLists(entity, scale, ItemChiseledArmor.ArmorType.BOOTS);
        List<Integer> displayListsSlotBoots = this.getSlotStackDisplayLists(entity, scale, cap, ItemChiseledArmor.ArmorType.BOOTS);
        if (displayListsBoots != null || displayListsSlotBoots != null) {
            GlStateManager.func_179094_E();
            this.adjustForSneaking(entity);
            this.adjustForChildModel();
            GlStateManager.func_179109_b((float)0.0f, (float)(scale * Configs.armorZFightingBufferTranslationFeet), (float)0.0f);
            GlStateManager.func_179094_E();
            if (!(displayListsBoots == null || cap != null && cap.hasArmorType(3))) {
                this.renderLegPieces(displayListsBoots.get(0), displayListsBoots.get(1), scale, 4.0f);
            }
            GlStateManager.func_179121_F();
            if (displayListsSlotBoots != null) {
                for (int i = 0; i < displayListsSlotBoots.size(); i += 2) {
                    this.renderLegPieces(displayListsSlotBoots.get(i), displayListsSlotBoots.get(i + 1), scale, 4.0f);
                }
            }
            GlStateManager.func_179121_F();
        }
        GlStateManager.func_179084_k();
    }

    private List<Integer> getStackDisplayLists(EntityLivingBase entity, float scale, ItemChiseledArmor.ArmorType armorType) {
        return this.getDisplayLists(entity, scale, armorType, entity.func_184582_a(armorType.getEquipmentSlot()), null);
    }

    private List<Integer> getSlotStackDisplayLists(EntityLivingBase entity, float scale, IChiseledArmorSlotsHandler cap, ItemChiseledArmor.ArmorType armorType) {
        if (cap == null || !cap.hasArmor()) {
            return null;
        }
        return this.getDisplayLists(entity, scale, armorType, ItemStack.field_190927_a, cap);
    }

    private List<Integer> getDisplayLists(EntityLivingBase entity, float scale, ItemChiseledArmor.ArmorType armorType, ItemStack stack, @Nullable IChiseledArmorSlotsHandler cap) {
        ArrayList<Integer> displayLists = null;
        int countSet = cap == null ? 1 : 4;
        for (int i = 0; i < countSet; ++i) {
            NBTTagCompound nbt;
            NBTTagCompound armoreData;
            if (cap != null) {
                if (!cap.hasArmorSet(i)) continue;
                stack = cap.getStackInSlot(i * 4 + armorType.ordinal());
            }
            if (!stack.func_77942_o() || !(stack.func_77973_b() instanceof ItemChiseledArmor) || !(armoreData = ItemStackHelper.getArmorData(nbt = stack.func_77978_p())).func_74767_n("notEmpty")) continue;
            List<Integer> displayListsItem = this.movingPartsDisplayListsMap.get(armoreData);
            if (displayListsItem == null) {
                displayListsItem = this.addMovingPartsDisplayListsToMap(entity, scale, nbt, armorType);
            }
            if (displayLists == null) {
                displayLists = new ArrayList<Integer>();
            }
            displayLists.addAll(displayListsItem);
        }
        return displayLists;
    }

    private void adjustForSneaking(EntityLivingBase entity) {
        if (entity.func_70093_af()) {
            GlStateManager.func_179109_b((float)0.0f, (float)0.2f, (float)0.0f);
        }
    }

    private void adjustForChildModel() {
        if (this.model.field_78091_s) {
            GlStateManager.func_179109_b((float)0.0f, (float)0.75f, (float)0.0f);
            GlStateManager.func_179152_a((float)0.5f, (float)0.5f, (float)0.5f);
        }
    }

    private List<Integer> addMovingPartsDisplayListsToMap(EntityLivingBase entity, float scale, NBTTagCompound armorNbt, ItemChiseledArmor.ArmorType armorType) {
        ArrayList<Integer> movingPartsDisplayLists = new ArrayList<Integer>();
        for (int i = 0; i < armorType.getMovingpartCount(); ++i) {
            movingPartsDisplayLists.add(new DataChiseledArmorPiece(armorNbt, armorType).generateDisplayList(i, entity, scale));
        }
        this.movingPartsDisplayListsMap.put(ItemStackHelper.getArmorData(armorNbt), movingPartsDisplayLists);
        return movingPartsDisplayLists;
    }

    private void renderLegPieces(int displayListRight, int displayListLeft, float scale, float offsetY) {
        this.renderArmorPiece(this.rightLeg, displayListRight, scale, this.isVex ? -scale * 2.0f : 0.0f, offsetY);
        if (!this.isVex) {
            this.renderArmorPiece(this.leftLeg, displayListLeft, scale, offsetY);
        }
    }

    private void renderArmorPiece(ModelRenderer modelArmorPiece, int displayList, float scale, float offsetX, float offsetY) {
        GlStateManager.func_179094_E();
        modelArmorPiece.func_78794_c(scale);
        this.renderArmorPiece(displayList, scale, offsetX, offsetY);
    }

    private void renderArmorPiece(ModelRenderer modelArmorPiece, int displayList, float scale, float offsetY) {
        this.renderArmorPiece(modelArmorPiece, displayList, scale, 0.0f, offsetY);
    }

    private void renderArmorPiece(int displayList, float scale, float offsetX, float offsetY) {
        GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        GlStateManager.func_179109_b((float)offsetX, (float)(-scale * offsetY), (float)0.0f);
        GlStateManager.func_179148_o((int)displayList);
        GlStateManager.func_179121_F();
    }

    private void renderSleeve(int displayList, EnumHandSide handSide, float scale, boolean isPassive) {
        int armOffset;
        GlStateManager.func_179094_E();
        if (this.villagerArms != null && isPassive) {
            this.villagerArms.func_78794_c(scale);
            armOffset = 6;
        } else {
            ModelRenderer modelArm;
            ModelRenderer modelRenderer = modelArm = handSide == EnumHandSide.RIGHT ? this.rightArm : this.leftArm;
            if (this.smallArms) {
                float f = handSide == EnumHandSide.RIGHT ? -0.5f : 0.5f;
                modelArm.field_78800_c += f;
                ((ModelBiped)this.model).func_187073_a(scale, handSide);
                modelArm.field_78800_c -= f;
            } else {
                modelArm.func_78794_c(scale);
            }
            armOffset = 1;
        }
        this.renderArmorPiece(displayList, scale, (float)(handSide == EnumHandSide.LEFT ? -armOffset : armOffset) * scale, 6.0f);
    }

    public boolean func_177142_b() {
        return false;
    }
}

