/*
 * Decompiled with CFR 0.152.
 */
package techreborn.compatmod.ic2;

import ic2.api.item.ElectricItem;
import ic2.api.item.IElectricItem;
import ic2.api.item.ISpecialElectricItem;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import reborncore.api.power.IEnergyItemInfo;
import reborncore.common.RebornCoreConfig;
import reborncore.common.powerSystem.TilePowerAcceptor;
import reborncore.common.powerSystem.forge.ForgePowerItemManager;

public class IC2ItemCharger {
    protected static void chargeIc2Item(TilePowerAcceptor tilePowerAcceptor, ItemStack stack) {
        if (!IC2ItemCharger.isIC2PoweredItem(stack)) {
            return;
        }
        tilePowerAcceptor.useEnergy(ElectricItem.manager.charge(stack, tilePowerAcceptor.getEnergy(), 4, false, false));
    }

    protected static void chargeIc2Item(ForgePowerItemManager powerAcceptor, ItemStack stack) {
        if (!IC2ItemCharger.isIC2PoweredItem(stack)) {
            return;
        }
        double energyPassed = ElectricItem.manager.charge(stack, (double)(powerAcceptor.extractEnergy(powerAcceptor.getEnergyStored(), true) / RebornCoreConfig.euPerFU), 4, false, true);
        int passedFE = (int)(energyPassed * (double)RebornCoreConfig.euPerFU);
        if (energyPassed > 0.0) {
            ElectricItem.manager.charge(stack, (double)(powerAcceptor.extractEnergy(passedFE, false) / RebornCoreConfig.euPerFU), 4, false, false);
        }
    }

    protected static void dischargeIc2Item(TilePowerAcceptor tilePowerAcceptor, ItemStack stack) {
        if (!IC2ItemCharger.isIC2PoweredItem(stack)) {
            return;
        }
        tilePowerAcceptor.addEnergy(ElectricItem.manager.discharge(stack, tilePowerAcceptor.getFreeSpace(), 4, false, true, false));
    }

    protected static boolean isIC2PoweredItem(ItemStack stack) {
        if (stack.func_190926_b()) {
            return false;
        }
        Item item = stack.func_77973_b();
        return item instanceof IElectricItem || item instanceof ISpecialElectricItem || ElectricItem.getBackupManager((ItemStack)stack) != null;
    }

    public static void requestEnergyFromIc2Armor(ForgePowerItemManager powerAcceptor, EntityLivingBase entity) {
        for (EntityEquipmentSlot slot : EntityEquipmentSlot.values()) {
            ItemStack stack;
            if (slot.func_188453_a() == EntityEquipmentSlot.Type.HAND || !IC2ItemCharger.isIC2PoweredItem(stack = entity.func_184582_a(slot)) || stack.func_77973_b() instanceof IEnergyItemInfo) continue;
            double maxExtractedEnergy = ElectricItem.manager.discharge(stack, ElectricItem.manager.getCharge(stack), 4, true, true, true);
            int passedFE = Math.min(powerAcceptor.getMaxEnergyStored() - powerAcceptor.getEnergyStored(), (int)(maxExtractedEnergy * (double)RebornCoreConfig.euPerFU));
            if (passedFE <= 0) continue;
            double extracted = ElectricItem.manager.discharge(stack, (double)(passedFE / RebornCoreConfig.euPerFU), 4, true, true, false);
            int extractedFE = (int)(extracted * (double)RebornCoreConfig.euPerFU);
            powerAcceptor.setEnergyStored(Math.min(powerAcceptor.getEnergyStored() + extractedFE, powerAcceptor.getMaxEnergyStored()));
        }
    }
}

