/*
 * Decompiled with CFR 0.152.
 */
package xt9.deepmoblearning.common.tiles;

import java.util.HashMap;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.wrapper.CombinedInvWrapper;
import xt9.deepmoblearning.common.Registry;
import xt9.deepmoblearning.common.energy.DeepEnergyStorage;
import xt9.deepmoblearning.common.handlers.BaseItemHandler;
import xt9.deepmoblearning.common.handlers.DataModelHandler;
import xt9.deepmoblearning.common.handlers.OutputHandler;
import xt9.deepmoblearning.common.handlers.PolymerHandler;
import xt9.deepmoblearning.common.items.ItemDataModel;
import xt9.deepmoblearning.common.items.ItemLivingMatter;
import xt9.deepmoblearning.common.items.ItemPolymerClay;
import xt9.deepmoblearning.common.items.ItemPristineMatter;
import xt9.deepmoblearning.common.mobmetas.MobMetaData;
import xt9.deepmoblearning.common.mobmetas.MobMetaFactory;
import xt9.deepmoblearning.common.tiles.IGuiTile;
import xt9.deepmoblearning.common.util.Animation;
import xt9.deepmoblearning.common.util.DataModel;
import xt9.deepmoblearning.common.util.MathHelper;

public class TileEntitySimulationChamber
extends TileEntity
implements ITickable,
IGuiTile {
    private BaseItemHandler dataModel = new DataModelHandler();
    private BaseItemHandler polymer = new PolymerHandler();
    private BaseItemHandler lOutput = new OutputHandler();
    private BaseItemHandler pOutput = new OutputHandler();
    private DeepEnergyStorage energyStorage = new DeepEnergyStorage(2000000, 25600, 0, 0);
    private HashMap<String, Animation> simulationAnimations = new HashMap();
    private HashMap<String, String> simulationText = new HashMap();
    private boolean isCrafting = false;
    private boolean byproductSuccess = false;
    public int energy = 0;
    public int ticks = 0;
    public int percentDone = 0;
    private String currentDataModelType = "";
    private MobMetaData mobMetaData;

    public void func_73660_a() {
        ++this.ticks;
        if (!this.field_145850_b.field_72995_K) {
            if (!this.isCrafting()) {
                if (this.canStartSimulation()) {
                    this.startSimulation();
                }
            } else {
                if (!this.canContinueSimulation() || this.dataModelTypeChanged()) {
                    this.finishSimulation(true);
                    return;
                }
                this.updateSimulationText(this.getDataModel());
                if (this.percentDone == 0) {
                    int chance;
                    Random rand = new Random();
                    int num = rand.nextInt(100);
                    this.byproductSuccess = num <= MathHelper.ensureRange(chance = DataModel.getPristineChance(this.getDataModel()), 1, 100);
                }
                int rfTickCost = this.mobMetaData.getSimulationTickCost();
                this.energyStorage.voidEnergy(rfTickCost);
                if (this.ticks % 3 == 0) {
                    ++this.percentDone;
                }
                if (this.ticks % 40 == 0) {
                    this.updateState();
                }
            }
            if (this.percentDone == 100) {
                this.finishSimulation(false);
                return;
            }
            this.doStaggeredDiskSave(100);
        }
    }

    private void startSimulation() {
        this.isCrafting = true;
        this.currentDataModelType = DataModel.getMobMetaData(this.getDataModel()).getKey();
        this.mobMetaData = MobMetaFactory.createMobMetaData(this.currentDataModelType);
        ItemStack oldInput = this.getPolymerClay();
        ItemStack newInput = new ItemStack((Item)Registry.polymerClay, oldInput.func_190916_E() - 1);
        this.polymer.setStackInSlot(0, newInput);
        this.resetAnimations();
    }

    private void finishSimulation(boolean abort) {
        this.resetAnimations();
        this.percentDone = 0;
        this.isCrafting = false;
        if (!abort && !this.field_145850_b.field_72995_K) {
            DataModel.increaseSimulationCount(this.getDataModel());
            ItemStack oldOutput = this.getLiving();
            ItemStack newOutput = this.mobMetaData.getLivingMatterStack(oldOutput.func_190916_E() + 1);
            this.lOutput.setStackInSlot(0, newOutput);
            if (this.byproductSuccess) {
                this.byproductSuccess = false;
                ItemStack oldPristine = this.getPristine();
                ItemStack newPristine = this.mobMetaData.getPristineMatterStack(oldPristine.func_190916_E() + 1);
                this.pOutput.setStackInSlot(0, newPristine);
            }
            this.updateState();
        }
    }

    public void updateState() {
        IBlockState state = this.field_145850_b.func_180495_p(this.func_174877_v());
        this.field_145850_b.func_184138_a(this.func_174877_v(), state, state, 3);
    }

    private boolean canStartSimulation() {
        return this.hasEnergyForSimulation() && this.canContinueSimulation() && !this.outputIsFull() && !this.pristineIsFull() && this.hasPolymerClay();
    }

    private boolean canContinueSimulation() {
        return this.hasDataModel() && DataModel.getTier(this.getDataModel()) != 0;
    }

    private boolean dataModelTypeChanged() {
        return !this.currentDataModelType.equals(DataModel.getMobMetaData(this.getDataModel()).getKey());
    }

    public boolean hasEnergyForSimulation() {
        if (this.hasDataModel()) {
            int ticksPerSimulation = 300;
            return this.energyStorage.getEnergyStored() > ticksPerSimulation * DataModel.getSimulationTickCost(this.getDataModel());
        }
        return false;
    }

    public ItemStack getDataModel() {
        return this.dataModel.getStackInSlot(0);
    }

    private ItemStack getPolymerClay() {
        return this.polymer.getStackInSlot(0);
    }

    private ItemStack getLiving() {
        return this.lOutput.getStackInSlot(0);
    }

    private ItemStack getPristine() {
        return this.pOutput.getStackInSlot(0);
    }

    public boolean hasPolymerClay() {
        ItemStack stack = this.getPolymerClay();
        return stack.func_77973_b() instanceof ItemPolymerClay && stack.func_190916_E() > 0;
    }

    public boolean hasDataModel() {
        return this.getDataModel().func_77973_b() instanceof ItemDataModel;
    }

    public boolean outputIsFull() {
        ItemStack stack = this.getLiving();
        if (stack.func_190926_b()) {
            return false;
        }
        boolean stackLimitReached = stack.func_190916_E() == this.lOutput.getSlotLimit(0);
        boolean outputMatches = TileEntitySimulationChamber.dataModelMatchesOutput(this.getDataModel(), this.getLiving());
        return stackLimitReached || !outputMatches;
    }

    public boolean isCrafting() {
        return this.isCrafting;
    }

    public boolean pristineIsFull() {
        ItemStack stack = this.getPristine();
        if (stack.func_190926_b()) {
            return false;
        }
        boolean stackLimitReached = stack.func_190916_E() == this.pOutput.getSlotLimit(0);
        boolean outputMatches = TileEntitySimulationChamber.dataModelMatchesPristine(this.getDataModel(), this.getPristine());
        return stackLimitReached || !outputMatches;
    }

    private static boolean dataModelMatchesOutput(ItemStack stack, ItemStack output) {
        ItemLivingMatter livingMatter = DataModel.getMobMetaData(stack).getLivingMatter();
        return ((Object)((Object)livingMatter)).getClass().equals(output.func_77973_b().getClass());
    }

    private static boolean dataModelMatchesPristine(ItemStack stack, ItemStack pristine) {
        ItemPristineMatter pristineMatter = DataModel.getMobMetaData(stack).getPristineMatter();
        return ((Object)((Object)pristineMatter)).getClass().equals(pristine.func_77973_b().getClass());
    }

    private void updateSimulationText(ItemStack stack) {
        String[] lines = new String[]{"> Launching runtime", "v1.4.7", "> Iteration #" + (DataModel.getTotalSimulationCount(stack) + 1) + " started", "> Loading model from chip memory", "> Assessing threat level", "> Engaged enemy", "> Pristine procurement", this.byproductSuccess ? "succeeded" : "failed", "> Processing results", "..."};
        String resultPrefix = this.byproductSuccess ? "\u00a7a" : "\u00a7c";
        Animation aLine1 = this.getAnimation("simulationProgressLine1");
        Animation aLine1Version = this.getAnimation("simulationProgressLine1Version");
        Animation aLine2 = this.getAnimation("simulationProgressLine2");
        Animation aLine3 = this.getAnimation("simulationProgressLine3");
        Animation aLine4 = this.getAnimation("simulationProgressLine4");
        Animation aLine5 = this.getAnimation("simulationProgressLine5");
        Animation aLine6 = this.getAnimation("simulationProgressLine6");
        Animation aLine6Result = this.getAnimation("simulationProgressLine6Result");
        Animation aLine7 = this.getAnimation("simulationProgressLine7");
        Animation aLine8 = this.getAnimation("blinkingDots1");
        this.simulationText.put("simulationProgressLine1", this.animate(lines[0], aLine1, null, 1, false));
        this.simulationText.put("simulationProgressLine1Version", "\u00a76" + this.animate(lines[1], aLine1Version, aLine1, 1, false) + "\u00a7r");
        this.simulationText.put("simulationProgressLine2", this.animate(lines[2], aLine2, aLine1Version, 1, false));
        this.simulationText.put("simulationProgressLine3", this.animate(lines[3], aLine3, aLine2, 2, false));
        this.simulationText.put("simulationProgressLine4", this.animate(lines[4], aLine4, aLine3, 1, false));
        this.simulationText.put("simulationProgressLine5", this.animate(lines[5], aLine5, aLine4, 2, false));
        this.simulationText.put("simulationProgressLine6", this.animate(lines[6], aLine6, aLine5, 2, false));
        this.simulationText.put("simulationProgressLine6Result", resultPrefix + this.animate(lines[7], aLine6Result, aLine6, 2, false) + "\u00a7r");
        this.simulationText.put("simulationProgressLine7", this.animate(lines[8], aLine7, aLine6Result, 1, false));
        this.simulationText.put("blinkingDots1", this.animate(lines[9], aLine8, aLine7, 8, true));
    }

    public void resetAnimations() {
        this.simulationAnimations = new HashMap();
        this.simulationText = new HashMap();
    }

    private String animate(String string, Animation anim, @Nullable Animation precedingAnim, int delayInTicks, boolean loop) {
        if (precedingAnim != null) {
            if (precedingAnim.hasFinished()) {
                return anim.animate(string, delayInTicks, this.field_145850_b.func_82737_E(), loop);
            }
            return "";
        }
        return anim.animate(string, delayInTicks, this.field_145850_b.func_82737_E(), loop);
    }

    private Animation getAnimation(String key) {
        if (this.simulationAnimations.containsKey(key)) {
            return this.simulationAnimations.get(key);
        }
        this.simulationAnimations.put(key, new Animation());
        return this.simulationAnimations.get(key);
    }

    public String getSimulationText(String key) {
        if (this.simulationText.containsKey(key)) {
            return this.simulationText.get(key);
        }
        this.simulationText.put(key, "");
        return this.simulationText.get(key);
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.func_174877_v(), 3, this.func_189515_b(new NBTTagCompound()));
    }

    public final NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity packet) {
        this.func_145839_a(packet.func_148857_g());
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        compound.func_74768_a("simulationProgress", this.percentDone);
        compound.func_74757_a("isCrafting", this.isCrafting);
        compound.func_74757_a("craftSuccess", this.byproductSuccess);
        compound.func_74782_a("dataModel", (NBTBase)this.dataModel.serializeNBT());
        compound.func_74782_a("polymer", (NBTBase)this.polymer.serializeNBT());
        compound.func_74782_a("lOutput", (NBTBase)this.lOutput.serializeNBT());
        compound.func_74782_a("pOutput", (NBTBase)this.pOutput.serializeNBT());
        compound.func_74782_a("dataModel", (NBTBase)this.dataModel.serializeNBT());
        compound.func_74782_a("simulationText", (NBTBase)this.getNBTForSimulationText());
        this.energyStorage.writeEnergy(compound);
        return super.func_189515_b(compound);
    }

    public void func_145839_a(NBTTagCompound compound) {
        this.dataModel.deserializeNBT(compound.func_74775_l("dataModel"));
        this.polymer.deserializeNBT(compound.func_74775_l("polymer"));
        this.lOutput.deserializeNBT(compound.func_74775_l("lOutput"));
        this.pOutput.deserializeNBT(compound.func_74775_l("pOutput"));
        this.dataModel.deserializeNBT(compound.func_74775_l("dataModel"));
        this.setSimulationTextFromNBT(compound.func_74775_l("simulationText"));
        this.energyStorage.readEnergy(compound);
        this.percentDone = compound.func_150297_b("simulationProgress", 3) ? compound.func_74762_e("simulationProgress") : 0;
        this.isCrafting = compound.func_150297_b("isCrafting", 1) ? compound.func_74767_n("isCrafting") : this.isCrafting;
        this.byproductSuccess = compound.func_150297_b("craftSuccess", 1) ? compound.func_74767_n("craftSuccess") : this.isCrafting;
        super.func_145839_a(compound);
    }

    private NBTTagCompound getNBTForSimulationText() {
        NBTTagCompound tag = new NBTTagCompound();
        this.simulationText.forEach((arg_0, arg_1) -> ((NBTTagCompound)tag).func_74778_a(arg_0, arg_1));
        return tag;
    }

    private void setSimulationTextFromNBT(NBTTagCompound tag) {
        this.simulationText.forEach((key, text) -> this.simulationText.put((String)key, tag.func_74779_i(key)));
    }

    private void doStaggeredDiskSave(int divisor) {
        if (this.ticks % divisor == 0 && this.energy != this.energyStorage.getEnergyStored()) {
            this.energy = this.energyStorage.getEnergyStored();
            this.func_70296_d();
        }
    }

    public boolean hasCapability(Capability capability, @Nullable EnumFacing facing) {
        return capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY || capability == CapabilityEnergy.ENERGY || super.hasCapability(capability, facing);
    }

    @Nullable
    public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            if (facing == null) {
                return (T)CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.cast((Object)new CombinedInvWrapper(new IItemHandlerModifiable[]{this.dataModel, this.polymer, this.lOutput, this.pOutput}));
            }
            if (facing == EnumFacing.UP) {
                return (T)CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.cast((Object)new CombinedInvWrapper(new IItemHandlerModifiable[]{this.dataModel, this.polymer}));
            }
            return (T)CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.cast((Object)new CombinedInvWrapper(new IItemHandlerModifiable[]{this.lOutput, this.pOutput}));
        }
        if (capability == CapabilityEnergy.ENERGY) {
            return (T)CapabilityEnergy.ENERGY.cast((Object)this.energyStorage);
        }
        return (T)super.getCapability(capability, facing);
    }

    @Override
    public int getGuiID() {
        return 2;
    }
}

