/*
 * Decompiled with CFR 0.152.
 */
package com.bloodnbonesgaming.triumph.advancements.criterion.data;

import com.bloodnbonesgaming.lib.util.script.ArgType;
import com.bloodnbonesgaming.lib.util.script.ScriptArgs;
import com.bloodnbonesgaming.lib.util.script.ScriptClassDocumentation;
import com.bloodnbonesgaming.lib.util.script.ScriptMethodDocumentation;
import com.bloodnbonesgaming.triumph.advancements.criterion.data.CriterionTriggerData;
import com.bloodnbonesgaming.triumph.config.data.LocationData;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.ICriterionInstance;
import net.minecraft.advancements.critereon.PositionTrigger;
import net.minecraft.util.ResourceLocation;

@ScriptClassDocumentation(documentationFile="./config/triumph/documentation/criteria/triggers/minecraft/slept_in_bed", classExplaination="These are the functions which can be called on a minecraft:slept_in_bed trigger.")
public class SleptInBedTriggerData
extends CriterionTriggerData {
    private static final ResourceLocation location = new ResourceLocation("minecraft:slept_in_bed");
    private final LocationData locationData = new LocationData();

    public SleptInBedTriggerData(String criterionName, String advancementName) {
        super(criterionName, advancementName);
    }

    @Override
    public Criterion buildCriterion() {
        return new Criterion((ICriterionInstance)new PositionTrigger.Instance(location, this.locationData.buildLocationPredicate()));
    }

    @ScriptMethodDocumentation(usage="", notes="Returns the LocationData object so functions can be called on it.")
    public LocationData getLocationData() {
        return this.locationData;
    }

    @ScriptArgs(args={ArgType.NON_NULL_BIOME_ID})
    @ScriptMethodDocumentation(usage="biome id", notes="Sets the biome id. Can be an int or String.")
    public void setBiome(int id) {
        this.locationData.setBiome(id);
    }

    @ScriptMethodDocumentation(args="String", usage="feature id", notes="Sets the feature id. Used for things like structures.")
    public void setFeature(String feature) {
        this.locationData.setFeature(feature);
    }

    @ScriptMethodDocumentation(args="int", usage="dimension id", notes="Sets the dimension id.")
    public void setDimID(int dimID) {
        this.locationData.setDimID(dimID);
    }

    @ScriptMethodDocumentation(args="String", usage="WorldType id", notes="Sets the WorldType id.")
    public void setWorldType(String worldType) {
        this.locationData.setWorldType(worldType);
    }

    @ScriptMethodDocumentation(args="String", usage="generator string", notes="Sets the generator options string.")
    public void setGeneratorOptions(String generatorOptions) {
        this.locationData.setGeneratorOptions(generatorOptions);
    }
}

