/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.modularmachinery.common.machine;

import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import hellfirepvp.modularmachinery.common.crafting.MachineRecipe;
import hellfirepvp.modularmachinery.common.crafting.RecipeRegistry;
import hellfirepvp.modularmachinery.common.crafting.helper.ComponentSelectorTag;
import hellfirepvp.modularmachinery.common.crafting.helper.RecipeCraftingContext;
import hellfirepvp.modularmachinery.common.data.Config;
import hellfirepvp.modularmachinery.common.machine.MachineComponent;
import hellfirepvp.modularmachinery.common.machine.MachineLoader;
import hellfirepvp.modularmachinery.common.machine.TaggedPositionBlockArray;
import hellfirepvp.modularmachinery.common.modifier.ModifierReplacement;
import hellfirepvp.modularmachinery.common.tiles.TileMachineController;
import hellfirepvp.modularmachinery.common.util.BlockArray;
import hellfirepvp.modularmachinery.common.util.nbt.NBTJsonDeserializer;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.client.resources.I18n;
import net.minecraft.nbt.NBTException;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class DynamicMachine {
    @Nonnull
    private final ResourceLocation registryName;
    private String localizedName = null;
    private TaggedPositionBlockArray pattern = new TaggedPositionBlockArray();
    private int definedColor = Config.machineColor;
    private Map<BlockPos, List<ModifierReplacement>> modifiers = new HashMap<BlockPos, List<ModifierReplacement>>();
    private boolean requiresBlueprint = false;

    public DynamicMachine(@Nonnull ResourceLocation registryName) {
        this.registryName = registryName;
    }

    public void setRequiresBlueprint() {
        this.requiresBlueprint = true;
    }

    public boolean requiresBlueprint() {
        return this.requiresBlueprint;
    }

    public TaggedPositionBlockArray getPattern() {
        return this.pattern;
    }

    public Map<BlockPos, List<ModifierReplacement>> getModifiers() {
        return this.modifiers;
    }

    @Nonnull
    public ModifierReplacementMap getModifiersAsMatchingReplacements() {
        ModifierReplacementMap infoMap = new ModifierReplacementMap();
        for (BlockPos pos : this.modifiers.keySet()) {
            infoMap.put(pos, this.modifiers.get(pos).stream().map(ModifierReplacement::getBlockInformation).collect(Collectors.toList()));
        }
        return infoMap;
    }

    public void setLocalizedName(String localizedName) {
        this.localizedName = localizedName;
    }

    @SideOnly(value=Side.CLIENT)
    public String getLocalizedName() {
        if (this.localizedName != null) {
            return this.localizedName;
        }
        String localizationKey = this.registryName.func_110624_b() + "." + this.registryName.func_110623_a();
        return I18n.func_188566_a((String)localizationKey) ? I18n.func_135052_a((String)localizationKey, (Object[])new Object[0]) : localizationKey;
    }

    public int getMachineColor() {
        return this.definedColor;
    }

    @Nonnull
    public ResourceLocation getRegistryName() {
        return this.registryName;
    }

    @Nonnull
    public Iterable<MachineRecipe> getAvailableRecipes() {
        return RecipeRegistry.getRegistry().getRecipesFor(this);
    }

    public RecipeCraftingContext createContext(MachineRecipe recipe, TileMachineController controller, Collection<Tuple<MachineComponent<?>, ComponentSelectorTag>> taggedComponents, Collection<ModifierReplacement> modifiers) {
        if (!recipe.getOwningMachineIdentifier().equals((Object)this.getRegistryName())) {
            throw new IllegalArgumentException("Tried to create context for a recipe that doesn't belong to the referenced machine!");
        }
        RecipeCraftingContext context = new RecipeCraftingContext(recipe, controller);
        taggedComponents.forEach(tpl -> context.addComponent((MachineComponent)tpl.func_76341_a(), (ComponentSelectorTag)tpl.func_76340_b()));
        modifiers.forEach(context::addModifier);
        return context;
    }

    public static class MachineDeserializer
    implements JsonDeserializer<DynamicMachine> {
        public DynamicMachine deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            JsonObject root = json.getAsJsonObject();
            String registryName = JsonUtils.func_151219_a((JsonObject)root, (String)"registryname", (String)"");
            if (registryName.isEmpty() && (registryName = JsonUtils.func_151219_a((JsonObject)root, (String)"registryName", (String)"")).isEmpty()) {
                throw new JsonParseException("Invalid/Missing 'registryname' !");
            }
            String localized = JsonUtils.func_151219_a((JsonObject)root, (String)"localizedname", (String)"");
            if (localized.isEmpty()) {
                throw new JsonParseException("Invalid/Missing 'localizedname' !");
            }
            JsonArray parts = JsonUtils.func_151213_a((JsonObject)root, (String)"parts", (JsonArray)new JsonArray());
            if (parts.size() == 0) {
                throw new JsonParseException("Empty/Missing 'parts'!");
            }
            DynamicMachine machine = new DynamicMachine(new ResourceLocation("modularmachinery", registryName));
            machine.setLocalizedName(localized);
            if (root.has("requires-blueprint")) {
                JsonElement elementBlueprint = root.get("requires-blueprint");
                if (!elementBlueprint.isJsonPrimitive() || !elementBlueprint.getAsJsonPrimitive().isBoolean()) {
                    throw new JsonParseException("'requires-blueprint' has to be either 'true' or 'false'!");
                }
                boolean requiresBlueprint = elementBlueprint.getAsJsonPrimitive().getAsBoolean();
                if (requiresBlueprint) {
                    machine.setRequiresBlueprint();
                }
            }
            if (root.has("color")) {
                int hexColor;
                JsonElement elementColor = root.get("color");
                if (!elementColor.isJsonPrimitive()) {
                    throw new JsonParseException("The Color defined in 'color' should be a hex integer number! Found " + elementColor.toString() + " instead!");
                }
                String hexStr = elementColor.getAsJsonPrimitive().getAsString();
                try {
                    hexColor = Integer.parseInt(hexStr, 16);
                }
                catch (NumberFormatException parseExc) {
                    throw new JsonParseException("The Color defined in 'color' should be a hex integer number! Found " + elementColor.toString() + " instead!", (Throwable)parseExc);
                }
                machine.definedColor = hexColor;
            }
            for (int i = 0; i < parts.size(); ++i) {
                JsonElement element = parts.get(i);
                if (!element.isJsonObject()) {
                    throw new JsonParseException("A part of 'parts' is not a compound object!");
                }
                JsonObject part = element.getAsJsonObject();
                NBTTagCompound match = null;
                if (part.has("nbt")) {
                    JsonElement je = part.get("nbt");
                    if (!je.isJsonObject()) {
                        throw new JsonParseException("The ComponentType 'nbt' expects a json compound that defines the NBT tag to match the tileentity's nbt against!");
                    }
                    String jsonStr = je.toString();
                    try {
                        match = NBTJsonDeserializer.deserialize(jsonStr);
                    }
                    catch (NBTException exc) {
                        throw new JsonParseException("Error trying to parse NBTTag! Rethrowing exception...", (Throwable)exc);
                    }
                }
                if (!part.has("elements")) {
                    throw new JsonParseException("Part contained no element!");
                }
                JsonElement partElement = part.get("elements");
                if (partElement.isJsonPrimitive() && partElement.getAsJsonPrimitive().isString()) {
                    String strDesc = partElement.getAsString();
                    BlockArray.BlockInformation descr = MachineLoader.variableContext.get(strDesc);
                    descr = descr == null ? new BlockArray.BlockInformation(Lists.newArrayList((Object[])new BlockArray.IBlockStateDescriptor[]{BlockArray.BlockInformation.getDescriptor(partElement.getAsString())})) : descr.copy();
                    if (match != null) {
                        descr.setMatchingTag(match);
                    }
                    this.addDescriptorWithPattern(machine.getPattern(), descr, part);
                    continue;
                }
                if (partElement.isJsonArray()) {
                    JsonArray elementArray = partElement.getAsJsonArray();
                    ArrayList descriptors = Lists.newArrayList();
                    for (int xx = 0; xx < elementArray.size(); ++xx) {
                        JsonElement p = elementArray.get(xx);
                        if (!p.isJsonPrimitive() || !p.getAsJsonPrimitive().isString()) {
                            throw new JsonParseException("Part elements of 'elements' have to be blockstate descriptions!");
                        }
                        String prim = p.getAsString();
                        BlockArray.BlockInformation descr = MachineLoader.variableContext.get(prim);
                        if (descr != null) {
                            descriptors.addAll(descr.copy().matchingStates);
                            continue;
                        }
                        descriptors.add(BlockArray.BlockInformation.getDescriptor(prim));
                    }
                    if (descriptors.isEmpty()) {
                        throw new JsonParseException("'elements' array didn't contain any blockstate descriptors!");
                    }
                    BlockArray.BlockInformation bi = new BlockArray.BlockInformation(descriptors);
                    if (match != null) {
                        bi.setMatchingTag(match);
                    }
                    this.addDescriptorWithPattern(machine.getPattern(), bi, part);
                    continue;
                }
                throw new JsonParseException("'elements' has to either be a blockstate description, variable or array of blockstate descriptions!");
            }
            if (root.has("modifiers")) {
                JsonElement partModifiers = root.get("modifiers");
                if (!partModifiers.isJsonArray()) {
                    throw new JsonParseException("'modifiers' has to be an array of modifiers!");
                }
                JsonArray modifiersArray = partModifiers.getAsJsonArray();
                for (int j = 0; j < modifiersArray.size(); ++j) {
                    JsonElement modifier = modifiersArray.get(j);
                    if (!modifier.isJsonObject()) {
                        throw new JsonParseException("Elements of 'modifiers' have to be objects!");
                    }
                    this.addModifierWithPattern(machine, (ModifierReplacement)context.deserialize((JsonElement)modifier.getAsJsonObject(), ModifierReplacement.class), modifier.getAsJsonObject());
                }
            }
            return machine;
        }

        private void addModifierWithPattern(DynamicMachine machine, ModifierReplacement mod, JsonObject part) throws JsonParseException {
            ArrayList<Integer> avX = new ArrayList<Integer>();
            ArrayList<Integer> avY = new ArrayList<Integer>();
            ArrayList<Integer> avZ = new ArrayList<Integer>();
            this.addCoordinates("x", part, avX);
            this.addCoordinates("y", part, avY);
            this.addCoordinates("z", part, avZ);
            for (BlockPos permutation : this.buildPermutations(avX, avY, avZ)) {
                if (permutation.func_177958_n() == 0 && permutation.func_177956_o() == 0 && permutation.func_177952_p() == 0) continue;
                machine.modifiers.putIfAbsent(permutation, Lists.newArrayList());
                ((List)machine.modifiers.get(permutation)).add(mod);
            }
        }

        private void addDescriptorWithPattern(TaggedPositionBlockArray pattern, BlockArray.BlockInformation information, JsonObject part) throws JsonParseException {
            ArrayList<Integer> avX = new ArrayList<Integer>();
            ArrayList<Integer> avY = new ArrayList<Integer>();
            ArrayList<Integer> avZ = new ArrayList<Integer>();
            this.addCoordinates("x", part, avX);
            this.addCoordinates("y", part, avY);
            this.addCoordinates("z", part, avZ);
            String tag = null;
            if (part.has("selector-tag")) {
                JsonElement strTag = part.get("selector-tag");
                if (!strTag.isJsonPrimitive()) {
                    throw new JsonParseException("The 'selector-tag' in an element must be a string!");
                }
                tag = strTag.getAsString();
            }
            ComponentSelectorTag selector = tag != null && !tag.isEmpty() ? new ComponentSelectorTag(tag) : null;
            for (BlockPos permutation : this.buildPermutations(avX, avY, avZ)) {
                if (permutation.func_177958_n() == 0 && permutation.func_177956_o() == 0 && permutation.func_177952_p() == 0) continue;
                pattern.addBlock(permutation, information);
                if (tag == null || tag.isEmpty()) continue;
                pattern.setTag(permutation, selector);
            }
        }

        private List<BlockPos> buildPermutations(List<Integer> avX, List<Integer> avY, List<Integer> avZ) {
            ArrayList<BlockPos> out = new ArrayList<BlockPos>(avX.size() * avY.size() * avZ.size());
            for (int x : avX) {
                for (int y : avY) {
                    for (int z : avZ) {
                        out.add(new BlockPos(x, y, z));
                    }
                }
            }
            return out;
        }

        private void addCoordinates(String key, JsonObject part, List<Integer> out) throws JsonParseException {
            if (!part.has(key)) {
                out.add(0);
                return;
            }
            JsonElement coordinateElement = part.get(key);
            if (coordinateElement.isJsonPrimitive() && coordinateElement.getAsJsonPrimitive().isNumber()) {
                out.add(coordinateElement.getAsInt());
            } else if (coordinateElement.isJsonArray() && coordinateElement.getAsJsonArray().size() > 0) {
                for (JsonElement element : coordinateElement.getAsJsonArray()) {
                    if (element.isJsonPrimitive() && element.getAsJsonPrimitive().isNumber()) {
                        out.add(element.getAsInt());
                        continue;
                    }
                    throw new JsonParseException("Expected only numbers in JsonArray " + coordinateElement.toString() + " but found " + element.toString());
                }
            }
        }
    }

    public static class ModifierReplacementMap
    extends HashMap<BlockPos, List<BlockArray.BlockInformation>> {
        public ModifierReplacementMap rotateYCCW() {
            ModifierReplacementMap map = new ModifierReplacementMap();
            for (BlockPos pos : this.keySet()) {
                List infoList = (List)this.get(pos);
                ArrayList<BlockArray.BlockInformation> copyRotated = new ArrayList<BlockArray.BlockInformation>(infoList.size());
                for (BlockArray.BlockInformation info : infoList) {
                    copyRotated.add(info.copyRotateYCCW());
                }
                map.put(new BlockPos(pos.func_177952_p(), pos.func_177956_o(), -pos.func_177958_n()), copyRotated);
            }
            return map;
        }
    }
}

