/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.modularmachinery.common.crafting.helper;

import hellfirepvp.modularmachinery.common.crafting.ComponentType;
import hellfirepvp.modularmachinery.common.crafting.helper.ComponentOutputRestrictor;
import hellfirepvp.modularmachinery.common.crafting.helper.ComponentSelectorTag;
import hellfirepvp.modularmachinery.common.crafting.helper.CraftCheck;
import hellfirepvp.modularmachinery.common.crafting.helper.RecipeCraftingContext;
import hellfirepvp.modularmachinery.common.integration.recipe.RecipeLayoutPart;
import hellfirepvp.modularmachinery.common.machine.MachineComponent;
import hellfirepvp.modularmachinery.common.modifier.RecipeModifier;
import hellfirepvp.modularmachinery.common.util.ResultChance;
import java.awt.Point;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class ComponentRequirement<T> {
    private final ComponentType componentType;
    private final MachineComponent.IOType actionType;
    private ComponentSelectorTag tag = null;

    public ComponentRequirement(ComponentType componentType, MachineComponent.IOType actionType) {
        this.componentType = componentType;
        this.actionType = actionType;
    }

    public final ComponentType getRequiredComponentType() {
        return this.componentType;
    }

    public final MachineComponent.IOType getActionType() {
        return this.actionType;
    }

    public final void setTag(ComponentSelectorTag tag) {
        this.tag = tag;
    }

    public final ComponentSelectorTag getTag() {
        return this.tag;
    }

    public abstract boolean startCrafting(MachineComponent var1, RecipeCraftingContext var2, ResultChance var3);

    public abstract boolean finishCrafting(MachineComponent var1, RecipeCraftingContext var2, ResultChance var3);

    @Nonnull
    public abstract CraftCheck canStartCrafting(MachineComponent var1, RecipeCraftingContext var2, List<ComponentOutputRestrictor> var3);

    public abstract ComponentRequirement<T> deepCopy();

    public abstract ComponentRequirement<T> deepCopyModified(List<RecipeModifier> var1);

    public abstract void startRequirementCheck(ResultChance var1, RecipeCraftingContext var2);

    public abstract void endRequirementCheck();

    public abstract JEIComponent<T> provideJEIComponent();

    public static interface ChancedRequirement {
        public void setChance(float var1);
    }

    public static abstract class PerTick<T>
    extends ComponentRequirement<T> {
        public PerTick(ComponentType componentType, MachineComponent.IOType actionType) {
            super(componentType, actionType);
        }

        public abstract void startIOTick(RecipeCraftingContext var1, float var2);

        @Nonnull
        public abstract CraftCheck resetIOTick(RecipeCraftingContext var1);

        @Nonnull
        public abstract CraftCheck doIOTick(MachineComponent var1, RecipeCraftingContext var2);
    }

    public static abstract class JEIComponent<T> {
        public abstract Class<T> getJEIRequirementClass();

        public abstract List<T> getJEIIORequirements();

        @SideOnly(value=Side.CLIENT)
        public abstract RecipeLayoutPart<T> getLayoutPart(Point var1);

        @SideOnly(value=Side.CLIENT)
        public abstract void onJEIHoverTooltip(int var1, boolean var2, T var3, List<String> var4);
    }
}

