/*
 * Decompiled with CFR 0.152.
 */
package com.latmod.yabba.gui;

import com.feed_the_beast.ftblib.lib.gui.GuiHelper;
import com.feed_the_beast.ftblib.lib.gui.GuiIcons;
import com.feed_the_beast.ftblib.lib.gui.Panel;
import com.feed_the_beast.ftblib.lib.gui.SimpleTextButton;
import com.feed_the_beast.ftblib.lib.gui.Theme;
import com.feed_the_beast.ftblib.lib.gui.Widget;
import com.feed_the_beast.ftblib.lib.gui.misc.GuiButtonListBase;
import com.feed_the_beast.ftblib.lib.icon.Icon;
import com.feed_the_beast.ftblib.lib.icon.ItemIcon;
import com.feed_the_beast.ftblib.lib.util.StringUtils;
import com.feed_the_beast.ftblib.lib.util.misc.MouseButton;
import com.latmod.yabba.YabbaItems;
import com.latmod.yabba.net.MessageOpenBarrelGui;
import com.latmod.yabba.tile.ItemBarrel;
import com.latmod.yabba.tile.TileItemBarrel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.items.ItemHandlerHelper;

public class GuiBarrelConnector
extends GuiButtonListBase {
    private List<TileItemBarrel> barrels;

    public GuiBarrelConnector(ITextComponent t, Collection<BlockPos> c) {
        this.setTitle(t.func_150254_d());
        this.setHasSearchBox(true);
        this.barrels = new ArrayList<TileItemBarrel>();
        for (BlockPos p : c) {
            TileEntity tileEntity = Minecraft.func_71410_x().field_71441_e.func_175625_s(p);
            if (!(tileEntity instanceof TileItemBarrel)) continue;
            this.barrels.add((TileItemBarrel)tileEntity);
        }
        this.barrels.sort((o1, o2) -> Integer.compare(((ItemBarrel)o2.barrel.content).count, ((ItemBarrel)o1.barrel.content).count));
    }

    public void addButtons(Panel panel) {
        for (final TileItemBarrel tile : this.barrels) {
            Icon icon;
            String title;
            ItemStack barrelStack = new ItemStack(YabbaItems.ITEM_BARREL);
            tile.writeToItem(barrelStack);
            final Icon icon2 = ItemIcon.getItemIcon((ItemStack)barrelStack);
            ItemBarrel barrel = (ItemBarrel)tile.barrel.content;
            if (!barrel.type.func_190926_b()) {
                title = StringUtils.formatDouble((double)barrel.count, (boolean)true) + "x " + TextFormatting.func_110646_a((String)barrel.type.func_82833_r());
                icon = ItemIcon.getItemIcon((ItemStack)ItemHandlerHelper.copyStackWithSize((ItemStack)barrel.type, (int)1));
            } else {
                title = "Empty";
                icon = icon2;
            }
            SimpleTextButton button = new SimpleTextButton(panel, title, icon){

                public void onClicked(MouseButton button) {
                    GuiHelper.playClickSound();
                    new MessageOpenBarrelGui(tile.func_174877_v()).sendToServer();
                }

                public void addMouseOverText(List<String> list) {
                    super.addMouseOverText(list);
                    if (1.isShiftKeyDown()) {
                        BlockPos p = tile.func_174877_v();
                        list.add(TextFormatting.DARK_GRAY + "[" + p.func_177958_n() + ", " + p.func_177956_o() + ", " + p.func_177952_p() + "]");
                    }
                }

                public boolean hasIcon() {
                    return !(1.isShiftKeyDown() ? icon2 : this.icon).isEmpty();
                }

                public void drawIcon(Theme theme, int x, int y, int w, int h) {
                    (1.isShiftKeyDown() ? icon2 : this.icon).draw(x, y, w, h);
                    if (tile.barrel.isLocked()) {
                        GlStateManager.func_179094_E();
                        GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)500.0f);
                        GuiIcons.LOCK.draw(x + w / 2, y, w / 2, h / 2);
                        GlStateManager.func_179121_F();
                    }
                }
            };
            panel.add((Widget)button);
        }
    }
}

