/*
 * Decompiled with CFR 0.152.
 */
package com.latmod.yabba.gui;

import com.feed_the_beast.ftblib.lib.gui.GuiBase;
import com.feed_the_beast.ftblib.lib.gui.GuiContainerWrapper;
import com.feed_the_beast.ftblib.lib.gui.GuiHelper;
import com.feed_the_beast.ftblib.lib.gui.Panel;
import com.feed_the_beast.ftblib.lib.gui.PanelScrollBar;
import com.feed_the_beast.ftblib.lib.gui.Theme;
import com.feed_the_beast.ftblib.lib.gui.Widget;
import com.feed_the_beast.ftblib.lib.gui.WidgetType;
import com.feed_the_beast.ftblib.lib.icon.Icon;
import com.feed_the_beast.ftblib.lib.icon.ItemIcon;
import com.feed_the_beast.ftblib.lib.item.ItemEntry;
import com.feed_the_beast.ftblib.lib.item.ItemEntryWithCount;
import com.feed_the_beast.ftblib.lib.util.misc.MouseButton;
import com.latmod.yabba.YabbaConfig;
import com.latmod.yabba.gui.ContainerAntibarrel;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.inventory.Container;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.TextFormatting;

public class GuiAntibarrel
extends GuiBase {
    public final ContainerAntibarrel container;
    public final Panel panel;
    public final PanelScrollBar scrollBar;
    public String title = "";

    public GuiAntibarrel(ContainerAntibarrel c) {
        this.container = c;
        this.panel = new Panel((Panel)this){

            public void addWidgets() {
                for (ItemEntryWithCount entry : GuiAntibarrel.this.container.tile.contents.items.values()) {
                    this.add(new ButtonItem(this, entry));
                }
                int s = GuiAntibarrel.this.container.tile.contents.items.size() % 8;
                if (s != 0) {
                    for (int i = 0; i < 8 - s; ++i) {
                        this.add(new ButtonItem(this, ItemEntryWithCount.EMPTY));
                    }
                }
                this.widgets.sort(null);
            }

            public void alignWidgets() {
                for (int i = 0; i < this.widgets.size(); ++i) {
                    Widget widget = (Widget)this.widgets.get(i);
                    widget.setPos(i % 8 * 18, i / 8 * 18);
                }
                GuiAntibarrel.this.scrollBar.setMaxValue(MathHelper.func_76123_f((float)((float)this.widgets.size() / 8.0f)) * 18);
            }

            public void drawBackground(Theme theme, int x, int y, int w, int h) {
                theme.drawSlot(x, y, w, h, WidgetType.NORMAL);
            }

            public boolean mousePressed(MouseButton button) {
                if (super.mousePressed(button)) {
                    return true;
                }
                if (button.isLeft() && this.isMouseOver() && !Minecraft.func_71410_x().field_71439_g.field_71071_by.func_70445_o().func_190926_b()) {
                    ((GuiAntibarrel)this.getGui()).container.onClick(ItemEntry.EMPTY, 1.isShiftKeyDown());
                    return true;
                }
                return false;
            }
        };
        this.panel.setUnicode(true);
        this.panel.setPosAndSize(7, 7, 144, 72);
        this.scrollBar = new PanelScrollBar((Panel)this, this.panel);
        this.scrollBar.setPosAndSize(157, this.panel.posY, 12, this.panel.height);
        this.scrollBar.setCanAlwaysScroll(true);
        this.scrollBar.setScrollStep(18);
    }

    public void addWidgets() {
        this.add((Widget)this.panel);
        this.add((Widget)this.scrollBar);
        this.container.tile.contents.getHash();
        this.title = I18n.func_135052_a((String)"tile.yabba.antibarrel.items", (Object[])new Object[]{this.container.tile.contents.clientItemsStored, this.container.tile.contents.clientTypesStored, YabbaConfig.general.antibarrel_capacity});
    }

    public GuiScreen getWrapper() {
        return new GuiContainerWrapper((GuiBase)this, (Container)this.container);
    }

    public void drawBackground(Theme theme, int x, int y, int w, int h) {
        super.drawBackground(theme, x, y, w, h);
        theme.drawString(this.title, x + 4, y - 10);
    }

    private static class ButtonItem
    extends Widget
    implements Comparable<ButtonItem> {
        private static final DecimalFormat FORMATTER_1 = new DecimalFormat("#0.00");
        private static final DecimalFormat FORMATTER_2 = new DecimalFormat("#0.0");
        public final ItemEntryWithCount entry;
        private List<String> tooltip;
        private Icon icon;
        private String countString;

        public ButtonItem(Panel panel, ItemEntryWithCount e) {
            super(panel);
            this.setSize(18, 18);
            this.entry = e;
            if (this.entry.isEmpty()) {
                return;
            }
            ItemStack stack = this.entry.getStack(true);
            stack.func_190920_e(1);
            this.countString = this.entry.count >= 1000000000 ? FORMATTER_1.format((double)this.entry.count / 1.0E9) + "B" : (this.entry.count >= 100000000 ? this.entry.count / 1000000 + "M" : (this.entry.count >= 10000000 ? FORMATTER_2.format((double)this.entry.count / 1000000.0) + "M" : (this.entry.count >= 1000000 ? FORMATTER_1.format((double)this.entry.count / 1000000.0) + "M" : (this.entry.count >= 100000 ? this.entry.count / 1000 + "K" : (this.entry.count >= 10000 ? FORMATTER_2.format((double)this.entry.count / 1000.0) + "K" : (this.entry.count >= 1000 ? FORMATTER_1.format((double)this.entry.count / 1000.0) + "K" : Integer.toString(this.entry.count)))))));
            this.icon = ItemIcon.getItemIcon((ItemStack)stack);
            this.tooltip = new ArrayList<String>();
            GuiHelper.addStackTooltip((ItemStack)stack, this.tooltip, (String)(TextFormatting.GRAY + (this.entry.count > 1 ? this.entry.count + "x " : "")));
        }

        public void addMouseOverText(List<String> list) {
            if (!this.entry.isEmpty()) {
                list.addAll(this.tooltip);
            }
        }

        public boolean mousePressed(MouseButton button) {
            if (button.isLeft() && !this.entry.isEmpty() && this.isMouseOver() && Minecraft.func_71410_x().field_71439_g.field_71071_by.func_70445_o().func_190926_b()) {
                ((GuiAntibarrel)this.getGui()).container.onClick(this.entry.entry, ButtonItem.isShiftKeyDown());
                return true;
            }
            return false;
        }

        public void draw(Theme theme, int x, int y, int w, int h) {
            theme.drawSlot(x, y, w, h, this.getWidgetType());
            if (!this.entry.isEmpty()) {
                theme.pushFontUnicode(false);
                this.icon.draw(x + 1, y + 1, 16, 16);
                GlStateManager.func_179094_E();
                GlStateManager.func_179109_b((float)((float)(x + 17) - (float)theme.getStringWidth(this.countString) / 2.0f), (float)(y + 13), (float)1000.0f);
                GlStateManager.func_179152_a((float)0.5f, (float)0.5f, (float)1.0f);
                theme.drawString(this.countString, 0, 0, theme.getContentColor(this.getWidgetType()), 2);
                GlStateManager.func_179121_F();
                theme.popFontUnicode();
            }
        }

        @Override
        public int compareTo(ButtonItem o) {
            int i1 = this.entry.isEmpty() ? Integer.MAX_VALUE : Item.func_150891_b((Item)this.entry.entry.item);
            int i2 = o.entry.isEmpty() ? Integer.MAX_VALUE : Item.func_150891_b((Item)o.entry.entry.item);
            return Integer.compare(i1, i2);
        }

        @Nullable
        public Object getJEIFocus() {
            return this.entry.isEmpty() ? null : this.entry.getStack(false);
        }
    }
}

