/*
 * Decompiled with CFR 0.152.
 */
package com.latmod.yabba;

import com.feed_the_beast.ftblib.events.FTBLibPreInitRegistryEvent;
import com.feed_the_beast.ftblib.lib.util.BlockUtils;
import com.latmod.yabba.Yabba;
import com.latmod.yabba.YabbaBlocks;
import com.latmod.yabba.YabbaConfig;
import com.latmod.yabba.YabbaItems;
import com.latmod.yabba.block.BlockAntibarrel;
import com.latmod.yabba.block.BlockDecorativeBlock;
import com.latmod.yabba.block.BlockItemBarrel;
import com.latmod.yabba.block.BlockItemBarrelConnector;
import com.latmod.yabba.block.Tier;
import com.latmod.yabba.item.ItemBlockAntibarrel;
import com.latmod.yabba.item.ItemHammer;
import com.latmod.yabba.item.ItemPainter;
import com.latmod.yabba.item.ItemWrench;
import com.latmod.yabba.item.upgrade.ItemUpgrade;
import com.latmod.yabba.item.upgrade.ItemUpgradeCreative;
import com.latmod.yabba.item.upgrade.ItemUpgradeHopper;
import com.latmod.yabba.item.upgrade.ItemUpgradeRedstone;
import com.latmod.yabba.item.upgrade.ItemUpgradeTier;
import com.latmod.yabba.tile.BarrelNetwork;
import com.latmod.yabba.tile.ItemBarrel;
import com.latmod.yabba.tile.TileAntibarrel;
import com.latmod.yabba.tile.TileCompoundItemBarrel;
import com.latmod.yabba.tile.TileDecorativeBlock;
import com.latmod.yabba.tile.TileItemBarrel;
import com.latmod.yabba.tile.TileItemBarrelConnector;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.entity.player.EntityItemPickupEvent;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod.EventBusSubscriber(modid="yabba")
public class YabbaEventHandler {
    private static final ResourceLocation WORLD_CAP_ID = new ResourceLocation("yabba", "barrel_network");

    private static Block withName(Block block, String name) {
        block.func_149647_a(Yabba.TAB);
        block.setRegistryName(name);
        block.func_149663_c("yabba." + name);
        return block;
    }

    private static Item withName(Item item, String name) {
        item.func_77637_a(Yabba.TAB);
        item.setRegistryName(name);
        item.func_77655_b("yabba." + name);
        return item;
    }

    @SubscribeEvent
    public static void registerBlocks(RegistryEvent.Register<Block> event) {
        event.getRegistry().registerAll((IForgeRegistryEntry[])new Block[]{YabbaEventHandler.withName((Block)new BlockItemBarrel(), "item_barrel"), YabbaEventHandler.withName(new BlockItemBarrelConnector(), "item_barrel_connector"), YabbaEventHandler.withName((Block)new BlockAntibarrel(), "antibarrel"), YabbaEventHandler.withName((Block)new BlockDecorativeBlock(), "decorative_block")});
        GameRegistry.registerTileEntity(TileItemBarrel.class, (ResourceLocation)new ResourceLocation("yabba", "item_barrel"));
        GameRegistry.registerTileEntity(TileItemBarrelConnector.class, (ResourceLocation)new ResourceLocation("yabba", "item_barrel_connector"));
        GameRegistry.registerTileEntity(TileAntibarrel.class, (ResourceLocation)new ResourceLocation("yabba", "antibarrel"));
        GameRegistry.registerTileEntity(TileCompoundItemBarrel.class, (ResourceLocation)new ResourceLocation("yabba", "compound_item_barrel"));
        GameRegistry.registerTileEntity(TileDecorativeBlock.class, (ResourceLocation)new ResourceLocation("yabba", "decorative_block"));
    }

    @SubscribeEvent
    public static void registerItems(RegistryEvent.Register<Item> event) {
        event.getRegistry().registerAll((IForgeRegistryEntry[])new Item[]{(Item)new ItemBlock(YabbaBlocks.ITEM_BARREL).setRegistryName("item_barrel"), (Item)new ItemBlock(YabbaBlocks.ITEM_BARREL_CONNECTOR).setRegistryName("item_barrel_connector"), (Item)new ItemBlockAntibarrel(YabbaBlocks.ANTIBARREL).setRegistryName("antibarrel"), (Item)new ItemBlock(YabbaBlocks.DECORATIVE_BLOCK).setRegistryName("decorative_block")});
        event.getRegistry().registerAll((IForgeRegistryEntry[])new Item[]{YabbaEventHandler.withName(new Item(), "upgrade_blank"), YabbaEventHandler.withName(new ItemUpgradeTier(Tier.IRON), "upgrade_iron_tier"), YabbaEventHandler.withName(new ItemUpgradeTier(Tier.GOLD), "upgrade_gold_tier"), YabbaEventHandler.withName(new ItemUpgradeTier(Tier.DIAMOND), "upgrade_diamond_tier"), YabbaEventHandler.withName(new ItemUpgradeTier(Tier.STAR), "upgrade_star_tier"), YabbaEventHandler.withName(new ItemUpgradeCreative(), "upgrade_creative"), YabbaEventHandler.withName(new ItemUpgrade(), "upgrade_obsidian_shell"), YabbaEventHandler.withName(new ItemUpgradeRedstone(), "upgrade_redstone_out"), YabbaEventHandler.withName(new ItemUpgradeHopper(), "upgrade_hopper"), YabbaEventHandler.withName(new ItemUpgrade(), "upgrade_void"), YabbaEventHandler.withName(new ItemUpgrade(), "upgrade_pickup"), YabbaEventHandler.withName(new ItemHammer(), "hammer"), YabbaEventHandler.withName(new ItemPainter(), "painter"), YabbaEventHandler.withName(new ItemWrench(), "wrench")});
    }

    @SubscribeEvent
    public static void onFTBLibPreInitRegistry(FTBLibPreInitRegistryEvent event) {
        event.getRegistry().registerServerReloadHandler(new ResourceLocation("yabba", "config"), reloadEvent -> YabbaConfig.sync());
    }

    @SubscribeEvent
    public static void attachWorldCap(AttachCapabilitiesEvent<World> event) {
        event.addCapability(WORLD_CAP_ID, (ICapabilityProvider)new BarrelNetwork((World)event.getObject()));
    }

    @SubscribeEvent
    public static void tickServerWorld(TickEvent.WorldTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            BarrelNetwork.get(event.world).tick();
        }
    }

    @SubscribeEvent
    public static void onItemPickup(EntityItemPickupEvent event) {
        boolean modified = false;
        EntityPlayer player = event.getEntityPlayer();
        EntityItem entityItem = event.getItem();
        ItemStack itemStack = entityItem.func_92059_d();
        int size = player.field_71071_by.func_70302_i_();
        for (int i = 0; i < size; ++i) {
            Item stackItem;
            ItemStack stack = player.field_71071_by.func_70301_a(i);
            if (stack.func_190916_E() != 1 || !BlockUtils.hasData((ItemStack)stack) || (stackItem = stack.func_77973_b()) != YabbaItems.ITEM_BARREL) continue;
            TileItemBarrel barrel = new TileItemBarrel();
            barrel.func_145839_a(BlockUtils.getData((ItemStack)stack));
            if (barrel.barrel.content.isEmpty() || !barrel.barrel.hasUpgrade(YabbaItems.UPGRADE_PICKUP)) continue;
            int originalSize = itemStack.func_190916_E();
            if (originalSize != (itemStack = ((ItemBarrel)barrel.barrel.content).insertItem(0, itemStack, false)).func_190916_E()) {
                entityItem.func_92058_a(itemStack);
                barrel.writeToItem(stack);
                modified = true;
            }
            if (!itemStack.func_190926_b()) continue;
            entityItem.func_70106_y();
            FMLCommonHandler.instance().firePlayerItemPickupEvent(player, entityItem, itemStack);
            if (!entityItem.func_174814_R()) {
                entityItem.field_70170_p.func_184148_a(null, entityItem.field_70165_t, entityItem.field_70163_u, entityItem.field_70161_v, SoundEvents.field_187638_cR, SoundCategory.PLAYERS, 0.2f, ((entityItem.field_70170_p.field_73012_v.nextFloat() - entityItem.field_70170_p.field_73012_v.nextFloat()) * 0.7f + 1.0f) * 2.0f);
            }
            player.func_71001_a((Entity)entityItem, originalSize);
            break;
        }
        if (modified) {
            event.setCanceled(true);
        }
    }
}

