/*
 * Decompiled with CFR 0.152.
 */
package com.gendeathrow.mputils.utils;

import java.lang.reflect.Field;
import java.util.List;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagList;

public class ReflectionHelper {
    private static final Field NBTTAGLIST_TAGLIST;
    public static final String[] NBTTAGLIST_TAGLIST_STRING;

    private ReflectionHelper() {
    }

    public static List<NBTBase> getTagList(NBTTagList list) {
        if (NBTTAGLIST_TAGLIST == null) {
            return null;
        }
        try {
            return (List)NBTTAGLIST_TAGLIST.get(list);
        }
        catch (IllegalArgumentException ex) {
            return null;
        }
        catch (IllegalAccessException ex) {
            return null;
        }
    }

    public static <T> T getPrivateStaticObject(Class<?> cls, String ... names) {
        for (String name : names) {
            try {
                Field field = cls.getDeclaredField(name);
                field.setAccessible(true);
                return (T)field.get(null);
            }
            catch (IllegalAccessException | NoSuchFieldException | SecurityException exception) {
            }
        }
        return null;
    }

    public static <T> T getPrivateObject(Object object, String ... names) {
        Class<?> cls = object.getClass();
        for (String name : names) {
            try {
                Field field = cls.getDeclaredField(name);
                field.setAccessible(true);
                return (T)field.get(object);
            }
            catch (IllegalAccessException | NoSuchFieldException | SecurityException exception) {
            }
        }
        return null;
    }

    private static Field getField(Class cls, String ... names) {
        for (String name : names) {
            try {
                Field field = cls.getDeclaredField(name);
                field.setAccessible(true);
                return field;
            }
            catch (NoSuchFieldException | SecurityException exception) {
            }
        }
        return null;
    }

    static {
        NBTTAGLIST_TAGLIST_STRING = new String[]{"tagList", "field_74747_a"};
        NBTTAGLIST_TAGLIST = ReflectionHelper.getField(NBTTagList.class, NBTTAGLIST_TAGLIST_STRING);
    }
}

