/*
 * Decompiled with CFR 0.152.
 */
package com.gendeathrow.mputils.api.client.gui.elements;

import com.gendeathrow.mputils.client.gui.elements.TextEditor;
import com.gendeathrow.mputils.core.MPUtils;
import com.gendeathrow.mputils.utils.RenderAssist;
import com.google.common.collect.Lists;
import java.awt.Color;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiConfirmOpenLink;
import net.minecraft.client.gui.GuiListExtended;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiYesNoCallback;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Mouse;

public class TextScrollWindow
extends GuiListExtended {
    private final List<Line> Lines = Lists.newArrayList();
    private String rawData;
    private Minecraft mc;
    private TextEditor editor;
    private final float scrollSpeed = 0.025f;
    ResourceLocation bg = new ResourceLocation("mputils", "textures/gui/bg.png");

    public TextScrollWindow(Minecraft mcIn, String text, int widthIn, int heightIn, int topIn, int bottomIn, int slotHeightIn) {
        super(mcIn, widthIn, heightIn, topIn, bottomIn, slotHeightIn);
        this.rawData = text;
        this.parseLines(mcIn);
        this.mc = mcIn;
    }

    public synchronized void setRawData(String data) {
        this.rawData = data;
        this.parseLines(Minecraft.func_71410_x());
    }

    public synchronized String getRawData() {
        return this.rawData;
    }

    protected void func_148129_a(int x, int y, Tessellator p_148129_3_) {
        Minecraft.func_71410_x().field_71466_p.func_78276_b("Whats New", x, this.field_148153_b, Color.white.getRGB());
    }

    public int func_148139_c() {
        return this.field_148155_a;
    }

    protected int func_148137_d() {
        return this.field_148155_a + this.field_148152_e;
    }

    public synchronized void parseLines(Minecraft mc) {
        String[] parsedData = this.rawData.replace("\r", "").replace("\t", "    ").split("\n");
        ArrayList lineBreaks = Lists.newArrayList();
        ArrayList wordWrap = Lists.newArrayList();
        this.Lines.clear();
        for (String line : parsedData) {
            List lines = mc.field_71466_p.func_78271_c(line, this.field_148155_a);
            wordWrap.addAll(lines);
            for (int i = 1; i <= lines.size(); ++i) {
                lineBreaks.add(i + "," + lines.size());
            }
        }
        this.addWordWrap(wordWrap, lineBreaks);
    }

    private synchronized void addWordWrap(List<String> wordWrap) {
        for (String line : wordWrap) {
            textType type = textType.DEFAULT;
            this.Lines.add(new Line(line.toString(), type));
        }
    }

    private synchronized void addWordWrap(List<String> wordWrap, List<String> LineBreaks) {
        textType lasttype = textType.DEFAULT;
        Iterator<String> wrapped = wordWrap.iterator();
        Iterator<String> breaks = LineBreaks.iterator();
        while (wrapped.hasNext()) {
            String line = wrapped.next();
            String linenum = breaks.next();
            textType type = this.parseChangelog(line.toString());
            this.Lines.add(new Line(line.toString(), type).setURL(type == textType.URL ? this.getURL(line.toString()) : ""));
        }
    }

    private String getURL(String line) {
        Pattern url = Pattern.compile("((https?|ftp|file):\\/\\/[-a-zA-Z0-9+&@#/%?=~_|!:,.;]*[-a-zA-Z0-9+&@#/%=~_|])");
        Matcher m = url.matcher(line);
        if (m.matches()) {
            if (m.find()) {
                return m.group(1);
            }
            return line;
        }
        return line;
    }

    private textType parseChangelog(String line) {
        line = line.toLowerCase();
        Pattern url = Pattern.compile("((https?|ftp|file):\\/\\/[-a-zA-Z0-9+&@#/%?=~_|!:,.;]*[-a-zA-Z0-9+&@#/%=~_|])");
        if (url.matcher(line).matches()) {
            return textType.URL;
        }
        return textType.DEFAULT;
    }

    public synchronized GuiListExtended.IGuiListEntry func_148180_b(int index) {
        return this.Lines.get(index);
    }

    protected int func_148127_b() {
        return this.Lines.size();
    }

    public void scrollByMultiplied(float p_148145_1_) {
        super.func_148145_f(MathHelper.func_76123_f((float)(p_148145_1_ * 0.025f)));
    }

    public void func_178039_p() {
        if (this.func_148141_e(this.field_148162_h)) {
            if (Mouse.getEventButton() == 0 && Mouse.getEventButtonState() && this.field_148162_h >= this.field_148153_b && this.field_148162_h <= this.field_148154_c) {
                int i = (this.field_148155_a - this.func_148139_c()) / 2;
                int j = (this.field_148155_a + this.func_148139_c()) / 2;
                int k = this.field_148162_h - this.field_148153_b - this.field_148160_j + (int)this.field_148169_q - 4;
                int l = k / this.field_148149_f;
                if (l < this.func_148127_b() && this.field_148150_g >= i && this.field_148150_g <= j && l >= 0 && k >= 0) {
                    this.func_148144_a(l, false, this.field_148150_g, this.field_148162_h);
                    this.field_148168_r = l;
                } else if (this.field_148150_g >= i && this.field_148150_g <= j && k < 0) {
                    this.func_148132_a(this.field_148150_g - i, this.field_148162_h - this.field_148153_b + (int)this.field_148169_q - 4);
                }
            }
            if (Mouse.isButtonDown((int)0) && this.func_148125_i()) {
                if (this.field_148157_o == -1) {
                    boolean flag1 = true;
                    if (this.field_148162_h >= this.field_148153_b && this.field_148162_h <= this.field_148154_c) {
                        int j2 = (this.field_148155_a - this.func_148139_c()) / 2;
                        int k2 = (this.field_148155_a + this.func_148139_c()) / 2;
                        int l2 = this.field_148162_h - this.field_148153_b - this.field_148160_j + (int)this.field_148169_q - 4;
                        int i1 = l2 / this.field_148149_f;
                        if (i1 < this.func_148127_b() && this.field_148150_g >= j2 && this.field_148150_g <= k2 && i1 >= 0 && l2 >= 0) {
                            boolean flag = i1 == this.field_148168_r && Minecraft.func_71386_F() - this.field_148167_s < 250L;
                            this.func_148144_a(i1, flag, this.field_148150_g, this.field_148162_h);
                            this.field_148168_r = i1;
                            this.field_148167_s = Minecraft.func_71386_F();
                        } else if (this.field_148150_g >= j2 && this.field_148150_g <= k2 && l2 < 0) {
                            this.func_148132_a(this.field_148150_g - j2, this.field_148162_h - this.field_148153_b + (int)this.field_148169_q - 4);
                            flag1 = false;
                        }
                        int i3 = this.func_148137_d();
                        int j1 = i3 + 6;
                        if (this.field_148150_g >= i3 && this.field_148150_g <= j1) {
                            this.field_148170_p = -1.0f;
                            int k1 = this.func_148135_f();
                            if (k1 < 1) {
                                k1 = 1;
                            }
                            int l1 = (int)((float)((this.field_148154_c - this.field_148153_b) * (this.field_148154_c - this.field_148153_b)) / (float)this.func_148138_e());
                            l1 = MathHelper.func_76125_a((int)l1, (int)32, (int)(this.field_148154_c - this.field_148153_b - 8));
                            this.field_148170_p /= (float)(this.field_148154_c - this.field_148153_b - l1) / (float)k1;
                        } else {
                            this.field_148170_p = 1.0f;
                        }
                        this.field_148157_o = flag1 ? this.field_148162_h : -2;
                    } else {
                        this.field_148157_o = -2;
                    }
                } else if (this.field_148157_o >= 0) {
                    this.field_148169_q -= (float)(this.field_148162_h - this.field_148157_o) * this.field_148170_p;
                    this.field_148157_o = this.field_148162_h;
                }
            } else {
                this.field_148157_o = -1;
                try {
                    while (!this.mc.field_71474_y.field_85185_A && Mouse.next()) {
                        float j1 = Mouse.getEventDWheel();
                        if (j1 != 0.0f) {
                            this.scrollByMultiplied((j1 *= -1.0f) * (float)this.field_148149_f / 2.0f);
                        }
                        this.mc.field_71462_r.func_146274_d();
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public void func_148128_a(int mouseX, int mouseY, float p_148128_3_) {
        this.func_178039_p();
        super.func_148128_a(mouseX, mouseY, p_148128_3_);
    }

    protected void func_148136_c(int p_148136_1_, int p_148136_2_, int p_148136_3_, int p_148136_4_) {
    }

    protected void func_192637_a(int slotIndex, int x, int y, int slotHeight, int mouseXIn, int mouseYIn, float partialTicks) {
        if (this.isYWithinSlotBounds(y)) {
            this.func_148180_b(slotIndex).func_192634_a(slotIndex, x, y, this.func_148139_c(), slotHeight, mouseXIn, mouseYIn, this.func_148141_e(mouseYIn) && this.func_148124_c(mouseXIn, mouseYIn) == slotIndex, partialTicks);
        }
    }

    protected void drawContainerBackground(Tessellator tessellator) {
        BufferBuilder buffer = tessellator.func_178180_c();
        this.mc.func_110434_K().func_110577_a(this.bg);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        float f = 32.0f;
        buffer.func_181668_a(7, DefaultVertexFormats.field_181709_i);
        buffer.func_181662_b((double)this.field_148152_e, (double)this.field_148154_c, 0.0).func_187315_a((double)((float)this.field_148152_e / f), (double)((float)(this.field_148154_c + (int)this.field_148169_q) / f)).func_181669_b(32, 32, 32, 255).func_181675_d();
        buffer.func_181662_b((double)this.field_148151_d, (double)this.field_148154_c, 0.0).func_187315_a((double)((float)this.field_148151_d / f), (double)((float)(this.field_148154_c + (int)this.field_148169_q) / f)).func_181669_b(32, 32, 32, 255).func_181675_d();
        buffer.func_181662_b((double)this.field_148151_d, (double)this.field_148153_b, 0.0).func_187315_a((double)((float)this.field_148151_d / f), (double)((float)(this.field_148153_b + (int)this.field_148169_q) / f)).func_181669_b(32, 32, 32, 255).func_181675_d();
        buffer.func_181662_b((double)this.field_148152_e, (double)this.field_148153_b, 0.0).func_187315_a((double)((float)this.field_148152_e / f), (double)((float)(this.field_148153_b + (int)this.field_148169_q) / f)).func_181669_b(32, 32, 32, 255).func_181675_d();
        tessellator.func_78381_a();
    }

    public int func_148124_c(int p_148124_1_, int p_148124_2_) {
        int i = this.field_148152_e + this.field_148155_a / 2 - this.func_148139_c() / 2;
        int j = this.field_148152_e + this.field_148155_a / 2 + this.func_148139_c() / 2;
        int k = p_148124_2_ - this.field_148153_b - this.field_148160_j + this.func_148148_g() - 4;
        int l = k / this.field_148149_f;
        return p_148124_1_ < this.func_148137_d() && p_148124_1_ >= i && p_148124_1_ <= j && l >= 0 && k >= 0 && l < this.func_148127_b() ? l : -1;
    }

    public boolean isYWithinSlotBounds(int y) {
        return y >= this.field_148153_b && y <= this.field_148154_c - 10;
    }

    public boolean func_148141_e(int p_148141_1_) {
        return p_148141_1_ >= this.field_148153_b && p_148141_1_ <= this.field_148154_c && this.field_148150_g >= this.field_148152_e && this.field_148150_g <= this.field_148151_d;
    }

    public static int textTypeColor(textType type) {
        switch (type) {
            case TITLE: {
                return RenderAssist.getColorFromRGBA(21, 153, 21, 255);
            }
            case DATE: {
                return RenderAssist.getColorFromRGBA(71, 134, 186, 255);
            }
            case CREATOR: {
                return RenderAssist.getColorFromRGBA(53, 219, 161, 255);
            }
            case HR: {
                return RenderAssist.getColorFromRGBA(71, 134, 186, 255);
            }
            case VERSION: {
                return RenderAssist.getColorFromRGBA(255, 251, 0, 255);
            }
            case HEADER: {
                return RenderAssist.getColorFromRGBA(110, 129, 255, 255);
            }
            case ADD: {
                return RenderAssist.getColorFromRGBA(0, 255, 0, 255);
            }
            case REMOVED: {
                return RenderAssist.getColorFromRGBA(255, 0, 0, 255);
            }
            case CHANGED: {
                return RenderAssist.getColorFromRGBA(255, 98, 0, 255);
            }
            case URL: {
                return Color.BLUE.getRGB();
            }
        }
        return 0xFFFFFF;
    }

    public static String textTypeText(textType type, String line) {
        switch (type) {
            case TITLE: {
                line = line.toUpperCase();
                break;
            }
            case HR: {
                String hr = "---------------------------------------------------------------------------------------";
                line = Minecraft.func_71410_x().field_71466_p.func_78269_a(hr, 300);
                break;
            }
        }
        return line;
    }

    static enum textType {
        TITLE,
        DATE,
        CREATOR,
        HR,
        DEFAULT,
        VERSION,
        HEADER,
        ADD,
        REMOVED,
        CHANGED,
        URL;

    }

    @SideOnly(value=Side.CLIENT)
    public static class Line
    implements GuiListExtended.IGuiListEntry,
    GuiYesNoCallback {
        Minecraft mc = Minecraft.func_71410_x();
        public static int LastYpos = 0;
        private String line;
        private textType type;
        private String url;
        int color;

        public Line(String line, textType type) {
            this.line = line;
            this.type = type;
            this.url = "";
        }

        public Line setURL(String url) {
            this.url = url;
            return this;
        }

        public void func_192634_a(int slotIndex, int x, int y, int listWidth, int slotHeight, int mouseX, int mouseY, boolean isSelected, float num) {
            if (this.type == textType.URL) {
                boolean b = mouseX > x && mouseX < x + listWidth && mouseY > y && mouseY < y + slotHeight;
                this.mc.field_71466_p.func_78276_b(TextScrollWindow.textTypeText(this.type, this.line), x, y, b ? RenderAssist.getColorFromRGBA(153, 204, 255, 255) : Color.BLUE.getRGB());
            } else {
                this.mc.field_71466_p.func_78276_b(TextScrollWindow.textTypeText(this.type, this.line), x, y, TextScrollWindow.textTypeColor(this.type));
            }
        }

        public boolean func_148278_a(int slotIndex, int mouseX, int mouseY, int mouseEvent, int relativeX, int relativeY) {
            if (this.type == textType.URL) {
                this.gotoHttp();
            }
            return false;
        }

        private void gotoHttp() {
            this.mc.func_147108_a((GuiScreen)new GuiConfirmOpenLink((GuiYesNoCallback)this, this.url, 0, true));
        }

        public void func_148277_b(int slotIndex, int x, int y, int mouseEvent, int relativeX, int relativeY) {
        }

        public void func_73878_a(boolean result, int id) {
            if (!result) {
                this.mc.func_147108_a(null);
                return;
            }
            try {
                Class<?> oclass = Class.forName("java.awt.Desktop");
                Object object = oclass.getMethod("getDesktop", new Class[0]).invoke(null, new Object[0]);
                oclass.getMethod("browse", URI.class).invoke(object, new URI(this.url));
            }
            catch (Throwable throwable) {
                MPUtils.logger.error("Couldn't open link", throwable);
            }
        }

        public void func_192633_a(int p_192633_1_, int p_192633_2_, int p_192633_3_, float p_192633_4_) {
        }
    }
}

