/*
 * Decompiled with CFR 0.152.
 */
package techreborn.tiles.cable;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import reborncore.api.IListInfoProvider;
import reborncore.api.IToolDrop;
import reborncore.common.RebornCoreConfig;
import reborncore.common.powerSystem.PowerSystem;
import reborncore.common.util.StringUtils;
import techreborn.blocks.cable.BlockCable;
import techreborn.blocks.cable.EnumCableType;

public class TileCable
extends TileEntity
implements ITickable,
IEnergyStorage,
IListInfoProvider,
IToolDrop {
    public int power = 0;
    private int transferRate = 0;
    private EnumCableType cableType = null;
    private ArrayList<EnumFacing> sendingFace = new ArrayList();
    int ticksSinceLastChange = 0;

    public TileCable() {
    }

    public TileCable(EnumCableType cableType) {
        this.cableType = cableType;
        this.transferRate = cableType.transferRate * RebornCoreConfig.euPerFU;
    }

    private void updateCableType() {
        if (this.cableType == null) {
            this.cableType = (EnumCableType)((Object)this.field_145850_b.func_180495_p(this.field_174879_c).func_177229_b(BlockCable.TYPE));
            this.transferRate = this.cableType.transferRate * RebornCoreConfig.euPerFU;
        }
    }

    public boolean canReceiveFromFace(EnumFacing face) {
        if (this.sendingFace.contains(face)) {
            return false;
        }
        return this.canReceive();
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (capability == CapabilityEnergy.ENERGY) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityEnergy.ENERGY) {
            return (T)CapabilityEnergy.ENERGY.cast((Object)this);
        }
        return (T)super.getCapability(capability, facing);
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        NBTTagCompound nbtTag = new NBTTagCompound();
        this.func_189515_b(nbtTag);
        return new SPacketUpdateTileEntity(this.func_174877_v(), 1, nbtTag);
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity packet) {
        this.func_145839_a(packet.func_148857_g());
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        if (compound.func_74764_b("TileCable")) {
            this.power = compound.func_74775_l("TileCable").func_74762_e("power");
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        if (this.power > 0) {
            NBTTagCompound data = new NBTTagCompound();
            data.func_74768_a("power", this.getEnergyStored());
            compound.func_74782_a("TileCable", (NBTBase)data);
        }
        return compound;
    }

    public void func_73660_a() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (this.cableType == null) {
            this.updateCableType();
        }
        ++this.ticksSinceLastChange;
        if (this.ticksSinceLastChange >= 10) {
            this.sendingFace.clear();
            this.ticksSinceLastChange = 0;
        }
        if (!this.canExtract()) {
            return;
        }
        ArrayList<IEnergyStorage> acceptors = new ArrayList<IEnergyStorage>();
        for (EnumFacing face : EnumFacing.field_82609_l) {
            IEnergyStorage energyTile;
            TileEntity tile = this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(face));
            if (tile == null) continue;
            if (tile instanceof TileCable) {
                TileCable cable = (TileCable)tile;
                if (this.power <= cable.power || !cable.canReceiveFromFace(face.func_176734_d())) continue;
                acceptors.add((IEnergyStorage)tile);
                if (this.sendingFace.contains(face)) continue;
                this.sendingFace.add(face);
                continue;
            }
            if (!tile.hasCapability(CapabilityEnergy.ENERGY, face.func_176734_d()) || (energyTile = (IEnergyStorage)tile.getCapability(CapabilityEnergy.ENERGY, face.func_176734_d())) == null || !energyTile.canReceive()) continue;
            acceptors.add(energyTile);
        }
        if (acceptors.size() > 0) {
            for (IEnergyStorage tile : acceptors) {
                int drain = Math.min(this.power, this.transferRate);
                if (drain <= 0 || tile.receiveEnergy(drain, true) <= 0) continue;
                int move = tile.receiveEnergy(drain, false);
                this.extractEnergy(move, false);
            }
        }
    }

    public int receiveEnergy(int maxReceive, boolean simulate) {
        if (!this.canReceive()) {
            return 0;
        }
        int energyReceived = Math.min(this.getMaxEnergyStored() - this.getEnergyStored(), Math.min(this.transferRate, maxReceive));
        if (!simulate) {
            this.power += energyReceived;
        }
        return energyReceived;
    }

    public int extractEnergy(int maxExtract, boolean simulate) {
        if (!this.canExtract()) {
            return 0;
        }
        int energyExtracted = Math.min(this.getEnergyStored(), Math.min(this.transferRate, maxExtract));
        if (!simulate) {
            this.power -= energyExtracted;
        }
        return energyExtracted;
    }

    public int getEnergyStored() {
        return this.power;
    }

    public int getMaxEnergyStored() {
        return this.transferRate * 5;
    }

    public boolean canExtract() {
        return this.getEnergyStored() != 0;
    }

    public boolean canReceive() {
        return this.getMaxEnergyStored() != this.getEnergyStored();
    }

    public void addInfo(List<String> info, boolean isRealTile) {
        info.add(TextFormatting.GRAY + StringUtils.t((String)"techreborn.tooltip.transferRate") + ": " + TextFormatting.GOLD + PowerSystem.getLocaliszedPowerFormatted((int)(this.transferRate / RebornCoreConfig.euPerFU)) + "/t");
        info.add(TextFormatting.GRAY + StringUtils.t((String)"techreborn.tooltip.tier") + ": " + TextFormatting.GOLD + StringUtils.toFirstCapitalAllLowercase((String)this.cableType.tier.toString()));
    }

    public ItemStack getToolDrop(EntityPlayer playerIn) {
        return this.cableType.getStack();
    }
}

