/*
 * Decompiled with CFR 0.152.
 */
package techreborn.multiblocks;

import net.minecraft.block.Block;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import reborncore.common.multiblock.IMultiblockPart;
import reborncore.common.multiblock.MultiblockControllerBase;
import reborncore.common.multiblock.MultiblockValidationException;
import reborncore.common.multiblock.rectangular.RectangularMultiblockControllerBase;
import reborncore.common.multiblock.rectangular.RectangularMultiblockTileEntityBase;
import techreborn.init.ModBlocks;

public class MultiBlockCasing
extends RectangularMultiblockControllerBase {
    public boolean hasLava;
    public boolean isStar = false;
    public int height = 0;

    public MultiBlockCasing(World world) {
        super(world);
    }

    public String getInfo() {
        String value = "Intact";
        try {
            this.isMachineWhole();
        }
        catch (MultiblockValidationException e) {
            e.printStackTrace();
            value = e.getLocalizedMessage();
        }
        return value;
    }

    protected void isMachineWhole() throws MultiblockValidationException {
        if (this.connectedParts.size() < this.getMinimumNumberOfBlocksForAssembledMachine()) {
            throw new MultiblockValidationException("Machine is too small.");
        }
        BlockPos maximumCoord = this.getMaximumCoord();
        BlockPos minimumCoord = this.getMinimumCoord();
        int deltaX = maximumCoord.func_177958_n() - minimumCoord.func_177958_n() + 1;
        int deltaY = maximumCoord.func_177956_o() - minimumCoord.func_177956_o() + 1;
        int deltaZ = maximumCoord.func_177952_p() - minimumCoord.func_177952_p() + 1;
        int maxX = this.getMaximumXSize();
        int maxY = this.getMaximumYSize();
        int maxZ = this.getMaximumZSize();
        int minX = this.getMinimumXSize();
        int minY = this.getMinimumYSize();
        int minZ = this.getMinimumZSize();
        if (maxX > 0 && deltaX > maxX) {
            throw new MultiblockValidationException(String.format("Machine is too large, it may be at most %d blocks in the X dimension", maxX));
        }
        if (maxY > 0 && deltaY > maxY) {
            throw new MultiblockValidationException(String.format("Machine is too large, it may be at most %d blocks in the Y dimension", maxY));
        }
        if (maxZ > 0 && deltaZ > maxZ) {
            throw new MultiblockValidationException(String.format("Machine is too large, it may be at most %d blocks in the Z dimension", maxZ));
        }
        if (deltaX < minX) {
            throw new MultiblockValidationException(String.format("Machine is too small, it must be at least %d blocks in the X dimension", minX));
        }
        if (deltaY < minY) {
            throw new MultiblockValidationException(String.format("Machine is too small, it must be at least %d blocks in the Y dimension", minY));
        }
        if (deltaZ < minZ) {
            throw new MultiblockValidationException(String.format("Machine is too small, it must be at least %d blocks in the Z dimension", minZ));
        }
        this.height = deltaY;
        if (deltaY < minY) {
            throw new MultiblockValidationException(String.format("Machine is too small, it must be at least %d blocks in the Y dimension", minY));
        }
        Class<?> myClass = ((Object)((Object)this)).getClass();
        for (int x = minimumCoord.func_177958_n(); x <= maximumCoord.func_177958_n(); ++x) {
            for (int y = minimumCoord.func_177956_o(); y <= maximumCoord.func_177956_o(); ++y) {
                for (int z = minimumCoord.func_177952_p(); z <= maximumCoord.func_177952_p(); ++z) {
                    RectangularMultiblockTileEntityBase part;
                    TileEntity te = this.worldObj.func_175625_s(new BlockPos(x, y, z));
                    if (te instanceof RectangularMultiblockTileEntityBase) {
                        part = (RectangularMultiblockTileEntityBase)te;
                        if (!myClass.equals(part.getMultiblockControllerType())) {
                            throw new MultiblockValidationException(String.format("Part @ %d, %d, %d is incompatible with machines of type %s", x, y, z, myClass.getSimpleName()));
                        }
                    } else {
                        part = null;
                    }
                    int extremes = 0;
                    if (x == minimumCoord.func_177958_n()) {
                        ++extremes;
                    }
                    if (y == minimumCoord.func_177956_o()) {
                        ++extremes;
                    }
                    if (z == minimumCoord.func_177952_p()) {
                        ++extremes;
                    }
                    if (x == maximumCoord.func_177958_n()) {
                        ++extremes;
                    }
                    if (y == maximumCoord.func_177956_o()) {
                        ++extremes;
                    }
                    if (z == maximumCoord.func_177952_p()) {
                        ++extremes;
                    }
                    if (extremes >= 2) {
                        if (part != null) {
                            part.isGoodForFrame();
                            continue;
                        }
                        this.isBlockGoodForFrame(this.worldObj, x, y, z);
                        continue;
                    }
                    if (extremes == 1) {
                        if (y == maximumCoord.func_177956_o()) {
                            if (part != null) {
                                part.isGoodForTop();
                                continue;
                            }
                            this.isBlockGoodForTop(this.worldObj, x, y, z);
                            continue;
                        }
                        if (y == minimumCoord.func_177956_o()) {
                            if (part != null) {
                                part.isGoodForBottom();
                                continue;
                            }
                            this.isBlockGoodForBottom(this.worldObj, x, y, z);
                            continue;
                        }
                        if (part != null) {
                            part.isGoodForSides();
                            continue;
                        }
                        this.isBlockGoodForSides(this.worldObj, x, y, z);
                        continue;
                    }
                    if (part != null) {
                        part.isGoodForInterior();
                        continue;
                    }
                    this.isBlockGoodForInterior(this.worldObj, x, y, z);
                }
            }
        }
    }

    public void onAttachedPartWithMultiblockData(IMultiblockPart part, NBTTagCompound data) {
    }

    protected void onBlockAdded(IMultiblockPart newPart) {
    }

    protected void onBlockRemoved(IMultiblockPart oldPart) {
    }

    protected void onMachineAssembled() {
    }

    protected void onMachineRestored() {
    }

    protected void onMachinePaused() {
    }

    protected void onMachineDisassembled() {
    }

    protected int getMinimumNumberOfBlocksForAssembledMachine() {
        return 1;
    }

    protected int getMaximumXSize() {
        return 3;
    }

    protected int getMaximumZSize() {
        return 3;
    }

    protected int getMaximumYSize() {
        return 4;
    }

    protected int getMinimumXSize() {
        return 3;
    }

    protected int getMinimumYSize() {
        return 3;
    }

    protected int getMinimumZSize() {
        return 3;
    }

    protected void onAssimilate(MultiblockControllerBase assimilated) {
    }

    protected void onAssimilated(MultiblockControllerBase assimilator) {
    }

    protected boolean updateServer() {
        return true;
    }

    protected void updateClient() {
    }

    public void writeToNBT(NBTTagCompound data) {
    }

    public void readFromNBT(NBTTagCompound data) {
    }

    public void formatDescriptionPacket(NBTTagCompound data) {
    }

    public void decodeDescriptionPacket(NBTTagCompound data) {
    }

    protected void isBlockGoodForInterior(World world, int x, int y, int z) throws MultiblockValidationException {
        Block block = world.func_180495_p(new BlockPos(x, y, z)).func_177230_c();
        if (!block.isAir(world.func_180495_p(new BlockPos(x, y, z)), (IBlockAccess)world, new BlockPos(x, y, z))) {
            if (block.func_149739_a().equals("tile.lava")) {
                this.hasLava = true;
            } else {
                super.isBlockGoodForInterior(world, x, y, z);
            }
        }
    }

    protected void isBlockGoodForFrame(World world, int x, int y, int z) throws MultiblockValidationException {
        Block block = world.func_180495_p(new BlockPos(x, y, z)).func_177230_c();
        if (block != ModBlocks.MACHINE_CASINGS) {
            super.isBlockGoodForFrame(world, x, y, z);
        }
    }
}

