/*
 * Decompiled with CFR 0.152.
 */
package techreborn.items.tools;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.IItemPropertyGetter;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import reborncore.api.power.IEnergyItemInfo;
import reborncore.common.powerSystem.ExternalPowerSystems;
import reborncore.common.powerSystem.PowerSystem;
import reborncore.common.powerSystem.PoweredItemContainerProvider;
import reborncore.common.powerSystem.forge.ForgePowerItemManager;
import reborncore.common.util.ChatUtils;
import reborncore.common.util.ItemUtils;
import techreborn.config.ConfigTechReborn;
import techreborn.init.ModItems;
import techreborn.lib.MessageIDs;
import techreborn.utils.TechRebornCreativeTab;

public class ItemNanosaber
extends ItemSword
implements IEnergyItemInfo {
    public static final int maxCharge = ConfigTechReborn.nanoSaberCharge;
    public int cost = 250;

    public ItemNanosaber() {
        super(Item.ToolMaterial.DIAMOND);
        this.setNoRepair();
        this.func_77637_a(TechRebornCreativeTab.instance);
        this.func_77625_d(1);
        this.func_77655_b("techreborn.nanosaber");
        this.func_185043_a(new ResourceLocation("techreborn:active"), new IItemPropertyGetter(){

            @SideOnly(value=Side.CLIENT)
            public float func_185085_a(ItemStack stack, @Nullable World worldIn, @Nullable EntityLivingBase entityIn) {
                if (ItemUtils.isActive((ItemStack)stack)) {
                    ForgePowerItemManager capEnergy = new ForgePowerItemManager(stack);
                    if ((double)(capEnergy.getMaxEnergyStored() - capEnergy.getEnergyStored()) >= 0.9 * (double)capEnergy.getMaxEnergyStored()) {
                        return 0.5f;
                    }
                    return 1.0f;
                }
                return 0.0f;
            }
        });
    }

    public boolean func_77644_a(ItemStack stack, EntityLivingBase entityHit, EntityLivingBase entityHitter) {
        ForgePowerItemManager capEnergy = new ForgePowerItemManager(stack);
        if (capEnergy.getEnergyStored() >= this.cost) {
            capEnergy.extractEnergy(this.cost, false);
            ExternalPowerSystems.requestEnergyFromArmor((ForgePowerItemManager)capEnergy, (EntityLivingBase)entityHitter);
            return true;
        }
        return false;
    }

    public Multimap<String, AttributeModifier> getAttributeModifiers(EntityEquipmentSlot slot, ItemStack stack) {
        HashMultimap multimap = HashMultimap.create();
        int modifier = 0;
        if (ItemUtils.isActive((ItemStack)stack)) {
            modifier = 9;
        }
        if (slot == EntityEquipmentSlot.MAINHAND) {
            multimap.put((Object)SharedMonsterAttributes.field_111264_e.func_111108_a(), (Object)new AttributeModifier(field_111210_e, "Weapon modifier", (double)modifier, 0));
            multimap.put((Object)SharedMonsterAttributes.field_188790_f.func_111108_a(), (Object)new AttributeModifier(field_185050_h, "Weapon modifier", (double)-2.4f, 0));
        }
        return multimap;
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (player.func_70093_af()) {
            if (new ForgePowerItemManager(stack).getEnergyStored() < this.cost) {
                ChatUtils.sendNoSpamMessages((int)MessageIDs.nanosaberID, (ITextComponent)new TextComponentString(TextFormatting.GRAY + I18n.func_135052_a((String)"techreborn.message.nanosaberEnergyErrorTo", (Object[])new Object[0]) + " " + TextFormatting.GOLD + I18n.func_135052_a((String)"techreborn.message.nanosaberActivate", (Object[])new Object[0])));
            } else if (!ItemUtils.isActive((ItemStack)stack)) {
                if (stack.func_77978_p() == null) {
                    stack.func_77982_d(new NBTTagCompound());
                }
                stack.func_77978_p().func_74757_a("isActive", true);
                if (world.field_72995_K) {
                    ChatUtils.sendNoSpamMessages((int)MessageIDs.nanosaberID, (ITextComponent)new TextComponentString(TextFormatting.GRAY + I18n.func_135052_a((String)"techreborn.message.setTo", (Object[])new Object[0]) + " " + TextFormatting.GOLD + I18n.func_135052_a((String)"techreborn.message.nanosaberActive", (Object[])new Object[0])));
                }
            } else {
                stack.func_77978_p().func_74757_a("isActive", false);
                if (world.field_72995_K) {
                    ChatUtils.sendNoSpamMessages((int)MessageIDs.nanosaberID, (ITextComponent)new TextComponentString(TextFormatting.GRAY + I18n.func_135052_a((String)"techreborn.message.setTo", (Object[])new Object[0]) + " " + TextFormatting.GOLD + I18n.func_135052_a((String)"techreborn.message.nanosaberInactive", (Object[])new Object[0])));
                }
            }
            return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
        }
        return new ActionResult(EnumActionResult.PASS, (Object)stack);
    }

    public void func_77663_a(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        if (ItemUtils.isActive((ItemStack)stack) && new ForgePowerItemManager(stack).getEnergyStored() < this.cost) {
            if (worldIn.field_72995_K) {
                ChatUtils.sendNoSpamMessages((int)MessageIDs.nanosaberID, (ITextComponent)new TextComponentString(TextFormatting.GRAY + I18n.func_135052_a((String)"techreborn.message.nanosaberEnergyError", (Object[])new Object[0]) + " " + TextFormatting.GOLD + I18n.func_135052_a((String)"techreborn.message.nanosaberDeactivating", (Object[])new Object[0])));
            }
            stack.func_77978_p().func_74757_a("isActive", false);
        }
    }

    public boolean isRepairable() {
        return false;
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        return 1.0 - ItemUtils.getPowerForDurabilityBar((ItemStack)stack);
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return true;
    }

    public int getRGBDurabilityForDisplay(ItemStack stack) {
        return PowerSystem.getDisplayPower().colour;
    }

    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable NBTTagCompound nbt) {
        return new PoweredItemContainerProvider(stack);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(CreativeTabs par2CreativeTabs, NonNullList<ItemStack> itemList) {
        if (!this.func_194125_a(par2CreativeTabs)) {
            return;
        }
        ItemStack inactiveUncharged = new ItemStack(ModItems.NANOSABER);
        inactiveUncharged.func_77982_d(new NBTTagCompound());
        inactiveUncharged.func_77978_p().func_74757_a("isActive", false);
        ItemStack inactiveCharged = new ItemStack(ModItems.NANOSABER);
        inactiveCharged.func_77982_d(new NBTTagCompound());
        inactiveCharged.func_77978_p().func_74757_a("isActive", false);
        ForgePowerItemManager capEnergy = new ForgePowerItemManager(inactiveCharged);
        capEnergy.setEnergyStored(capEnergy.getMaxEnergyStored());
        ItemStack activeCharged = new ItemStack(ModItems.NANOSABER);
        activeCharged.func_77982_d(new NBTTagCompound());
        activeCharged.func_77978_p().func_74757_a("isActive", true);
        ForgePowerItemManager capEnergy2 = new ForgePowerItemManager(activeCharged);
        capEnergy2.setEnergyStored(capEnergy2.getMaxEnergyStored());
        itemList.add((Object)inactiveUncharged);
        itemList.add((Object)inactiveCharged);
        itemList.add((Object)activeCharged);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        if (!ItemUtils.isActive((ItemStack)stack)) {
            tooltip.add(TextFormatting.GRAY + I18n.func_135052_a((String)"techreborn.message.nanosaberInactive", (Object[])new Object[0]));
        } else {
            tooltip.add(TextFormatting.GRAY + I18n.func_135052_a((String)"techreborn.message.nanosaberActive", (Object[])new Object[0]));
        }
    }

    public double getMaxPower(ItemStack stack) {
        return maxCharge;
    }

    public boolean canAcceptEnergy(ItemStack stack) {
        return true;
    }

    public boolean canProvideEnergy(ItemStack stack) {
        return false;
    }

    public double getMaxTransfer(ItemStack stack) {
        return 1000.0;
    }
}

