/*
 * Decompiled with CFR 0.152.
 */
package techreborn.init;

import net.minecraft.item.ItemStack;
import org.apache.commons.lang3.Validate;
import techreborn.api.TechRebornAPI;
import techreborn.blocks.BlockMachineFrames;
import techreborn.blocks.cable.EnumCableType;
import techreborn.config.ConfigTechReborn;
import techreborn.init.ModBlocks;
import techreborn.init.ModItems;
import techreborn.items.ingredients.ItemIngots;
import techreborn.items.ingredients.ItemParts;
import techreborn.items.ingredients.ItemPlates;

public enum IC2Duplicates {
    GRINDER(new ItemStack(ModBlocks.GRINDER)),
    ELECTRICAL_FURNACE(new ItemStack(ModBlocks.ELECTRIC_FURNACE)),
    IRON_FURNACE(new ItemStack(ModBlocks.IRON_FURNACE)),
    GENERATOR(new ItemStack(ModBlocks.SOLID_FUEL_GENEREATOR)),
    WATER_MILL(new ItemStack(ModBlocks.WATER_MILL)),
    EXTRACTOR(new ItemStack(ModBlocks.EXTRACTOR)),
    RECYCLER(new ItemStack(ModBlocks.RECYCLER)),
    COMPRESSOR(new ItemStack(ModBlocks.COMPRESSOR)),
    BAT_BOX(new ItemStack(ModBlocks.LOW_VOLTAGE_SU)),
    MFE(new ItemStack(ModBlocks.MEDIUM_VOLTAGE_SU)),
    MFSU(new ItemStack(ModBlocks.HIGH_VOLTAGE_SU)),
    LVT(new ItemStack(ModBlocks.LV_TRANSFORMER)),
    MVT(new ItemStack(ModBlocks.MV_TRANSFORMER)),
    HVT(new ItemStack(ModBlocks.HV_TRANSFORMER)),
    CABLE_COPPER(EnumCableType.COPPER.getStack()),
    CABLE_GLASSFIBER(EnumCableType.GLASSFIBER.getStack()),
    CABLE_GOLD(EnumCableType.GOLD.getStack()),
    CABLE_HV(EnumCableType.HV.getStack()),
    CABLE_ICOPPER(EnumCableType.ICOPPER.getStack()),
    CABLE_IGOLD(EnumCableType.IGOLD.getStack()),
    CABLE_IHV(EnumCableType.IHV.getStack()),
    CABLE_IIHV(EnumCableType.TIN.getStack()),
    CABLE_TIN(EnumCableType.TIN.getStack()),
    MIXED_METAL(ItemIngots.getIngotByName("mixed_metal")),
    CARBON_FIBER(ItemParts.getPartByName("carbon_fiber")),
    CARBON_MESH(ItemParts.getPartByName("carbon_mesh")),
    NEUTRON_REFLECTOR(ItemParts.getPartByName("neutron_reflector")),
    THICK_NEUTRON_REFLECTOR(ItemParts.getPartByName("thick_neutron_reflector")),
    IRIDIUM_NEUTRON_REFLECTOR(ItemParts.getPartByName("iridium_neutron_reflector")),
    SCRAP(ItemParts.getPartByName("scrap")),
    SCRAP_BOX(new ItemStack(ModItems.SCRAP_BOX)),
    FREQ_TRANSMITTER(new ItemStack(ModItems.FREQUENCY_TRANSMITTER)),
    ENERGY_CRYSTAL(new ItemStack(ModItems.ENERGY_CRYSTAL), true),
    LAPATRON_CRYSTAL(new ItemStack(ModItems.LAPOTRONIC_CRYSTAL), true),
    RE_BATTERY(new ItemStack(ModItems.RE_BATTERY), true),
    REFINED_IRON(ItemIngots.getIngotByName("refined_iron"), true),
    BASIC_MACHINE_FRAME(BlockMachineFrames.getFrameByName("basic"), true),
    ADVANCED_MACHINE_FRAME(BlockMachineFrames.getFrameByName("advanced"), true),
    CARBON_PLATE(ItemPlates.getPlateByName("carbon"), true),
    ADVANCED_ALLOY(ItemPlates.getPlateByName("advanced_alloy"), true);

    ItemStack ic2Stack;
    ItemStack trStack;
    boolean classicOnly;

    private IC2Duplicates(ItemStack trStack) {
        this(trStack, false);
    }

    private IC2Duplicates(ItemStack ic2Stack, ItemStack trStack) {
        this(ic2Stack, trStack, false);
    }

    private IC2Duplicates(ItemStack ic2Stack, ItemStack trStack, boolean classicOnly) {
        Validate.notNull((Object)trStack);
        Validate.isTrue((!trStack.func_190926_b() ? 1 : 0) != 0);
        Validate.notNull((Object)ic2Stack);
        Validate.isTrue((!ic2Stack.func_190926_b() ? 1 : 0) != 0);
        this.ic2Stack = ic2Stack;
        this.trStack = trStack;
        this.classicOnly = classicOnly;
    }

    private IC2Duplicates(ItemStack trStack, boolean classicOnly) {
        Validate.notNull((Object)trStack);
        Validate.isTrue((!trStack.func_190926_b() ? 1 : 0) != 0);
        this.trStack = trStack;
        this.classicOnly = classicOnly;
    }

    public static boolean deduplicate() {
        if (TechRebornAPI.ic2Helper == null) {
            return false;
        }
        return ConfigTechReborn.REMOVE_DUPLICATES;
    }

    public ItemStack getIc2Stack() {
        if (TechRebornAPI.ic2Helper == null) {
            throw new RuntimeException("IC2 API isnt populated");
        }
        if (this.ic2Stack.func_190926_b()) {
            throw new RuntimeException("IC2 stack wasnt set ");
        }
        return this.ic2Stack;
    }

    public void setIc2Stack(ItemStack ic2Stack) {
        Validate.notNull((Object)ic2Stack);
        Validate.isTrue((!ic2Stack.func_190926_b() ? 1 : 0) != 0);
        this.ic2Stack = ic2Stack;
    }

    public boolean hasIC2Stack() {
        if (this.ic2Stack == null) {
            return false;
        }
        return !this.ic2Stack.func_190926_b();
    }

    public ItemStack getTrStack() {
        return this.trStack;
    }

    public ItemStack getStackBasedOnConfig() {
        if (!IC2Duplicates.isClassicMode() && this.classicOnly) {
            return this.getTrStack();
        }
        if (IC2Duplicates.deduplicate()) {
            return this.getIc2Stack();
        }
        return this.getTrStack();
    }

    public static boolean isClassicMode() {
        return ConfigTechReborn.IC2_PROFILE.equals("Classic");
    }

    public static boolean isClassicalDedupe() {
        return IC2Duplicates.deduplicate() && IC2Duplicates.isClassicMode();
    }
}

