/*
 * Decompiled with CFR 0.152.
 */
package techreborn.blocks.storage;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterators;
import java.util.Iterator;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import prospector.shootingstar.ShootingStar;
import prospector.shootingstar.model.ModelCompound;
import reborncore.api.ToolManager;
import reborncore.common.BaseTileBlock;
import reborncore.common.blocks.BlockWrenchEventHandler;
import reborncore.common.items.WrenchHelper;
import techreborn.Core;
import techreborn.utils.TechRebornCreativeTab;

public abstract class BlockEnergyStorage
extends BaseTileBlock {
    public static PropertyDirection FACING = PropertyDirection.func_177712_a((String)"facing", (Predicate)Facings.ALL);
    public String name;
    public int guiID;

    public BlockEnergyStorage(String name, int guiID) {
        super(Material.field_151573_f);
        this.func_149711_c(2.0f);
        this.func_149647_a(TechRebornCreativeTab.instance);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.NORTH));
        this.name = name;
        this.guiID = guiID;
        ShootingStar.registerModel((ModelCompound)new ModelCompound("techreborn", (Block)this, "machines/energy", new IProperty[0]));
        BlockWrenchEventHandler.wrenableBlocks.add(this);
    }

    public void setFacing(EnumFacing facing, World world, BlockPos pos) {
        world.func_175656_a(pos, world.func_180495_p(pos).func_177226_a((IProperty)FACING, (Comparable)facing));
    }

    public EnumFacing getSideFromint(int i) {
        if (i == 0) {
            return EnumFacing.NORTH;
        }
        if (i == 1) {
            return EnumFacing.SOUTH;
        }
        if (i == 2) {
            return EnumFacing.EAST;
        }
        if (i == 3) {
            return EnumFacing.WEST;
        }
        if (i == 4) {
            return EnumFacing.UP;
        }
        if (i == 5) {
            return EnumFacing.DOWN;
        }
        return EnumFacing.NORTH;
    }

    public int getSideFromEnum(EnumFacing facing) {
        if (facing == EnumFacing.NORTH) {
            return 0;
        }
        if (facing == EnumFacing.SOUTH) {
            return 1;
        }
        if (facing == EnumFacing.EAST) {
            return 2;
        }
        if (facing == EnumFacing.WEST) {
            return 3;
        }
        if (facing == EnumFacing.UP) {
            return 4;
        }
        if (facing == EnumFacing.DOWN) {
            return 5;
        }
        return 0;
    }

    public EnumFacing getFacing(IBlockState state) {
        return (EnumFacing)state.func_177229_b((IProperty)FACING);
    }

    public String getSimpleName(String fullName) {
        if (fullName.equalsIgnoreCase("Batbox")) {
            return "lv_storage";
        }
        if (fullName.equalsIgnoreCase("MEDIUM_VOLTAGE_SU")) {
            return "mv_storage";
        }
        if (fullName.equalsIgnoreCase("HIGH_VOLTAGE_SU")) {
            return "hv_storage";
        }
        if (fullName.equalsIgnoreCase("AESU")) {
            return "ev_storage_adjust";
        }
        if (fullName.equalsIgnoreCase("IDSU")) {
            return "ev_storage_transmitter";
        }
        if (fullName.equalsIgnoreCase("LESU")) {
            return "ev_multi";
        }
        return fullName.toLowerCase();
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        ItemStack stack = playerIn.func_184586_b(EnumHand.MAIN_HAND);
        TileEntity tileEntity = worldIn.func_175625_s(pos);
        if (tileEntity == null) {
            return false;
        }
        if (!stack.func_190926_b() && ToolManager.INSTANCE.canHandleTool(stack) && WrenchHelper.handleWrench((ItemStack)stack, (World)worldIn, (BlockPos)pos, (EntityPlayer)playerIn, (EnumFacing)side)) {
            return true;
        }
        if (!playerIn.func_70093_af()) {
            playerIn.openGui((Object)Core.INSTANCE, this.guiID, worldIn, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
            return true;
        }
        return super.func_180639_a(worldIn, pos, state, playerIn, hand, side, hitX, hitY, hitZ);
    }

    protected BlockStateContainer func_180661_e() {
        FACING = PropertyDirection.func_177712_a((String)"facing", (Predicate)Facings.ALL);
        return new BlockStateContainer((Block)this, new IProperty[]{FACING});
    }

    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        super.func_180633_a(worldIn, pos, state, placer, stack);
        EnumFacing facing = placer.func_174811_aO().func_176734_d();
        if (placer.field_70125_A < -50.0f) {
            facing = EnumFacing.DOWN;
        } else if (placer.field_70125_A > 50.0f) {
            facing = EnumFacing.UP;
        }
        this.setFacing(facing, worldIn, pos);
    }

    public int func_176201_c(IBlockState state) {
        int facingInt = this.getSideFromEnum((EnumFacing)state.func_177229_b((IProperty)FACING));
        return facingInt;
    }

    public IBlockState func_176203_a(int meta) {
        EnumFacing facing = this.getSideFromint(meta);
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)facing);
    }

    public static enum Facings implements Predicate<EnumFacing>,
    Iterable<EnumFacing>
    {
        ALL;


        public EnumFacing[] facings() {
            return new EnumFacing[]{EnumFacing.NORTH, EnumFacing.EAST, EnumFacing.SOUTH, EnumFacing.WEST, EnumFacing.UP, EnumFacing.DOWN};
        }

        public EnumFacing random(Random rand) {
            EnumFacing[] aenumfacing = this.facings();
            return aenumfacing[rand.nextInt(aenumfacing.length)];
        }

        public boolean apply(EnumFacing p_apply_1_) {
            return p_apply_1_ != null;
        }

        @Override
        public Iterator<EnumFacing> iterator() {
            return Iterators.forArray((Object[])this.facings());
        }
    }
}

