/*
 * Decompiled with CFR 0.152.
 */
package techreborn.api;

import java.util.HashMap;
import net.minecraft.block.Block;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.ShapedRecipes;
import net.minecraft.item.crafting.ShapelessRecipes;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;
import org.apache.commons.lang3.Validate;

public class RollingMachineRecipe {
    public static final RollingMachineRecipe instance = new RollingMachineRecipe();
    private static final HashMap<ResourceLocation, IRecipe> recipes = new HashMap();

    public void addShapedOreRecipe(ResourceLocation resourceLocation, ItemStack outputItemStack, Object ... objectInputs) {
        Validate.notNull((Object)outputItemStack);
        Validate.notNull((Object)outputItemStack.func_77973_b());
        if (objectInputs.length == 0) {
            Validate.notNull(null);
        }
        recipes.put(resourceLocation, (IRecipe)new ShapedOreRecipe(resourceLocation, outputItemStack, objectInputs));
    }

    public void addShapelessOreRecipe(ResourceLocation resourceLocation, ItemStack outputItemStack, Object ... objectInputs) {
        Validate.notNull((Object)outputItemStack);
        Validate.notNull((Object)outputItemStack.func_77973_b());
        if (objectInputs.length == 0) {
            Validate.notNull(null);
        }
        recipes.put(resourceLocation, (IRecipe)new ShapelessOreRecipe(resourceLocation, outputItemStack, objectInputs));
    }

    public static ResourceLocation getNameForRecipe(ItemStack output) {
        ResourceLocation baseLoc;
        ModContainer activeContainer = Loader.instance().activeModContainer();
        ResourceLocation recipeLoc = baseLoc = new ResourceLocation(activeContainer.getModId(), output.func_77973_b().getRegistryName().func_110623_a());
        int index = 0;
        while (recipes.containsKey(recipeLoc)) {
            recipeLoc = new ResourceLocation(activeContainer.getModId(), baseLoc.func_110623_a() + "_" + ++index);
        }
        return recipeLoc;
    }

    public void addRecipe(ResourceLocation resourceLocation, ItemStack output, Object ... components) {
        String s = "";
        int i = 0;
        int j = 0;
        int k = 0;
        if (components[i] instanceof String[]) {
            String[] as = (String[])components[i++];
            for (int l = 0; l < as.length; ++l) {
                String s2 = as[l];
                ++k;
                j = s2.length();
                s = s + s2;
            }
        } else {
            while (components[i] instanceof String) {
                String s1 = (String)components[i++];
                ++k;
                j = s1.length();
                s = s + s1;
            }
        }
        HashMap<Character, ItemStack> hashmap = new HashMap<Character, ItemStack>();
        while (i < components.length) {
            Character character = (Character)components[i];
            ItemStack itemstack1 = null;
            if (components[i + 1] instanceof Item) {
                itemstack1 = new ItemStack((Item)components[i + 1]);
            } else if (components[i + 1] instanceof Block) {
                itemstack1 = new ItemStack((Block)components[i + 1], 1, -1);
            } else if (components[i + 1] instanceof ItemStack) {
                itemstack1 = (ItemStack)components[i + 1];
            }
            hashmap.put(character, itemstack1);
            i += 2;
        }
        NonNullList recipeArray = NonNullList.func_191196_a();
        for (int i1 = 0; i1 < j * k; ++i1) {
            char c = s.charAt(i1);
            if (hashmap.containsKey(Character.valueOf(c))) {
                recipeArray.set(i1, (Object)CraftingHelper.getIngredient((Object)((ItemStack)hashmap.get(Character.valueOf(c))).func_77946_l()));
                continue;
            }
            recipeArray.set(i1, (Object)CraftingHelper.getIngredient((Object)ItemStack.field_190927_a));
        }
        recipes.put(resourceLocation, (IRecipe)new ShapedRecipes("", j, k, recipeArray, output));
    }

    public void addShapelessRecipe(ResourceLocation resourceLocation, ItemStack output, Object ... components) {
        NonNullList ingredients = NonNullList.func_191196_a();
        for (int j = 0; j < components.length; ++j) {
            ingredients.add((Object)CraftingHelper.getIngredient((Object)components[j]));
        }
        recipes.put(resourceLocation, (IRecipe)new ShapelessRecipes("", output, ingredients));
    }

    public ItemStack findMatchingRecipeOutput(InventoryCrafting inv, World world) {
        for (IRecipe irecipe : recipes.values()) {
            if (!irecipe.func_77569_a(inv, world)) continue;
            return irecipe.func_77572_b(inv);
        }
        return ItemStack.field_190927_a;
    }

    public IRecipe findMatchingRecipe(InventoryCrafting inv, World world) {
        for (IRecipe irecipe : recipes.values()) {
            if (!irecipe.func_77569_a(inv, world)) continue;
            return irecipe;
        }
        return null;
    }

    public HashMap<ResourceLocation, IRecipe> getRecipeList() {
        return recipes;
    }
}

