/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbquests.net.edit;

import com.feed_the_beast.ftblib.lib.io.DataIn;
import com.feed_the_beast.ftblib.lib.io.DataOut;
import com.feed_the_beast.ftblib.lib.net.MessageToServer;
import com.feed_the_beast.ftblib.lib.net.NetworkWrapper;
import com.feed_the_beast.ftbquests.FTBQuests;
import com.feed_the_beast.ftbquests.net.edit.FTBQuestsEditNetHandler;
import com.feed_the_beast.ftbquests.net.edit.MessageCreateObjectResponse;
import com.feed_the_beast.ftbquests.quest.QuestObjectBase;
import com.feed_the_beast.ftbquests.quest.QuestObjectType;
import com.feed_the_beast.ftbquests.quest.ServerQuestFile;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;

public class MessageCreateObject
extends MessageToServer {
    private int parent;
    private QuestObjectType type;
    private NBTTagCompound nbt;
    private NBTTagCompound extra;

    public MessageCreateObject() {
    }

    public MessageCreateObject(QuestObjectBase o, @Nullable NBTTagCompound e) {
        this.parent = o.getParentID();
        this.type = o.getObjectType();
        this.nbt = new NBTTagCompound();
        o.writeData(this.nbt);
        this.extra = e;
    }

    public NetworkWrapper getWrapper() {
        return FTBQuestsEditNetHandler.EDIT;
    }

    public void writeData(DataOut data) {
        data.writeInt(this.parent);
        data.write((Object)this.type, QuestObjectType.NAME_MAP);
        data.writeNBT(this.nbt);
        data.writeNBT(this.extra);
    }

    public void readData(DataIn data) {
        this.parent = data.readInt();
        this.type = (QuestObjectType)((Object)QuestObjectType.NAME_MAP.read(data));
        this.nbt = data.readNBT();
        this.extra = data.readNBT();
    }

    public void onMessage(EntityPlayerMP player) {
        if (FTBQuests.canEdit(player)) {
            QuestObjectBase object = ServerQuestFile.INSTANCE.create(this.type, this.parent, this.extra == null ? new NBTTagCompound() : this.extra);
            object.readData(this.nbt);
            object.id = ServerQuestFile.INSTANCE.readID(0);
            object.onCreated();
            ServerQuestFile.INSTANCE.refreshIDMap();
            ServerQuestFile.INSTANCE.clearCachedData();
            ServerQuestFile.INSTANCE.save();
            new MessageCreateObjectResponse(object, this.extra).sendToAll();
        }
    }
}

