/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbquests.integration.projecte;

import com.feed_the_beast.ftblib.lib.config.ConfigGroup;
import com.feed_the_beast.ftblib.lib.config.ConfigLong;
import com.feed_the_beast.ftblib.lib.io.DataIn;
import com.feed_the_beast.ftblib.lib.io.DataOut;
import com.feed_the_beast.ftbquests.quest.ITeamData;
import com.feed_the_beast.ftbquests.quest.Quest;
import com.feed_the_beast.ftbquests.quest.task.FTBQuestsTasks;
import com.feed_the_beast.ftbquests.quest.task.ISingleLongValueTask;
import com.feed_the_beast.ftbquests.quest.task.QuestTask;
import com.feed_the_beast.ftbquests.quest.task.QuestTaskData;
import com.feed_the_beast.ftbquests.quest.task.QuestTaskType;
import com.feed_the_beast.ftbquests.quest.task.SimpleQuestTaskData;
import java.util.Collection;
import moze_intel.projecte.api.ProjectEAPI;
import moze_intel.projecte.api.capabilities.IKnowledgeProvider;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;

public class EMCTask
extends QuestTask
implements ISingleLongValueTask {
    public long value = 8192L;

    public EMCTask(Quest quest) {
        super(quest);
    }

    @Override
    public QuestTaskType getType() {
        return FTBQuestsTasks.EMC;
    }

    @Override
    public long getMaxProgress() {
        return this.value;
    }

    @Override
    public String getMaxProgressString() {
        return String.format("%,d", this.value);
    }

    @Override
    public void writeData(NBTTagCompound nbt) {
        super.writeData(nbt);
        nbt.func_74772_a("value", this.value);
    }

    @Override
    public void readData(NBTTagCompound nbt) {
        super.readData(nbt);
        this.value = nbt.func_74763_f("value");
    }

    @Override
    public void writeNetData(DataOut data) {
        super.writeNetData(data);
        data.writeVarLong(this.value);
    }

    @Override
    public void readNetData(DataIn data) {
        super.readNetData(data);
        this.value = data.readVarLong();
    }

    @Override
    public ConfigLong getDefaultValue() {
        return new ConfigLong(this.value, 1L, Long.MAX_VALUE);
    }

    @Override
    public void setValue(long v) {
        this.value = v;
    }

    @Override
    public void getConfig(ConfigGroup config) {
        super.getConfig(config);
        config.addLong("value", () -> this.value, v -> {
            this.value = v;
        }, 8192L, 1L, Long.MAX_VALUE).setDisplayName((ITextComponent)new TextComponentTranslation("ftbquests.task.ftbquests.emc", new Object[0]));
    }

    @Override
    public ITextComponent getAltDisplayName() {
        TextComponentString text = new TextComponentString(this.getMaxProgressString());
        text.func_150256_b().func_150238_a(TextFormatting.AQUA);
        return new TextComponentTranslation("ftbquests.task.ftbquests.emc", new Object[0]).func_150258_a(": ").func_150257_a((ITextComponent)text);
    }

    @Override
    public QuestTaskData createData(ITeamData data) {
        return new Data(this, data);
    }

    public static class Data
    extends SimpleQuestTaskData<EMCTask> {
        private Data(EMCTask task, ITeamData data) {
            super(task, data);
        }

        @Override
        public String getProgressString() {
            return String.format("%,d", this.progress);
        }

        @Override
        public boolean submitTask(EntityPlayerMP player, Collection<ItemStack> itemsToCheck, boolean simulate) {
            IKnowledgeProvider knowledge = ProjectEAPI.getTransmutationProxy().getKnowledgeProviderFor(player.func_110124_au());
            double emc = knowledge.getEmc();
            double add = Math.min(emc, (double)(((EMCTask)this.task).value - this.progress));
            if (add > 0.0) {
                if (!simulate) {
                    knowledge.setEmc(emc - add);
                    knowledge.sync(player);
                    this.progress = (long)((double)this.progress + add);
                    this.sync();
                }
                return true;
            }
            return false;
        }
    }
}

