/*
 * Decompiled with CFR 0.152.
 */
package techreborn.compatmod.ic2;

import ic2.api.item.IC2Items;
import net.minecraft.item.ItemStack;
import reborncore.common.util.OreUtil;
import techreborn.Core;
import techreborn.compatmod.ic2.experimental.IC2DictExperimentalClassic;
import techreborn.init.IC2Duplicates;

public class IC2Dict {
    public static final String ERROR_CLASS_NOT_FOUND = "Can't enable integration: IC2 is installed but cannot be hooked\nAre you using an incompatible IC2 version?\nPlease create an issue on GitHub and provide the FULL LOG and mod list";
    public static final String ERROR_GENERIC = "Exception thrown during IC2 integration init\nAre you using an incompatible IC2 version?\nPlease create an issue on GitHub and provide the FULL LOG and mod list\nError stack trace: ";

    public static void initDuplicates() {
        IC2Duplicates.GRINDER.setIc2Stack(IC2Dict.getItem("te", "macerator"));
        IC2Duplicates.ELECTRICAL_FURNACE.setIc2Stack(IC2Dict.getItem("te", "electric_furnace"));
        IC2Duplicates.IRON_FURNACE.setIc2Stack(IC2Dict.getItem("te", "iron_furnace"));
        IC2Duplicates.GENERATOR.setIc2Stack(IC2Dict.getItem("te", "generator"));
        IC2Duplicates.WATER_MILL.setIc2Stack(IC2Dict.getItem("te", "water_generator"));
        IC2Duplicates.EXTRACTOR.setIc2Stack(IC2Dict.getItem("te", "extractor"));
        IC2Duplicates.RECYCLER.setIc2Stack(IC2Dict.getItem("te", "recycler"));
        IC2Duplicates.COMPRESSOR.setIc2Stack(IC2Dict.getItem("te", "compressor"));
        IC2Duplicates.BAT_BOX.setIc2Stack(IC2Dict.getItem("te", "batbox"));
        IC2Duplicates.MFE.setIc2Stack(IC2Dict.getItem("te", "mfe"));
        IC2Duplicates.MFSU.setIc2Stack(IC2Dict.getItem("te", "mfsu"));
        IC2Duplicates.LVT.setIc2Stack(IC2Dict.getItem("te", "lv_transformer"));
        IC2Duplicates.MVT.setIc2Stack(IC2Dict.getItem("te", "mv_transformer"));
        IC2Duplicates.HVT.setIc2Stack(IC2Dict.getItem("te", "hv_transformer"));
        IC2Duplicates.CABLE_COPPER.setIc2Stack(IC2Dict.getIC2Cable("copper", 0));
        IC2Duplicates.CABLE_GOLD.setIc2Stack(IC2Dict.getIC2Cable("gold", 0));
        IC2Duplicates.CABLE_ICOPPER.setIc2Stack(IC2Dict.getIC2Cable("copper", 1));
        IC2Duplicates.CABLE_IGOLD.setIc2Stack(IC2Dict.getIC2Cable("gold", 1));
        IC2Duplicates.CABLE_HV.setIc2Stack(IC2Dict.getIC2Cable("iron", 0));
        IC2Duplicates.CABLE_IHV.setIc2Stack(IC2Dict.getIC2Cable("iron", 1));
        IC2Duplicates.CABLE_IIHV.setIc2Stack(IC2Dict.getIC2Cable("iron", 2));
        IC2Duplicates.CABLE_TIN.setIc2Stack(IC2Dict.getIC2Cable("tin", 0));
        IC2Duplicates.CABLE_GLASSFIBER.setIc2Stack(IC2Dict.getIC2Cable("glass", 0));
        IC2Duplicates.MIXED_METAL.setIc2Stack(IC2Dict.getItem("ingot", "alloy"));
        IC2Duplicates.CARBON_FIBER.setIc2Stack(IC2Dict.getItem("crafting", "carbon_fibre"));
        IC2Duplicates.CARBON_MESH.setIc2Stack(IC2Dict.getItem("crafting", "carbon_mesh"));
        IC2Duplicates.SCRAP.setIc2Stack(IC2Dict.getItem("crafting", "scrap"));
        IC2Duplicates.FREQ_TRANSMITTER.setIc2Stack(IC2Dict.getItem("frequency_transmitter"));
        IC2Duplicates.NEUTRON_REFLECTOR.setIc2Stack(IC2Dict.getItem("neutron_reflector"));
        IC2Duplicates.THICK_NEUTRON_REFLECTOR.setIc2Stack(IC2Dict.getItem("thick_neutron_reflector"));
        if (IC2Duplicates.isClassicMode()) {
            IC2DictExperimentalClassic.preInit();
        }
    }

    public static void initOreDictionary() {
        OreUtil.registerOre((String)"reBattery", (ItemStack)IC2Dict.wildcard(IC2Dict.getItem("re_battery")));
        OreUtil.registerOre((String)"circuitBasic", (ItemStack)IC2Dict.getItem("crafting", "circuit"));
        OreUtil.registerOre((String)"circuitAdvanced", (ItemStack)IC2Dict.getItem("crafting", "advanced_circuit"));
        OreUtil.registerOre((String)"machineBlockBasic", (ItemStack)IC2Dict.getItem("resource", "machine"));
        OreUtil.registerOre((String)"machineBlockAdvanced", (ItemStack)IC2Dict.getItem("resource", "advanced_machine"));
        OreUtil.registerOre((String)"lapotronCrystal", (ItemStack)IC2Dict.getItem("lapotron_crystal"));
        OreUtil.registerOre((String)"energyCrystal", (ItemStack)IC2Dict.wildcard(IC2Dict.getItem("energy_crystal")));
        OreUtil.registerOre((String)"drillBasic", (ItemStack)IC2Dict.getItem("drill"));
        OreUtil.registerOre((String)"drillDiamond", (ItemStack)IC2Dict.getItem("diamond_drill"));
        OreUtil.registerOre((String)"reflectorBasic", (ItemStack)IC2Dict.getItem("neutron_reflector"));
        OreUtil.registerOre((String)"reflectorThick", (ItemStack)IC2Dict.getItem("thick_neutron_reflector"));
        OreUtil.registerOre((String)"craftingIndustrialDiamond", (ItemStack)IC2Dict.getItem("crafting", "industrial_diamond"));
        OreUtil.registerOre((String)"hvTransformer", (ItemStack)IC2Dict.getItem("te", "hv_transformer"));
        OreUtil.registerOre((String)"rubberWood", (ItemStack)IC2Dict.getItem("rubber_wood"));
        OreUtil.registerOre((String)"glassReinforced", (ItemStack)IC2Dict.getItem("glass", "reinforced"));
        OreUtil.registerOre((String)"oreIridium", (ItemStack)IC2Dict.getItem("misc_resource", "iridium_ore"));
        OreUtil.registerOre((String)"logRubber", (ItemStack)IC2Dict.getItem("rubber_wood"));
        OreUtil.registerOre((String)"plateIridiumAlloy", (ItemStack)IC2Dict.getItem("crafting", "iridium"));
        OreUtil.registerOre((String)"plateAdvancedAlloy", (ItemStack)IC2Dict.getItem("crafting", "alloy"));
        OreUtil.registerOre((String)"plateCarbon", (ItemStack)IC2Dict.getItem("crafting", "carbon_plate"));
    }

    public static ItemStack getIC2Cable(String type, int insulation) {
        return IC2Dict.getItem("cable", "type:" + type + ",insulation:" + insulation);
    }

    public static ItemStack getItem(String name) {
        return IC2Dict.getItem(name, null);
    }

    public static ItemStack getItem(String name, String variant) {
        ItemStack stack = IC2Items.getItem((String)name, (String)variant);
        if (stack == null || stack.func_190926_b() || stack.func_77973_b().getRegistryName().toString().equals("ic2:itemnouse")) {
            Core.logHelper.warn((Object)("Failed to look up the IC2 item with name " + name + " and variant " + variant));
            stack = ItemStack.field_190927_a;
        }
        return stack;
    }

    public static ItemStack wildcard(ItemStack itemStack) {
        return IC2Dict.meta(itemStack, Short.MAX_VALUE);
    }

    public static ItemStack meta(ItemStack itemStack, int meta) {
        return new ItemStack(itemStack.func_77973_b(), 1, meta);
    }
}

