/*
 * Decompiled with CFR 0.152.
 */
package cassiokf.industrialrenewal.tileentity.railroad.cargoloader;

import cassiokf.industrialrenewal.IndustrialRenewal;
import cassiokf.industrialrenewal.tileentity.railroad.cargoloader.TileEntityCargoLoader;
import cassiokf.industrialrenewal.tileentity.railroad.railloader.BlockLoaderRail;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.stats.StatList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityHopper;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockCargoLoader
extends BlockContainer {
    public static final PropertyBool LOADING = PropertyBool.func_177716_a((String)"loading");
    public static final PropertyDirection FACING = BlockHorizontal.field_185512_D;
    public static final PropertyBool UNLOAD = PropertyBool.func_177716_a((String)"unload");
    protected static final AxisAlignedBB BLOCK_AABB = new AxisAlignedBB(0.0, 0.5, 0.0, 1.0, 1.0, 1.0);
    protected static final AxisAlignedBB FULL_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
    protected String name;

    public BlockCargoLoader(String name, CreativeTabs tab) {
        super(Material.field_151573_f);
        this.name = name;
        this.func_149672_a(SoundType.field_185852_e);
        this.func_149711_c(0.8f);
        this.setRegistryName("industrialrenewal", name);
        this.func_149663_c("industrialrenewal." + name);
        this.func_149647_a(tab);
        this.func_149711_c(2.0f);
        this.func_149752_b(5.0f);
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (worldIn.field_72995_K) {
            return true;
        }
        TileEntity tileentity = worldIn.func_175625_s(pos);
        if (tileentity instanceof TileEntityCargoLoader) {
            this.OpenGUI(worldIn, pos, playerIn);
            playerIn.func_71029_a(StatList.field_188084_R);
        }
        return true;
    }

    private void OpenGUI(World world, BlockPos pos, EntityPlayer player) {
        player.openGui((Object)IndustrialRenewal.instance, 2, world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
    }

    private boolean isUnload(IBlockAccess world, BlockPos pos) {
        IBlockState downState = world.func_180495_p(pos.func_177977_b());
        return !(downState.func_177230_c() instanceof BlockLoaderRail);
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        return state.func_177226_a((IProperty)UNLOAD, (Comparable)Boolean.valueOf(this.isUnload(world, pos)));
    }

    public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)placer.func_174811_aO()).func_177226_a((IProperty)LOADING, (Comparable)Boolean.valueOf(false));
    }

    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
        TileEntity tileentity = worldIn.func_175625_s(pos);
        if (tileentity instanceof TileEntityHopper) {
            InventoryHelper.func_180175_a((World)worldIn, (BlockPos)pos, (IInventory)((TileEntityHopper)tileentity));
            worldIn.func_175666_e(pos, (Block)this);
        }
        super.func_180663_b(worldIn, pos, state);
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    public boolean func_185481_k(IBlockState state) {
        return true;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING, LOADING, UNLOAD});
    }

    public boolean func_149740_M(IBlockState state) {
        return true;
    }

    public int func_180641_l(IBlockState blockState, World worldIn, BlockPos pos) {
        return Container.func_178144_a((TileEntity)worldIn.func_175625_s(pos));
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.func_176731_b((int)meta)).func_177226_a((IProperty)LOADING, (Comparable)Boolean.valueOf(false));
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176736_b();
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return face == EnumFacing.UP ? BlockFaceShape.BOWL : BlockFaceShape.UNDEFINED;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        if (((Boolean)(state = state.func_185899_b(source, pos)).func_177229_b((IProperty)UNLOAD)).booleanValue()) {
            return FULL_AABB;
        }
        return BLOCK_AABB;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public Class<TileEntityCargoLoader> getTileEntityClass() {
        return TileEntityCargoLoader.class;
    }

    @Nullable
    public TileEntityCargoLoader createTileEntity(World world, IBlockState state) {
        return new TileEntityCargoLoader();
    }

    public void registerItemModel(Item itemBlock) {
        IndustrialRenewal.proxy.registerItemRenderer(itemBlock, 0, this.name);
    }

    public Item createItemBlock() {
        return (Item)new ItemBlock((Block)this).setRegistryName(this.getRegistryName());
    }

    @Nullable
    public TileEntity func_149915_a(World worldIn, int meta) {
        return new TileEntityCargoLoader();
    }
}

