/*
 * Decompiled with CFR 0.152.
 */
package cassiokf.industrialrenewal.tileentity.locker;

import cassiokf.industrialrenewal.blocks.BlockTileEntity;
import cassiokf.industrialrenewal.tileentity.locker.TileEntityLocker;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.stats.StatList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.ILockableContainer;
import net.minecraft.world.World;

public class BlockLocker
extends BlockTileEntity<TileEntityLocker> {
    public static final PropertyDirection FACING = BlockHorizontal.field_185512_D;
    public static final PropertyBool OPEN = PropertyBool.func_177716_a((String)"open");
    public static final PropertyBool DOWN = PropertyBool.func_177716_a((String)"down");

    public BlockLocker(String name, CreativeTabs tab) {
        super(Material.field_151573_f, name, tab);
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (worldIn.field_72995_K) {
            return true;
        }
        if (playerIn.func_70093_af()) {
            worldIn.func_175656_a(pos, state.func_177231_a((IProperty)OPEN));
            return true;
        }
        ILockableContainer ilockablecontainer = this.getContainer(worldIn, pos);
        if (ilockablecontainer != null) {
            playerIn.func_71007_a((IInventory)ilockablecontainer);
            playerIn.func_71029_a(StatList.field_188063_ac);
        }
        return true;
    }

    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
        TileEntity tileentity = worldIn.func_175625_s(pos);
        if (tileentity instanceof IInventory) {
            InventoryHelper.func_180175_a((World)worldIn, (BlockPos)pos, (IInventory)((IInventory)tileentity));
            worldIn.func_175666_e(pos, (Block)this);
        }
        super.func_180663_b(worldIn, pos, state);
    }

    public boolean func_149740_M(IBlockState state) {
        return true;
    }

    public int func_180641_l(IBlockState blockState, World worldIn, BlockPos pos) {
        return Container.func_94526_b((IInventory)this.getLockableContainer(worldIn, pos));
    }

    @Nullable
    public ILockableContainer getLockableContainer(World worldIn, BlockPos pos) {
        return this.getContainer(worldIn, pos);
    }

    @Nullable
    public ILockableContainer getContainer(World worldIn, BlockPos pos) {
        TileEntity tileentity = worldIn.func_175625_s(pos);
        if (!(tileentity instanceof TileEntityLocker)) {
            return null;
        }
        return (TileEntityLocker)tileentity;
    }

    private boolean connectDown(IBlockAccess world, BlockPos pos) {
        IBlockState downState = world.func_180495_p(pos.func_177977_b());
        return downState.func_177230_c() instanceof BlockLocker;
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        return state.func_177226_a((IProperty)DOWN, (Comparable)Boolean.valueOf(this.connectDown(world, pos)));
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.func_176731_b((int)(meta & 3))).func_177226_a((IProperty)OPEN, (Comparable)Boolean.valueOf((meta & 4) > 0));
    }

    public int func_176201_c(IBlockState state) {
        int i = 0;
        i |= ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176736_b();
        if (((Boolean)state.func_177229_b((IProperty)OPEN)).booleanValue()) {
            i |= 4;
        }
        return i;
    }

    public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)placer.func_174811_aO()).func_177226_a((IProperty)OPEN, (Comparable)Boolean.valueOf(false));
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING, OPEN, DOWN});
    }

    @Deprecated
    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    @Deprecated
    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }

    @Override
    public Class<TileEntityLocker> getTileEntityClass() {
        return TileEntityLocker.class;
    }

    @Override
    @Nullable
    public TileEntityLocker createTileEntity(World world, IBlockState state) {
        return new TileEntityLocker();
    }
}

