/*
 * Decompiled with CFR 0.152.
 */
package cassiokf.industrialrenewal.tileentity.alarm;

import cassiokf.industrialrenewal.IRSoundHandler;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class TileEntityAlarm
extends TileEntity
implements ITickable {
    private final long PERIOD = 1000L;
    private long lastTime = System.currentTimeMillis() - 1000L;

    private static boolean isPoweredWire(World world, BlockPos pos) {
        return world.func_180495_p(pos).func_177230_c() == Blocks.field_150488_af && Blocks.field_150488_af.func_176211_b(world.func_180495_p(pos), (IBlockAccess)world, pos, EnumFacing.DOWN) > 0;
    }

    public void func_73660_a() {
        long thisTime = System.currentTimeMillis();
        if (thisTime - this.lastTime >= 1000L) {
            this.lastTime = thisTime;
            this.playThis();
        }
    }

    public boolean checkPowered() {
        boolean powered = this.field_145850_b.func_175640_z(this.func_174877_v()) || TileEntityAlarm.isPoweredWire(this.func_145831_w(), this.func_174877_v().func_177982_a(1, 0, 0)) || TileEntityAlarm.isPoweredWire(this.func_145831_w(), this.func_174877_v().func_177982_a(-1, 0, 0)) || TileEntityAlarm.isPoweredWire(this.func_145831_w(), this.func_174877_v().func_177982_a(0, 0, 1)) || TileEntityAlarm.isPoweredWire(this.func_145831_w(), this.func_174877_v().func_177982_a(0, 0, -1));
        return powered;
    }

    public void playThis() {
        if (this.checkPowered()) {
            this.func_145831_w().func_184133_a(null, this.func_174877_v(), IRSoundHandler.TILEENTITY_ALARM, SoundCategory.BLOCKS, 4.0f, 1.0f);
        }
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newState) {
        return oldState.func_177230_c() != newState.func_177230_c();
    }
}

