/*
 * Decompiled with CFR 0.152.
 */
package cassiokf.industrialrenewal.tileentity.alarm;

import cassiokf.industrialrenewal.blocks.BlockTileEntity;
import cassiokf.industrialrenewal.tileentity.alarm.TileEntityAlarm;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockAlarm
extends BlockTileEntity<TileEntityAlarm> {
    public static final IProperty<EnumFacing> FACING = PropertyDirection.func_177714_a((String)"facing");
    private static final AxisAlignedBB UP_BLOCK_AABB = new AxisAlignedBB(0.125, 0.0, 0.125, 0.875, 0.4375, 0.875);
    private static final AxisAlignedBB DOWN_BLOCK_AABB = new AxisAlignedBB(0.125, 1.0, 0.125, 0.875, 0.5625, 0.875);
    private static final AxisAlignedBB EAST_BLOCK_AABB = new AxisAlignedBB(0.0, 0.125, 0.125, 0.4375, 0.875, 0.875);
    private static final AxisAlignedBB WEST_BLOCK_AABB = new AxisAlignedBB(1.0, 0.125, 0.125, 0.5625, 0.875, 0.875);
    private static final AxisAlignedBB NORTH_BLOCK_AABB = new AxisAlignedBB(0.125, 0.125, 0.5625, 0.875, 0.875, 1.0);
    private static final AxisAlignedBB SOUTH_BLOCK_AABB = new AxisAlignedBB(0.125, 0.125, 0.4375, 0.875, 0.875, 0.0);

    public BlockAlarm(String name, CreativeTabs tab) {
        super(Material.field_151573_f, name, tab);
        this.func_149711_c(0.8f);
        this.func_180632_j(this.func_176223_P().func_177226_a(FACING, (Comparable)EnumFacing.UP));
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        super.func_180663_b(world, pos, state);
        world.func_175713_t(pos);
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        EnumFacing dir = (EnumFacing)state.func_177229_b(FACING);
        switch (dir) {
            case NORTH: {
                return NORTH_BLOCK_AABB;
            }
            case SOUTH: {
                return SOUTH_BLOCK_AABB;
            }
            case EAST: {
                return EAST_BLOCK_AABB;
            }
            case WEST: {
                return WEST_BLOCK_AABB;
            }
            case DOWN: {
                return DOWN_BLOCK_AABB;
            }
        }
        return UP_BLOCK_AABB;
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        return false;
    }

    public void onNeighborChange(IBlockAccess world, BlockPos pos, BlockPos neighbor) {
        if (!world.isSideSolid(pos.func_177972_a(((EnumFacing)world.func_180495_p(pos).func_177229_b(FACING)).func_176734_d()), ((EnumFacing)world.func_180495_p(pos).func_177229_b(FACING)).func_176734_d(), true)) {
            this.func_176226_b((World)world, pos, world.func_180495_p(pos), 0);
            ((World)world).func_175698_g(pos);
        }
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block blockIn, BlockPos fromPos) {
        if (!world.isSideSolid(pos.func_177972_a(((EnumFacing)world.func_180495_p(pos).func_177229_b(FACING)).func_176734_d()), ((EnumFacing)world.func_180495_p(pos).func_177229_b(FACING)).func_176734_d())) {
            this.func_176226_b(world, pos, world.func_180495_p(pos), 0);
            world.func_175698_g(pos);
        }
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING});
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(FACING, (Comparable)EnumFacing.func_82600_a((int)meta));
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b(FACING)).func_176745_a();
    }

    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        return this.func_176223_P().func_177226_a(FACING, (Comparable)facing);
    }

    @Deprecated
    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    @Deprecated
    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    @Override
    public Class<TileEntityAlarm> getTileEntityClass() {
        return TileEntityAlarm.class;
    }

    @Override
    @Nullable
    public TileEntityAlarm createTileEntity(World world, IBlockState state) {
        return new TileEntityAlarm();
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return face == ((EnumFacing)state.func_177229_b(FACING)).func_176734_d() ? BlockFaceShape.SOLID : BlockFaceShape.UNDEFINED;
    }
}

