/*
 * Decompiled with CFR 0.152.
 */
package cassiokf.industrialrenewal.network;

import cassiokf.industrialrenewal.network.PacketRecordPlayer;
import cassiokf.industrialrenewal.tileentity.recordplayer.TileEntityRecordPlayer;
import io.netty.buffer.ByteBuf;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;

public class PacketReturnRecordPlayer
implements IMessage {
    private BlockPos pos;
    private int dimension;
    private int playDisk;
    private boolean play;
    private boolean messageValid;

    public PacketReturnRecordPlayer() {
        this.messageValid = false;
    }

    public PacketReturnRecordPlayer(BlockPos pos, int dimension, int playDisk, boolean play) {
        this.dimension = dimension;
        this.pos = pos;
        this.playDisk = playDisk;
        this.play = play;
        this.messageValid = true;
    }

    public PacketReturnRecordPlayer(TileEntityRecordPlayer te) {
        this(te.func_174877_v(), te.func_145831_w().field_73011_w.getDimension(), 0, false);
    }

    public PacketReturnRecordPlayer(TileEntityRecordPlayer te, int playDisk) {
        this(te.func_174877_v(), te.func_145831_w().field_73011_w.getDimension(), playDisk, true);
    }

    public void fromBytes(ByteBuf buf) {
        try {
            this.pos = BlockPos.func_177969_a((long)buf.readLong());
            this.dimension = buf.readInt();
            this.playDisk = buf.readInt();
            this.play = buf.readBoolean();
        }
        catch (IndexOutOfBoundsException ioe) {
            System.out.println(ioe);
            return;
        }
        this.messageValid = true;
    }

    public void toBytes(ByteBuf buf) {
        if (!this.messageValid) {
            return;
        }
        buf.writeLong(this.pos.func_177986_g());
        buf.writeInt(this.dimension);
        buf.writeInt(this.playDisk);
        buf.writeBoolean(this.play);
    }

    public static class Handler
    implements IMessageHandler<PacketReturnRecordPlayer, PacketRecordPlayer> {
        public PacketRecordPlayer onMessage(PacketReturnRecordPlayer message, MessageContext ctx) {
            if (!message.messageValid && ctx.side != Side.CLIENT) {
                return null;
            }
            WorldServer world = FMLCommonHandler.instance().getMinecraftServerInstance().func_71218_a(message.dimension);
            TileEntityRecordPlayer te = (TileEntityRecordPlayer)world.func_175625_s(message.pos);
            if (te != null) {
                if (message.play) {
                    if (message.playDisk <= 3) {
                        te.playDisk(message.playDisk);
                    } else if (message.playDisk == 5) {
                        te.stop();
                    }
                }
                return new PacketRecordPlayer(te);
            }
            return null;
        }
    }
}

