/*
 * Decompiled with CFR 0.152.
 */
package cassiokf.industrialrenewal.blocks.gates;

import cassiokf.industrialrenewal.blocks.BlockBase;
import cassiokf.industrialrenewal.item.ModItems;
import java.util.EnumSet;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRedstoneWire;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;

public class BlockGateNot
extends BlockBase {
    protected static final AxisAlignedBB BLOCK_GATE_AND_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.125, 1.0);
    public static final IProperty<EnumFacing> FACING = PropertyDirection.func_177714_a((String)"facing");
    public static final PropertyBool ACTIVE = PropertyBool.func_177716_a((String)"active");

    public BlockGateNot(String name, CreativeTabs tab) {
        super(Material.field_151594_q, name, tab);
        this.func_149711_c(0.8f);
        this.func_149672_a(SoundType.field_185852_e);
    }

    public int func_180656_a(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        boolean Vactive = (Boolean)blockState.func_177229_b((IProperty)ACTIVE);
        if (!Vactive) {
            return 0;
        }
        return ((EnumFacing)blockState.func_177229_b(FACING)).func_176734_d() == side ? this.getActiveSignal(blockAccess, pos, blockState) : 0;
    }

    protected int getActiveSignal(IBlockAccess worldIn, BlockPos pos, IBlockState state) {
        return 15;
    }

    public int func_176211_b(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        return blockState.func_185911_a(blockAccess, pos, side);
    }

    protected int getPowerOnSide(IBlockAccess worldIn, BlockPos pos, EnumFacing side) {
        IBlockState iblockstate = worldIn.func_180495_p(pos);
        Block block = iblockstate.func_177230_c();
        if (block == Blocks.field_150451_bX) {
            return 15;
        }
        return block == Blocks.field_150488_af ? ((Integer)iblockstate.func_177229_b((IProperty)BlockRedstoneWire.field_176351_O)).intValue() : worldIn.func_175627_a(pos, side);
    }

    private int getPowerLevelIn1(World world, BlockPos pos) {
        EnumFacing v1Face = ((EnumFacing)world.func_180495_p(pos).func_177229_b(FACING)).func_176734_d();
        BlockPos neighborPos = pos.func_177972_a(v1Face);
        return this.getPowerOnSide((IBlockAccess)world, neighborPos, v1Face);
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos neighborPos) {
        this.change(worldIn, pos, state);
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)ACTIVE, (Comparable)Boolean.valueOf(false)));
        this.change(world, pos, state);
    }

    private void change(World worldIn, BlockPos pos, IBlockState state) {
        int powerLevel1 = this.getPowerLevelIn1(worldIn, pos);
        if (powerLevel1 > 0) {
            worldIn.func_175656_a(pos, state.func_177226_a((IProperty)ACTIVE, (Comparable)Boolean.valueOf(false)));
        }
        if (powerLevel1 <= 0) {
            worldIn.func_175656_a(pos, state.func_177226_a((IProperty)ACTIVE, (Comparable)Boolean.valueOf(true)));
        }
    }

    private boolean out(World worldIn, BlockPos pos) {
        int powerLevel1 = this.getPowerLevelIn1(worldIn, pos);
        return powerLevel1 <= 0;
    }

    protected void notifyNeighbors(World worldIn, BlockPos pos, IBlockState state) {
        EnumFacing enumfacing = (EnumFacing)state.func_177229_b(FACING);
        BlockPos blockpos = pos.func_177972_a(enumfacing.func_176734_d());
        if (ForgeEventFactory.onNeighborNotify((World)worldIn, (BlockPos)pos, (IBlockState)worldIn.func_180495_p(pos), EnumSet.of(enumfacing.func_176734_d()), (boolean)false).isCanceled()) {
            return;
        }
        worldIn.func_190524_a(blockpos, (Block)this, pos);
        worldIn.func_175695_a(blockpos, (Block)this, enumfacing);
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer entity, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (entity.field_71071_by.func_70448_g().func_77973_b() == ModItems.screwDrive) {
            this.rotateBlock(world, pos, state);
        }
        return true;
    }

    public void func_176213_c(World world, BlockPos pos, IBlockState state) {
        int i = pos.func_177958_n();
        int j = pos.func_177956_o();
        int k = pos.func_177952_p();
        world.func_175684_a(new BlockPos(i, j, k), (Block)this, this.func_149738_a(world));
        this.notifyNeighbors(world, pos, state);
    }

    public boolean func_149744_f(IBlockState state) {
        return true;
    }

    private void rotateBlock(World world, BlockPos pos, IBlockState state) {
        EnumFacing newFace = ((EnumFacing)state.func_177229_b(FACING)).func_176746_e();
        world.func_175656_a(pos, state.func_177226_a(FACING, (Comparable)newFace));
        IBlockState newState = world.func_180495_p(pos);
        this.change(world, pos, newState);
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return BLOCK_GATE_AND_AABB;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING, ACTIVE});
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(FACING, (Comparable)EnumFacing.func_82600_a((int)(meta & 7))).func_177226_a((IProperty)ACTIVE, (Comparable)Boolean.valueOf((meta & 8) > 0));
    }

    public int func_176201_c(IBlockState state) {
        int i = 0;
        i |= ((EnumFacing)state.func_177229_b(FACING)).func_176745_a();
        if (((Boolean)state.func_177229_b((IProperty)ACTIVE)).booleanValue()) {
            i |= 8;
        }
        return i;
    }

    public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        return this.func_176223_P().func_177226_a(FACING, (Comparable)placer.func_174811_aO());
    }

    @Deprecated
    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    @Deprecated
    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return face == EnumFacing.DOWN ? BlockFaceShape.SOLID : BlockFaceShape.UNDEFINED;
    }
}

