/*
 * Decompiled with CFR 0.152.
 */
package cassiokf.industrialrenewal.blocks;

import cassiokf.industrialrenewal.blocks.BlockBase;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockWindow
extends BlockBase {
    public static final ImmutableList<IProperty<Boolean>> CONNECTED_PROPERTIES = ImmutableList.copyOf((Collection)Stream.of(EnumFacing.field_82609_l).map(facing -> PropertyBool.func_177716_a((String)facing.func_176610_l())).collect(Collectors.toList()));
    private static float NORTHZ1 = 0.4375f;
    private static float SOUTHZ2 = 0.5625f;
    private static float WESTX1 = 0.4375f;
    private static float EASTX2 = 0.5625f;
    private static float DOWNY1 = 0.0f;
    private static float UPY2 = 1.0f;

    public BlockWindow(String name, CreativeTabs tab) {
        super(Material.field_151573_f, name, tab);
        this.func_149672_a(SoundType.field_185852_e);
        this.func_149711_c(0.8f);
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        IBlockState actualState = state.func_185899_b(source, pos);
        if (this.isConnected(actualState, EnumFacing.NORTH)) {
            NORTHZ1 = 0.0f;
        } else if (!this.isConnected(actualState, EnumFacing.NORTH)) {
            NORTHZ1 = 0.4375f;
        }
        if (this.isConnected(actualState, EnumFacing.SOUTH)) {
            SOUTHZ2 = 1.0f;
        } else if (!this.isConnected(actualState, EnumFacing.SOUTH)) {
            SOUTHZ2 = 0.5625f;
        }
        if (this.isConnected(actualState, EnumFacing.WEST)) {
            WESTX1 = 0.0f;
        } else if (!this.isConnected(actualState, EnumFacing.WEST)) {
            WESTX1 = 0.4375f;
        }
        if (this.isConnected(actualState, EnumFacing.EAST)) {
            EASTX2 = 1.0f;
        } else if (!this.isConnected(actualState, EnumFacing.EAST)) {
            EASTX2 = 0.5625f;
        }
        return new AxisAlignedBB((double)WESTX1, (double)DOWNY1, (double)NORTHZ1, (double)EASTX2, (double)UPY2, (double)SOUTHZ2);
    }

    public void func_185477_a(IBlockState state, World worldIn, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, @Nullable Entity entityIn, boolean isActualState) {
        if (!isActualState) {
            state = state.func_185899_b((IBlockAccess)worldIn, pos);
        }
        if (this.isConnected(state, EnumFacing.NORTH)) {
            NORTHZ1 = 0.0f;
        } else if (!this.isConnected(state, EnumFacing.NORTH)) {
            NORTHZ1 = 0.4375f;
        }
        if (this.isConnected(state, EnumFacing.SOUTH)) {
            SOUTHZ2 = 1.0f;
        } else if (!this.isConnected(state, EnumFacing.SOUTH)) {
            SOUTHZ2 = 0.5625f;
        }
        if (this.isConnected(state, EnumFacing.WEST)) {
            WESTX1 = 0.0f;
        } else if (!this.isConnected(state, EnumFacing.WEST)) {
            WESTX1 = 0.4375f;
        }
        if (this.isConnected(state, EnumFacing.EAST)) {
            EASTX2 = 1.0f;
        } else if (!this.isConnected(state, EnumFacing.EAST)) {
            EASTX2 = 0.5625f;
        }
        AxisAlignedBB AA_BB = new AxisAlignedBB((double)WESTX1, (double)DOWNY1, (double)NORTHZ1, (double)EASTX2, (double)UPY2, (double)SOUTHZ2);
        BlockWindow.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)AA_BB);
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, (IProperty[])CONNECTED_PROPERTIES.toArray((Object[])new IProperty[CONNECTED_PROPERTIES.size()]));
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P();
    }

    public int func_176201_c(IBlockState state) {
        return 0;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.TRANSLUCENT;
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    private boolean shouldRenderCenter(IBlockAccess world, BlockPos ownPos) {
        return !this.isThisConnected(world, ownPos, EnumFacing.SOUTH) && !this.isThisConnected(world, ownPos, EnumFacing.NORTH) && !this.isThisConnected(world, ownPos, EnumFacing.WEST) && !this.isThisConnected(world, ownPos, EnumFacing.EAST) || this.isThisConnected(world, ownPos, EnumFacing.SOUTH) && this.isThisConnected(world, ownPos, EnumFacing.WEST) || this.isThisConnected(world, ownPos, EnumFacing.SOUTH) && this.isThisConnected(world, ownPos, EnumFacing.EAST) || this.isThisConnected(world, ownPos, EnumFacing.NORTH) && this.isThisConnected(world, ownPos, EnumFacing.WEST) || this.isThisConnected(world, ownPos, EnumFacing.NORTH) && this.isThisConnected(world, ownPos, EnumFacing.EAST) || this.sidesConnected(world, ownPos) == 1;
    }

    private int sidesConnected(IBlockAccess world, BlockPos pos) {
        int sides = 0;
        for (EnumFacing faces : EnumFacing.field_176754_o) {
            IBlockState neighbourState = world.func_180495_p(pos.func_177972_a(faces));
            Block nb = neighbourState.func_177230_c();
            if (!(nb instanceof BlockWindow) && !nb.func_149686_d(neighbourState)) continue;
            ++sides;
        }
        return sides;
    }

    protected boolean isValidConnection(IBlockState ownState, IBlockState neighbourState, IBlockAccess world, BlockPos ownPos, EnumFacing neighbourDirection) {
        Block nb = neighbourState.func_177230_c();
        if (neighbourDirection == EnumFacing.DOWN) {
            return false;
        }
        if (neighbourDirection == EnumFacing.UP) {
            return this.shouldRenderCenter(world, ownPos);
        }
        return nb instanceof BlockWindow || nb.func_149686_d(neighbourState);
    }

    private boolean isThisConnected(IBlockAccess world, BlockPos pos, EnumFacing neighbourFacing) {
        IBlockState neighbourState = world.func_180495_p(pos.func_177972_a(neighbourFacing));
        Block nb = neighbourState.func_177230_c();
        return nb instanceof BlockWindow || nb.func_149686_d(neighbourState);
    }

    private boolean canConnectTo(IBlockState ownState, IBlockAccess worldIn, BlockPos ownPos, EnumFacing neighbourDirection) {
        BlockPos neighbourPos = ownPos.func_177972_a(neighbourDirection);
        IBlockState neighbourState = worldIn.func_180495_p(neighbourPos);
        return this.isValidConnection(ownState, neighbourState, worldIn, ownPos, neighbourDirection);
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        for (EnumFacing facing : EnumFacing.field_82609_l) {
            state = state.func_177226_a((IProperty)CONNECTED_PROPERTIES.get(facing.func_176745_a()), (Comparable)Boolean.valueOf(this.canConnectTo(state, world, pos, facing)));
        }
        return state;
    }

    public final boolean isConnected(IBlockState state, EnumFacing facing) {
        return (Boolean)state.func_177229_b((IProperty)CONNECTED_PROPERTIES.get(facing.func_176745_a()));
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        if (face == EnumFacing.EAST || face == EnumFacing.WEST || face == EnumFacing.NORTH || face == EnumFacing.SOUTH) {
            return BlockFaceShape.SOLID;
        }
        return BlockFaceShape.UNDEFINED;
    }
}

