/*
 * Decompiled with CFR 0.152.
 */
package cassiokf.industrialrenewal.blocks;

import cassiokf.industrialrenewal.blocks.BlockBase;
import cassiokf.industrialrenewal.blocks.BlockFloorLamp;
import cassiokf.industrialrenewal.blocks.ModBlocks;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemBlock;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockScaffold
extends BlockBase {
    public static final ImmutableList<IProperty<Boolean>> CONNECTED_PROPERTIES = ImmutableList.copyOf((Collection)Stream.of(EnumFacing.field_82609_l).map(facing -> PropertyBool.func_177716_a((String)facing.func_176610_l())).collect(Collectors.toList()));
    protected static final AxisAlignedBB BASE_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
    protected static final AxisAlignedBB CBASE_AABB = new AxisAlignedBB(0.1, 0.0, 0.1, 0.9, 1.0, 0.9);

    public BlockScaffold(String name, CreativeTabs tab) {
        super(Material.field_151578_c, name, tab);
        this.func_149672_a(SoundType.field_185852_e);
        this.func_149711_c(0.5f);
    }

    @Nullable
    public String getHarvestTool(IBlockState state) {
        return "pickaxe";
    }

    public boolean isLadder(IBlockState state, IBlockAccess world, BlockPos pos, EntityLivingBase entity) {
        return true;
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (player.field_71071_by.func_70448_g().func_77973_b() == ItemBlock.func_150898_a((Block)ModBlocks.scaffold)) {
            int n = 1;
            while (world.func_180495_p(pos.func_177981_b(n)).func_177230_c() instanceof BlockScaffold) {
                ++n;
            }
            if (world.func_180495_p(pos.func_177981_b(n)).func_177230_c().isAir(world.func_180495_p(pos.func_177981_b(n)), (IBlockAccess)world, pos.func_177981_b(n))) {
                world.func_180501_a(pos.func_177981_b(n), ModBlocks.scaffold.func_176223_P(), 3);
                if (!player.func_184812_l_()) {
                    player.field_71071_by.func_174925_a(ItemBlock.func_150898_a((Block)ModBlocks.scaffold), 0, 1, null);
                }
                return true;
            }
            return false;
        }
        return false;
    }

    public void onNeighborChange(IBlockAccess world, BlockPos pos, BlockPos neighbor) {
        if (!world.isSideSolid(pos.func_177972_a(EnumFacing.DOWN), EnumFacing.UP, true)) {
            this.func_176226_b((World)world, pos, world.func_180495_p(pos), 0);
            ((World)world).func_175698_g(pos);
        }
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block blockIn, BlockPos fromPos) {
        if (!world.isSideSolid(pos.func_177972_a(EnumFacing.DOWN), EnumFacing.UP, true)) {
            this.func_176226_b(world, pos, world.func_180495_p(pos), 0);
            world.func_175698_g(pos);
        }
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return BASE_AABB;
    }

    public void func_185477_a(IBlockState state, World worldIn, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, @Nullable Entity entityIn, boolean isActualState) {
        if (!isActualState) {
            state = state.func_185899_b((IBlockAccess)worldIn, pos);
        }
        BlockScaffold.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)CBASE_AABB);
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, (IProperty[])CONNECTED_PROPERTIES.toArray((Object[])new IProperty[CONNECTED_PROPERTIES.size()]));
    }

    protected boolean isValidConnection(IBlockState ownState, IBlockState neighbourState, IBlockAccess world, BlockPos ownPos, EnumFacing neighbourDirection) {
        Block nb = neighbourState.func_177230_c();
        Block nbd = world.func_180495_p(ownPos.func_177972_a(neighbourDirection).func_177977_b()).func_177230_c();
        if (neighbourDirection == EnumFacing.DOWN) {
            return nb.func_149686_d(neighbourState);
        }
        if (neighbourDirection != EnumFacing.UP) {
            return !this.isConnected(ownState, EnumFacing.UP) && !(nb instanceof BlockScaffold) && !(nbd instanceof BlockScaffold);
        }
        return nb.func_149686_d(neighbourState) || nb instanceof BlockScaffold;
    }

    private boolean canConnectTo(IBlockState ownState, IBlockAccess worldIn, BlockPos ownPos, EnumFacing neighbourDirection) {
        BlockPos neighbourPos = ownPos.func_177972_a(neighbourDirection);
        IBlockState neighbourState = worldIn.func_180495_p(neighbourPos);
        Block neighbourBlock = neighbourState.func_177230_c();
        boolean neighbourIsValidForThis = this.isValidConnection(ownState, neighbourState, worldIn, ownPos, neighbourDirection);
        boolean thisIsValidForNeighbour = !(neighbourBlock instanceof BlockFloorLamp) || ((BlockFloorLamp)neighbourBlock).isValidConnection(neighbourState, ownState, worldIn, neighbourPos, neighbourDirection.func_176734_d());
        return neighbourIsValidForThis && thisIsValidForNeighbour;
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        for (EnumFacing facing : EnumFacing.field_82609_l) {
            state = state.func_177226_a((IProperty)CONNECTED_PROPERTIES.get(facing.func_176745_a()), (Comparable)Boolean.valueOf(this.canConnectTo(state, world, pos, facing)));
        }
        return state;
    }

    public final boolean isConnected(IBlockState state, EnumFacing facing) {
        return (Boolean)state.func_177229_b((IProperty)CONNECTED_PROPERTIES.get(facing.func_176745_a()));
    }

    public boolean func_176196_c(World worldIn, BlockPos pos) {
        return worldIn.func_180495_p(pos.func_177977_b()).isSideSolid((IBlockAccess)worldIn, pos.func_177977_b(), EnumFacing.UP);
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P();
    }

    public int func_176201_c(IBlockState state) {
        return 0;
    }

    @Deprecated
    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    @Deprecated
    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    @Deprecated
    public boolean func_185481_k(IBlockState state) {
        return true;
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        if (face == EnumFacing.UP) {
            return BlockFaceShape.SOLID;
        }
        return BlockFaceShape.UNDEFINED;
    }

    public void func_180634_a(World worldIn, BlockPos pos, IBlockState state, Entity entityIn) {
        super.func_180634_a(worldIn, pos, state, entityIn);
        if (entityIn instanceof EntityLivingBase && !((EntityLivingBase)entityIn).func_70617_f_() && this.isLadder(state, (IBlockAccess)worldIn, pos, (EntityLivingBase)entityIn)) {
            float f5 = 0.15f;
            if (entityIn.field_70159_w < (double)(-f5)) {
                entityIn.field_70159_w = -f5;
            }
            if (entityIn.field_70159_w > (double)f5) {
                entityIn.field_70159_w = f5;
            }
            if (entityIn.field_70179_y < (double)(-f5)) {
                entityIn.field_70179_y = -f5;
            }
            if (entityIn.field_70179_y > (double)f5) {
                entityIn.field_70179_y = f5;
            }
            entityIn.field_70143_R = 0.0f;
            if (entityIn.field_70181_x < -0.15) {
                entityIn.field_70181_x = -0.15;
            }
            if (entityIn.field_70181_x < 0.0 && entityIn instanceof EntityPlayer && entityIn.func_70093_af()) {
                entityIn.field_70181_x = 0.0;
                return;
            }
            if (entityIn.field_70123_F) {
                entityIn.field_70181_x = 0.2;
            }
        }
    }
}

