/*
 * Decompiled with CFR 0.152.
 */
package cassiokf.industrialrenewal.blocks;

import cassiokf.industrialrenewal.blocks.BlockBase;
import cassiokf.industrialrenewal.blocks.BlockCatwalkLadder;
import cassiokf.industrialrenewal.blocks.BlockFloorCable;
import cassiokf.industrialrenewal.blocks.BlockFloorLamp;
import cassiokf.industrialrenewal.blocks.BlockFloorPipe;
import cassiokf.industrialrenewal.blocks.ModBlocks;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDoor;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemBlock;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockIndustrialFloor
extends BlockBase {
    public static final ImmutableList<IProperty<Boolean>> CONNECTED_PROPERTIES = ImmutableList.copyOf((Collection)Stream.of(EnumFacing.field_82609_l).map(facing -> PropertyBool.func_177716_a((String)facing.func_176610_l())).collect(Collectors.toList()));
    protected static final AxisAlignedBB UP_AABB = new AxisAlignedBB(0.0, 0.875, 0.0, 1.0, 1.0, 1.0);
    protected static final AxisAlignedBB UP_DOWN_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
    protected static final AxisAlignedBB DOWN_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.125, 1.0);
    protected static final AxisAlignedBB NONE_AABB = new AxisAlignedBB(0.3125, 0.3125, 0.3125, 0.6875, 0.6875, 0.6875);
    protected static final AxisAlignedBB C_UP_AABB = new AxisAlignedBB(0.0, 0.9375, 0.0, 1.0, 1.0, 1.0);
    protected static final AxisAlignedBB C_DOWN_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.0625, 1.0);
    protected static final AxisAlignedBB C_NORTH_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 0.0625);
    protected static final AxisAlignedBB C_SOUTH_AABB = new AxisAlignedBB(0.0, 0.0, 0.9375, 1.0, 1.0, 1.0);
    protected static final AxisAlignedBB C_WEST_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 0.0625, 1.0, 1.0);
    protected static final AxisAlignedBB C_EAST_AABB = new AxisAlignedBB(0.9375, 0.0, 0.0, 1.0, 1.0, 1.0);

    public BlockIndustrialFloor(String name, CreativeTabs tab) {
        super(Material.field_151573_f, name, tab);
        this.func_149711_c(0.8f);
        this.func_149672_a(SoundType.field_185852_e);
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        IBlockState actualState = this.func_176221_a(state, source, pos);
        if (this.isConnected(actualState, EnumFacing.UP) && !this.isConnected(actualState, EnumFacing.DOWN)) {
            return UP_AABB;
        }
        if (!this.isConnected(actualState, EnumFacing.UP) && this.isConnected(actualState, EnumFacing.DOWN)) {
            return DOWN_AABB;
        }
        if (!this.isConnected(actualState, EnumFacing.UP) && !this.isConnected(actualState, EnumFacing.DOWN)) {
            return NONE_AABB;
        }
        return UP_DOWN_AABB;
    }

    public void func_185477_a(IBlockState state, World worldIn, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, @Nullable Entity entityIn, boolean isActualState) {
        IBlockState actualState = this.func_176221_a(state, (IBlockAccess)worldIn, pos);
        if (this.isConnected(actualState, EnumFacing.UP)) {
            BlockIndustrialFloor.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)C_UP_AABB);
        }
        if (this.isConnected(actualState, EnumFacing.DOWN)) {
            BlockIndustrialFloor.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)C_DOWN_AABB);
        }
        if (this.isConnected(actualState, EnumFacing.NORTH)) {
            BlockIndustrialFloor.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)C_NORTH_AABB);
        }
        if (this.isConnected(actualState, EnumFacing.SOUTH)) {
            BlockIndustrialFloor.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)C_SOUTH_AABB);
        }
        if (this.isConnected(actualState, EnumFacing.WEST)) {
            BlockIndustrialFloor.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)C_WEST_AABB);
        }
        if (this.isConnected(actualState, EnumFacing.EAST)) {
            BlockIndustrialFloor.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)C_EAST_AABB);
        }
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, (IProperty[])CONNECTED_PROPERTIES.toArray((Object[])new IProperty[CONNECTED_PROPERTIES.size()]));
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P();
    }

    public int func_176201_c(IBlockState state) {
        return 0;
    }

    protected boolean isValidConnection(IBlockState ownState, IBlockState neighbourState, IBlockAccess world, BlockPos ownPos, EnumFacing neighbourDirection) {
        Block nb = neighbourState.func_177230_c();
        return nb instanceof BlockIndustrialFloor || nb instanceof BlockFloorLamp || nb instanceof BlockFloorPipe || nb instanceof BlockFloorCable || neighbourDirection != EnumFacing.DOWN && neighbourDirection != EnumFacing.UP && nb instanceof BlockDoor || neighbourDirection == EnumFacing.DOWN && nb instanceof BlockCatwalkLadder || (neighbourDirection == EnumFacing.NORTH || neighbourDirection == EnumFacing.SOUTH || neighbourDirection == EnumFacing.EAST || neighbourDirection == EnumFacing.WEST) && nb instanceof BlockCatwalkLadder && (Boolean)neighbourState.func_177229_b((IProperty)BlockCatwalkLadder.ACTIVE) == false;
    }

    private boolean canConnectTo(IBlockState ownState, IBlockAccess worldIn, BlockPos ownPos, EnumFacing neighbourDirection) {
        BlockPos neighbourPos = ownPos.func_177972_a(neighbourDirection);
        IBlockState neighbourState = worldIn.func_180495_p(neighbourPos);
        Block neighbourBlock = neighbourState.func_177230_c();
        boolean neighbourIsValidForThis = !this.isValidConnection(ownState, neighbourState, worldIn, ownPos, neighbourDirection);
        boolean thisIsValidForNeighbour = !(neighbourBlock instanceof BlockIndustrialFloor) || ((BlockIndustrialFloor)neighbourBlock).isValidConnection(neighbourState, ownState, worldIn, neighbourPos, neighbourDirection.func_176734_d());
        return neighbourIsValidForThis && thisIsValidForNeighbour;
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        for (EnumFacing facing : EnumFacing.field_82609_l) {
            state = state.func_177226_a((IProperty)CONNECTED_PROPERTIES.get(facing.func_176745_a()), (Comparable)Boolean.valueOf(this.canConnectTo(state, world, pos, facing)));
        }
        return state;
    }

    public final boolean isConnected(IBlockState state, EnumFacing facing) {
        return (Boolean)state.func_177229_b((IProperty)CONNECTED_PROPERTIES.get(facing.func_176745_a()));
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer entity, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        int i = pos.func_177958_n();
        int j = pos.func_177956_o();
        int k = pos.func_177952_p();
        if (entity.field_71071_by.func_70448_g().func_77973_b() == ItemBlock.func_150898_a((Block)ModBlocks.fluidPipe)) {
            world.func_184148_a(null, (double)i + 0.5, (double)j + 0.5, (double)k + 0.5, (SoundEvent)SoundEvent.field_187505_a.func_82594_a((Object)new ResourceLocation("block.metal.place")), SoundCategory.NEUTRAL, 1.0f, 1.0f);
            world.func_180501_a(new BlockPos(i, j, k), ModBlocks.floorPipe.func_176223_P(), 3);
            if (!entity.func_184812_l_()) {
                entity.field_71071_by.func_174925_a(ItemBlock.func_150898_a((Block)ModBlocks.fluidPipe), 0, 1, null);
            }
            return true;
        }
        if (entity.field_71071_by.func_70448_g().func_77973_b() == ItemBlock.func_150898_a((Block)ModBlocks.energyCable)) {
            world.func_184148_a(null, (double)i + 0.5, (double)j + 0.5, (double)k + 0.5, (SoundEvent)SoundEvent.field_187505_a.func_82594_a((Object)new ResourceLocation("block.metal.place")), SoundCategory.NEUTRAL, 1.0f, 1.0f);
            world.func_180501_a(new BlockPos(i, j, k), ModBlocks.floorCable.func_176223_P(), 3);
            if (!entity.func_184812_l_()) {
                entity.field_71071_by.func_174925_a(ItemBlock.func_150898_a((Block)ModBlocks.energyCable), 0, 1, null);
            }
            return true;
        }
        if (entity.field_71071_by.func_70448_g().func_77973_b() == ItemBlock.func_150898_a((Block)ModBlocks.fluorescent)) {
            world.func_184148_a(null, (double)i + 0.5, (double)j + 0.5, (double)k + 0.5, (SoundEvent)SoundEvent.field_187505_a.func_82594_a((Object)new ResourceLocation("block.metal.place")), SoundCategory.NEUTRAL, 1.0f, 1.0f);
            world.func_180501_a(pos, ModBlocks.floorLamp.func_176223_P(), 3);
            if (entity.func_174811_aO() == EnumFacing.EAST || entity.func_174811_aO() == EnumFacing.WEST) {
                world.func_180501_a(pos.func_177984_a(), ModBlocks.dummy.func_176223_P(), 3);
            }
            if (!entity.func_184812_l_()) {
                entity.field_71071_by.func_174925_a(ItemBlock.func_150898_a((Block)ModBlocks.fluorescent), 0, 1, null);
            }
            return true;
        }
        return false;
    }

    @Deprecated
    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    @Deprecated
    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    @Deprecated
    public boolean func_185481_k(IBlockState state) {
        return true;
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        if (face == EnumFacing.UP || face == EnumFacing.DOWN) {
            return BlockFaceShape.SOLID;
        }
        return BlockFaceShape.UNDEFINED;
    }
}

