/*
 * Decompiled with CFR 0.152.
 */
package modulardiversity.tile.base;

import hellfirepvp.modularmachinery.common.tiles.base.MachineComponentTile;
import hellfirepvp.modularmachinery.common.tiles.base.TileColorableMachineComponent;
import mekanism.api.lasers.ILaserReceptor;
import modulardiversity.components.requirements.RequirementMekLaser;
import modulardiversity.util.ICraftingResourceHolder;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;

public abstract class TileEntityMekLaser
extends TileColorableMachineComponent
implements MachineComponentTile,
ILaserReceptor,
ICraftingResourceHolder<RequirementMekLaser.ResourceToken> {
    private double energy = 0.0;
    private double capacity = 5.0E9;
    @CapabilityInject(value=ILaserReceptor.class)
    public static Capability<ILaserReceptor> LASER_RECEPTOR_CAPABILITY = null;

    public void readCustomNBT(NBTTagCompound compound) {
        super.readCustomNBT(compound);
        this.energy = compound.func_74769_h("energy");
    }

    public void writeCustomNBT(NBTTagCompound compound) {
        super.writeCustomNBT(compound);
        compound.func_74780_a("energy", this.energy);
    }

    public void receiveLaserEnergy(double v, EnumFacing enumFacing) {
        this.setEnergy(v + this.energy);
    }

    public boolean canLasersDig() {
        return false;
    }

    @Override
    public boolean consume(RequirementMekLaser.ResourceToken token, boolean doConsume) {
        double energyConsumed = Math.min(this.getEnergy(), token.getEnergy());
        token.setEnergy(token.getEnergy() - energyConsumed);
        if (doConsume) {
            this.setEnergy(this.getEnergy() - energyConsumed);
        }
        return energyConsumed > 0.0;
    }

    @Override
    public boolean generate(RequirementMekLaser.ResourceToken token, boolean doGenerate) {
        return false;
    }

    public void setEnergy(double energy) {
        this.energy = Math.max(0.0, Math.min(energy, this.capacity));
    }

    public double getEnergy() {
        return this.energy;
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing side) {
        return capability == LASER_RECEPTOR_CAPABILITY || super.hasCapability(capability, side);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing side) {
        if (capability == LASER_RECEPTOR_CAPABILITY) {
            return (T)this;
        }
        return (T)super.getCapability(capability, side);
    }
}

